/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.odlext.model.api.ContextReferenceEffectiveStatement;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.InputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;

public abstract class RpcRoutingStrategy
implements Identifiable<QName> {
    private final @NonNull QName identifier;

    private RpcRoutingStrategy(QName identifier) {
        this.identifier = Objects.requireNonNull(identifier);
    }

    public abstract QName getLeaf();

    public abstract QName getContext();

    public final QName getIdentifier() {
        return this.identifier;
    }

    public abstract boolean isContextBasedRouted();

    public static RpcRoutingStrategy from(RpcDefinition rpc) {
        for (EffectiveStatement stmt : ((InputEffectiveStatement)rpc.getInput().asEffectiveStatement()).effectiveSubstatements()) {
            Optional context;
            if (!(stmt instanceof SchemaTreeEffectiveStatement) || !(context = stmt.findFirstEffectiveSubstatementArgument(ContextReferenceEffectiveStatement.class)).isPresent()) continue;
            return new RoutedRpcStrategy(rpc.getQName(), (QName)context.orElseThrow(), (QName)((SchemaTreeEffectiveStatement)stmt).argument());
        }
        return new GlobalRpcStrategy(rpc.getQName());
    }

    private static final class GlobalRpcStrategy
    extends RpcRoutingStrategy {
        GlobalRpcStrategy(QName identifier) {
            super(identifier);
        }

        @Override
        public boolean isContextBasedRouted() {
            return false;
        }

        @Override
        public QName getContext() {
            throw new UnsupportedOperationException("Non-routed strategy does not have a context");
        }

        @Override
        public QName getLeaf() {
            throw new UnsupportedOperationException("Non-routed strategy does not have a context");
        }
    }

    private static final class RoutedRpcStrategy
    extends RpcRoutingStrategy {
        private final QName context;
        private final QName leaf;

        private RoutedRpcStrategy(QName identifier, QName ctx, QName leaf) {
            super(identifier);
            this.context = Objects.requireNonNull(ctx);
            this.leaf = Objects.requireNonNull(leaf);
        }

        @Override
        public QName getContext() {
            return this.context;
        }

        @Override
        public QName getLeaf() {
            return this.leaf;
        }

        @Override
        public boolean isContextBasedRouted() {
            return true;
        }
    }
}

