/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.RegexPatterns;

public final class CodeHelpers {
    private CodeHelpers() {
    }

    public static void validValue(boolean expression, Object value, String options) {
        Preconditions.checkArgument((boolean)expression, (String)"expected one of: %s \n%but was: %s", (Object)options, (Object)value);
    }

    public static <T> @NonNull T require(@Nullable T value, @NonNull String name) {
        if (value == null) {
            throw new NoSuchElementException("Value of " + name + " is not present");
        }
        return value;
    }

    public static <T> @NonNull T requireKeyProp(@Nullable T value, @NonNull String name) {
        if (value == null) {
            throw new NullPointerException("Key component \"" + name + "\" may not be null");
        }
        return value;
    }

    public static void requireValue(@Nullable Object value) {
        Objects.requireNonNull(value, "Supplied value may not be null");
    }

    public static void appendValue(MoreObjects.ToStringHelper helper, @NonNull String name, @Nullable Object value) {
        if (value != null) {
            helper.add(name, value);
        }
    }

    public static void appendValue(MoreObjects.ToStringHelper helper, String name, byte[] value) {
        if (value != null) {
            helper.add(name, (Object)Arrays.toString(value));
        }
    }

    public static void appendAugmentations(MoreObjects.ToStringHelper helper, String name, Augmentable<?> augmentable) {
        Map<Class<Augmentation<?>>, Augmentation<?>> augments = augmentable.augmentations();
        if (!augments.isEmpty()) {
            helper.add(name, augments.values());
        }
    }

    public static Pattern @NonNull [] compilePatterns(@NonNull List<String> patterns) {
        int size = patterns.size();
        Verify.verify((size > 1 ? 1 : 0) != 0, (String)"Patterns has to have at least 2 elements", (Object[])new Object[0]);
        Pattern[] result = new Pattern[size];
        for (int i = 0; i < size; ++i) {
            result[i] = Pattern.compile(patterns.get(i));
        }
        return result;
    }

    public static void checkPattern(String value, Pattern pattern, String regex) {
        if (!pattern.matcher(value).matches()) {
            String match = RegexPatterns.isNegatedPattern(pattern) ? "matches forbidden" : "does not match required";
            throw new IllegalArgumentException("Supplied value \"" + value + "\" " + match + " pattern \"" + regex + "\"");
        }
    }

    public static void checkPattern(String value, Pattern[] patterns, String[] regexes) {
        Verify.verify((patterns.length == regexes.length ? 1 : 0) != 0, (String)"Patterns and regular expression lengths have to match", (Object[])new Object[0]);
        for (int i = 0; i < patterns.length; ++i) {
            CodeHelpers.checkPattern(value, patterns[i], regexes[i]);
        }
    }

    public static void throwInvalidLength(String expected, Object actual) {
        throw new IllegalArgumentException("Invalid length: " + actual + ", expected: " + expected + ".");
    }

    public static void throwInvalidLength(String expected, byte[] actual) {
        CodeHelpers.throwInvalidLength(expected, Arrays.toString(actual));
    }

    public static void throwInvalidRange(String expected, Object actual) {
        throw new IllegalArgumentException("Invalid range: " + actual + ", expected: " + expected + ".");
    }

    public static void throwInvalidRange(String expected, int actual) {
        throw new IllegalArgumentException("Invalid range: " + actual + ", expected: " + expected + ".");
    }

    public static void throwInvalidRange(String expected, long actual) {
        throw new IllegalArgumentException("Invalid range: " + actual + ", expected: " + expected + ".");
    }

    public static void throwInvalidRange(Object[] expected, Object actual) {
        CodeHelpers.throwInvalidRange(Arrays.toString(expected), actual);
    }

    public static void throwInvalidRangeUnsigned(String expected, long actual) {
        throw new IllegalArgumentException("Invalid range: " + Long.toUnsignedString(actual) + ", expected: " + expected + ".");
    }

    public static <T> @NonNull List<T> nonnull(@Nullable List<T> input) {
        return input != null ? input : ImmutableList.of();
    }

    public static <K, V> @NonNull Map<K, V> nonnull(@Nullable Map<K, V> input) {
        return input != null ? input : ImmutableMap.of();
    }

    public static <T> @Nullable List<T> emptyToNull(@Nullable List<T> input) {
        return input != null && input.isEmpty() ? null : input;
    }

    public static <K, V> @Nullable Map<K, V> emptyToNull(@Nullable Map<K, V> input) {
        return input != null && input.isEmpty() ? null : input;
    }

    public static int wrapperHashCode(@Nullable Object obj) {
        return CodeHelpers.wrapHashCode(Objects.hashCode(obj));
    }

    public static int wrapperHashCode(byte @Nullable [] obj) {
        return CodeHelpers.wrapHashCode(Arrays.hashCode(obj));
    }

    public static <T extends DataObject> @Nullable T checkCast(@NonNull Class<T> requiredClass, @Nullable Object obj) {
        return (T)(obj instanceof DataObject && requiredClass.equals(((DataObject)obj).implementedInterface()) ? (DataObject)requiredClass.cast(obj) : null);
    }

    public static <T> @Nullable T checkFieldCast(@NonNull Class<T> requiredClass, @NonNull String fieldName, @Nullable Object obj) {
        try {
            return requiredClass.cast(obj);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Invalid input value for property \"" + fieldName + "\"", e);
        }
    }

    public static <T extends BaseIdentity> @Nullable Class<? extends T> checkFieldCastIdentity(@NonNull Class<T> requiredClass, @NonNull String fieldName, @Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        Preconditions.checkArgument((boolean)(obj instanceof Class), (String)"Invalid input value \"%s\" for property \"%s\"", (Object)obj, (Object)fieldName);
        try {
            return ((Class)obj).asSubclass(requiredClass);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Invalid input value \"" + obj + "\" for property \"" + fieldName + "\"", e);
        }
    }

    public static <T> @Nullable List<T> checkListFieldCast(@NonNull Class<?> requiredClass, @NonNull String fieldName, @Nullable List<?> list) {
        CodeHelpers.checkCollectionField(requiredClass, fieldName, list);
        return list;
    }

    public static <T extends BaseIdentity> @Nullable List<Class<? extends T>> checkListFieldCastIdentity(@NonNull Class<T> requiredClass, @NonNull String fieldName, @Nullable List<?> list) {
        CodeHelpers.checkCollectionFieldIdentity(requiredClass, fieldName, list);
        return list;
    }

    public static <T> @Nullable Set<T> checkSetFieldCast(@NonNull Class<?> requiredClass, @NonNull String fieldName, @Nullable Set<?> set) {
        CodeHelpers.checkCollectionField(requiredClass, fieldName, set);
        return set;
    }

    public static <T extends BaseIdentity> @Nullable Set<Class<? extends T>> checkSetFieldCastIdentity(@NonNull Class<T> requiredClass, @NonNull String fieldName, @Nullable Set<?> set) {
        CodeHelpers.checkCollectionFieldIdentity(requiredClass, fieldName, set);
        return set;
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"}, justification="Internal NPE->IAE conversion")
    private static void checkCollectionField(@NonNull Class<?> requiredClass, @NonNull String fieldName, @Nullable Collection<?> collection) {
        if (collection != null) {
            try {
                collection.forEach(item -> requiredClass.cast(Objects.requireNonNull(item)));
            }
            catch (ClassCastException | NullPointerException e) {
                throw new IllegalArgumentException("Invalid input item for property \"" + Objects.requireNonNull(fieldName) + "\"", e);
            }
        }
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"}, justification="Internal NPE->IAE conversion")
    private static void checkCollectionFieldIdentity(@NonNull Class<?> requiredClass, @NonNull String fieldName, @Nullable Collection<?> collection) {
        if (collection != null) {
            try {
                collection.forEach(item -> ((Class)item).asSubclass(requiredClass));
            }
            catch (ClassCastException | NullPointerException e) {
                throw new IllegalArgumentException("Invalid input item for property \"" + Objects.requireNonNull(fieldName) + "\"", e);
            }
        }
    }

    private static int wrapHashCode(int hash) {
        return hash == 0 ? 31 : hash;
    }
}

