/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.HierarchicalIdentifier;
import org.opendaylight.yangtools.util.HashCodeBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.ChoiceIn;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataRoot;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifierBuilderImpl;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifierV3;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;

public class InstanceIdentifier<T extends DataObject>
implements HierarchicalIdentifier<InstanceIdentifier<? extends DataObject>> {
    private static final long serialVersionUID = 3L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Handled through Externalizable proxy")
    final Iterable<PathArgument> pathArguments;
    private final @NonNull Class<T> targetType;
    private final boolean wildcarded;
    private final int hash;

    InstanceIdentifier(Class<T> type, Iterable<PathArgument> pathArguments, boolean wildcarded, int hash) {
        this.pathArguments = Objects.requireNonNull(pathArguments);
        this.targetType = Objects.requireNonNull(type);
        this.wildcarded = wildcarded;
        this.hash = hash;
    }

    public final @NonNull Class<T> getTargetType() {
        return this.targetType;
    }

    public final <N extends DataObject> @NonNull InstanceIdentifier<N> verifyTarget(Class<@NonNull N> target) {
        Verify.verify((boolean)target.equals(this.targetType), (String)"Cannot adapt %s to %s", (Object)this, target);
        return this;
    }

    public final @NonNull Iterable<PathArgument> getPathArguments() {
        return Iterables.unmodifiableIterable(this.pathArguments);
    }

    public final boolean isWildcarded() {
        return this.wildcarded;
    }

    public final int hashCode() {
        return this.hash;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstanceIdentifier other = (InstanceIdentifier)obj;
        if (this.pathArguments == other.pathArguments) {
            return true;
        }
        if (this.hash != other.hash) {
            return false;
        }
        if (this.wildcarded != other.wildcarded) {
            return false;
        }
        if (this.targetType != other.targetType) {
            return false;
        }
        if (this.fastNonEqual(other)) {
            return false;
        }
        return Iterables.elementsEqual(this.pathArguments, other.pathArguments);
    }

    protected boolean fastNonEqual(InstanceIdentifier<?> other) {
        return false;
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("targetType", this.targetType).add("path", (Object)Iterables.toString(this.pathArguments));
    }

    public final <I extends DataObject> @Nullable InstanceIdentifier<I> firstIdentifierOf(Class<@NonNull I> type) {
        int count = 1;
        for (PathArgument a : this.pathArguments) {
            if (type.equals(a.getType())) {
                InstanceIdentifier<?> ret = InstanceIdentifier.internalCreate(Iterables.limit(this.pathArguments, (int)count));
                return ret;
            }
            ++count;
        }
        return null;
    }

    public final <N extends Identifiable<K> & DataObject, K extends Identifier<N>> @Nullable K firstKeyOf(Class<@NonNull N> listItem) {
        for (PathArgument i : this.pathArguments) {
            if (!listItem.equals(i.getType())) continue;
            Object ret = ((IdentifiableItem)i).getKey();
            return (K)ret;
        }
        return null;
    }

    public final boolean contains(InstanceIdentifier<? extends DataObject> other) {
        Objects.requireNonNull(other, "other should not be null");
        Iterator<PathArgument> lit = this.pathArguments.iterator();
        Iterator<PathArgument> oit = other.pathArguments.iterator();
        while (lit.hasNext()) {
            if (!oit.hasNext()) {
                return false;
            }
            if (lit.next().equals(oit.next())) continue;
            return false;
        }
        return true;
    }

    public final boolean containsWildcarded(InstanceIdentifier<?> other) {
        Objects.requireNonNull(other, "other should not be null");
        Iterator<PathArgument> lit = this.pathArguments.iterator();
        Iterator<PathArgument> oit = other.pathArguments.iterator();
        while (lit.hasNext()) {
            if (!oit.hasNext()) {
                return false;
            }
            PathArgument la = lit.next();
            PathArgument oa = oit.next();
            if (!la.getType().equals(oa.getType())) {
                return false;
            }
            if (!(la instanceof IdentifiableItem) || !(oa instanceof IdentifiableItem) || la.equals(oa)) continue;
            return false;
        }
        return true;
    }

    private <N extends DataObject> @NonNull InstanceIdentifier<N> childIdentifier(AbstractPathArgument<N> arg) {
        return InstanceIdentifier.trustedCreate(arg, Iterables.concat(this.pathArguments, Collections.singleton(arg)), HashCodeBuilder.nextHashCode((int)this.hash, arg), this.isWildcarded());
    }

    public final <N extends ChildOf<? super T>> @NonNull InstanceIdentifier<N> child(Class<@NonNull N> container) {
        return this.childIdentifier(Item.of(container));
    }

    public final <N extends Identifiable<K> & ChildOf<? super T>, K extends Identifier<N>> @NonNull KeyedInstanceIdentifier<N, K> child(Class<@NonNull N> listItem, K listKey) {
        return (KeyedInstanceIdentifier)this.childIdentifier(IdentifiableItem.of(listItem, listKey));
    }

    public final <C extends ChoiceIn<? super T> & DataObject, N extends ChildOf<? super C>> @NonNull InstanceIdentifier<N> child(Class<@NonNull C> caze, Class<@NonNull N> container) {
        return this.childIdentifier(Item.of(caze, container));
    }

    public final <C extends ChoiceIn<? super T> & DataObject, K extends Identifier<N>, N extends Identifiable<K> & ChildOf<? super C>> @NonNull KeyedInstanceIdentifier<N, K> child(Class<@NonNull C> caze, Class<@NonNull N> listItem, K listKey) {
        return (KeyedInstanceIdentifier)this.childIdentifier(IdentifiableItem.of(caze, listItem, listKey));
    }

    public final <N extends DataObject & Augmentation<? super T>> @NonNull InstanceIdentifier<N> augmentation(Class<@NonNull N> container) {
        return this.childIdentifier(Item.of(container));
    }

    public @NonNull InstanceIdentifierBuilder<T> builder() {
        return new InstanceIdentifierBuilderImpl(Item.of(this.targetType), this.pathArguments, this.hash, this.isWildcarded());
    }

    public static <T extends ChildOf<? extends DataRoot>> @NonNull InstanceIdentifierBuilder<T> builder(Class<T> container) {
        return new InstanceIdentifierBuilderImpl().addWildNode(Item.of(container));
    }

    public static <C extends ChoiceIn<? extends DataRoot> & DataObject, T extends ChildOf<? super C>> @NonNull InstanceIdentifierBuilder<T> builder(Class<C> caze, Class<T> container) {
        return new InstanceIdentifierBuilderImpl().addWildNode(Item.of(caze, container));
    }

    public static <N extends Identifiable<K> & ChildOf<? extends DataRoot>, K extends Identifier<N>> @NonNull InstanceIdentifierBuilder<N> builder(Class<N> listItem, K listKey) {
        return new InstanceIdentifierBuilderImpl().addNode(IdentifiableItem.of(listItem, listKey));
    }

    public static <C extends ChoiceIn<? extends DataRoot> & DataObject, N extends Identifiable<K> & ChildOf<? super C>, K extends Identifier<N>> @NonNull InstanceIdentifierBuilder<N> builder(Class<C> caze, Class<N> listItem, K listKey) {
        return new InstanceIdentifierBuilderImpl().addNode(IdentifiableItem.of(caze, listItem, listKey));
    }

    public static <R extends DataRoot & DataObject, T extends ChildOf<? super R>> @NonNull InstanceIdentifierBuilder<T> builderOfInherited(Class<R> root, Class<T> container) {
        return new InstanceIdentifierBuilderImpl().addWildNode(Item.of(container));
    }

    public static <R extends DataRoot & DataObject, C extends ChoiceIn<? super R> & DataObject, T extends ChildOf<? super C>> @NonNull InstanceIdentifierBuilder<T> builderOfInherited(Class<R> root, Class<C> caze, Class<T> container) {
        return new InstanceIdentifierBuilderImpl().addWildNode(Item.of(caze, container));
    }

    public static <R extends DataRoot & DataObject, N extends Identifiable<K> & ChildOf<? super R>, K extends Identifier<N>> @NonNull InstanceIdentifierBuilder<N> builderOfInherited(Class<R> root, Class<N> listItem, K listKey) {
        return new InstanceIdentifierBuilderImpl().addNode(IdentifiableItem.of(listItem, listKey));
    }

    public static <R extends DataRoot & DataObject, C extends ChoiceIn<? super R> & DataObject, N extends Identifiable<K> & ChildOf<? super C>, K extends Identifier<N>> @NonNull InstanceIdentifierBuilder<N> builderOfInherited(Class<R> root, Class<C> caze, Class<N> listItem, K listKey) {
        return new InstanceIdentifierBuilderImpl().addNode(IdentifiableItem.of(caze, listItem, listKey));
    }

    private static @NonNull InstanceIdentifier<?> internalCreate(Iterable<PathArgument> pathArguments) {
        PathArgument arg;
        Iterator<PathArgument> it = Objects.requireNonNull(pathArguments, "pathArguments may not be null").iterator();
        Preconditions.checkArgument((boolean)it.hasNext(), (Object)"pathArguments may not be empty");
        HashCodeBuilder hashBuilder = new HashCodeBuilder();
        boolean wildcard = false;
        do {
            Class<? extends DataObject> type;
            Preconditions.checkArgument((ChildOf.class.isAssignableFrom(type = ((PathArgument)Verify.verifyNotNull((Object)(arg = it.next()))).getType()) || Augmentation.class.isAssignableFrom(type) ? 1 : 0) != 0, (String)"%s is not a valid path argument", type);
            hashBuilder.addArgument((Object)arg);
            if (!Identifiable.class.isAssignableFrom(type) || arg instanceof IdentifiableItem) continue;
            wildcard = true;
        } while (it.hasNext());
        return InstanceIdentifier.trustedCreate(arg, pathArguments, hashBuilder.build(), wildcard);
    }

    public static <T extends DataObject> @NonNull InstanceIdentifier<T> unsafeOf(List<? extends PathArgument> pathArguments) {
        return InstanceIdentifier.internalCreate((Iterable<PathArgument>)ImmutableList.copyOf(pathArguments));
    }

    public static <T extends ChildOf<? extends DataRoot>> @NonNull InstanceIdentifier<T> create(Class<@NonNull T> type) {
        return InstanceIdentifier.internalCreate((Iterable<PathArgument>)ImmutableList.of(Item.of(type)));
    }

    public static <N extends Identifiable<K> & DataObject, K extends Identifier<N>> K keyOf(InstanceIdentifier<N> id) {
        Objects.requireNonNull(id);
        Preconditions.checkArgument((boolean)(id instanceof KeyedInstanceIdentifier), (String)"%s does not have a key", id);
        Object ret = ((KeyedInstanceIdentifier)id).getKey();
        return ret;
    }

    static <N extends DataObject> @NonNull InstanceIdentifier<N> trustedCreate(PathArgument arg, Iterable<PathArgument> pathArguments, int hash, boolean wildcarded) {
        if (Identifiable.class.isAssignableFrom(arg.getType()) && !wildcarded) {
            Object key = null;
            if (arg instanceof IdentifiableItem) {
                key = ((IdentifiableItem)arg).getKey();
            } else {
                wildcarded = true;
            }
            return new KeyedInstanceIdentifier<DataObject, Object>(arg.getType(), pathArguments, wildcarded, hash, key);
        }
        return new InstanceIdentifier<DataObject>(arg.getType(), pathArguments, wildcarded, hash);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new InstanceIdentifierV3(this);
    }

    public static interface InstanceIdentifierBuilder<T extends DataObject> {
        public <N extends ChildOf<? super T>> @NonNull InstanceIdentifierBuilder<N> child(Class<N> var1);

        public <C extends ChoiceIn<? super T> & DataObject, N extends ChildOf<? super C>> @NonNull InstanceIdentifierBuilder<N> child(Class<C> var1, Class<N> var2);

        public <N extends Identifiable<K> & ChildOf<? super T>, K extends Identifier<N>> @NonNull InstanceIdentifierBuilder<N> child(Class<@NonNull N> var1, K var2);

        public <C extends ChoiceIn<? super T> & DataObject, K extends Identifier<N>, N extends Identifiable<K> & ChildOf<? super C>> @NonNull InstanceIdentifierBuilder<N> child(Class<C> var1, Class<N> var2, K var3);

        public <N extends DataObject & Augmentation<? super T>> @NonNull InstanceIdentifierBuilder<N> augmentation(Class<N> var1);

        public @NonNull InstanceIdentifier<T> build();
    }

    private static final class CaseIdentifiableItem<C extends ChoiceIn<?> & DataObject, T extends ChildOf<? super C> & Identifiable<K>, K extends Identifier<T>>
    extends IdentifiableItem<T, K> {
        private static final long serialVersionUID = 1L;
        private final Class<C> caseType;

        CaseIdentifiableItem(Class<C> caseType, Class<T> type, K key) {
            super(type, key);
            this.caseType = Objects.requireNonNull(caseType);
        }

        public Optional<Class<C>> getCaseType() {
            return Optional.of(this.caseType);
        }
    }

    private static final class CaseItem<C extends ChoiceIn<?> & DataObject, T extends ChildOf<? super C>>
    extends Item<T> {
        private static final long serialVersionUID = 1L;
        private final Class<C> caseType;

        CaseItem(Class<C> caseType, Class<T> type) {
            super(type);
            this.caseType = Objects.requireNonNull(caseType);
        }

        public Optional<Class<C>> getCaseType() {
            return Optional.of(this.caseType);
        }
    }

    public static class IdentifiableItem<I extends Identifiable<T> & DataObject, T extends Identifier<I>>
    extends AbstractPathArgument<I> {
        private static final long serialVersionUID = 1L;
        private final @NonNull T key;

        IdentifiableItem(Class<I> type, T key) {
            super(type);
            this.key = (Identifier)Objects.requireNonNull(key, "Key may not be null.");
        }

        public static <T extends Identifiable<I> & DataObject, I extends Identifier<T>> @NonNull IdentifiableItem<T, I> of(Class<T> type, I key) {
            return new IdentifiableItem<T, I>(type, key);
        }

        public static <C extends ChoiceIn<?> & DataObject, T extends ChildOf<? super C> & Identifiable<I>, I extends Identifier<T>> @NonNull IdentifiableItem<T, I> of(Class<C> caseType, Class<T> type, I key) {
            return new CaseIdentifiableItem<C, T, I>(caseType, type, key);
        }

        @Override
        public final @NonNull T getKey() {
            return this.key;
        }

        public String toString() {
            return this.getType().getName() + "[key=" + this.key + "]";
        }
    }

    public static class Item<T extends DataObject>
    extends AbstractPathArgument<T> {
        private static final long serialVersionUID = 1L;

        Item(Class<T> type) {
            super(type);
        }

        public static <T extends DataObject> @NonNull Item<T> of(Class<T> type) {
            return new Item<T>(type);
        }

        public static <C extends ChoiceIn<?> & DataObject, T extends ChildOf<? super C>> @NonNull Item<T> of(Class<C> caseType, Class<T> type) {
            return new CaseItem<C, T>(caseType, type);
        }

        public String toString() {
            return this.getType().getName();
        }
    }

    private static abstract class AbstractPathArgument<T extends DataObject>
    implements PathArgument,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final @NonNull Class<T> type;

        AbstractPathArgument(Class<T> type) {
            this.type = Objects.requireNonNull(type, "Type may not be null.");
        }

        public final Class<T> getType() {
            return this.type;
        }

        Object getKey() {
            return null;
        }

        public final int hashCode() {
            return Objects.hash(this.type, this.getCaseType(), this.getKey());
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AbstractPathArgument)) {
                return false;
            }
            AbstractPathArgument other = (AbstractPathArgument)obj;
            return this.type.equals(other.type) && Objects.equals(this.getKey(), other.getKey()) && this.getCaseType().equals(other.getCaseType());
        }

        @Override
        public final int compareTo(PathArgument arg) {
            int cmp = AbstractPathArgument.compareClasses(this.type, arg.getType());
            if (cmp != 0) {
                return cmp;
            }
            Optional<? extends Class<? extends DataObject>> caseType = this.getCaseType();
            if (!caseType.isPresent()) {
                return arg.getCaseType().isPresent() ? -1 : 1;
            }
            Optional<? extends Class<? extends DataObject>> argCaseType = this.getCaseType();
            return argCaseType.isPresent() ? AbstractPathArgument.compareClasses(caseType.get(), argCaseType.get()) : 1;
        }

        private static int compareClasses(Class<?> first, Class<?> second) {
            return first.getCanonicalName().compareTo(second.getCanonicalName());
        }
    }

    public static interface PathArgument
    extends Comparable<PathArgument> {
        public @NonNull Class<? extends DataObject> getType();

        default public Optional<? extends Class<? extends DataObject>> getCaseType() {
            return Optional.empty();
        }
    }
}

