/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.openconfig.stmt;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.concepts.SemVer;
import org.opendaylight.yangtools.openconfig.model.api.OpenConfigStatements;
import org.opendaylight.yangtools.openconfig.model.api.OpenConfigVersionEffectiveStatement;
import org.opendaylight.yangtools.openconfig.model.api.OpenConfigVersionStatement;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.openconfig.stmt.OpenConfigVersionEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.openconfig.stmt.OpenConfigVersionStatementImpl;
import org.opendaylight.yangtools.yang.parser.openconfig.stmt.RefOpenConfigVersionStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.SemanticVersionNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public final class OpenConfigVersionSupport
extends AbstractStatementSupport<SemVer, OpenConfigVersionStatement, OpenConfigVersionEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)OpenConfigStatements.OPENCONFIG_VERSION).build();

    public OpenConfigVersionSupport(YangParserConfiguration config) {
        super((StatementDefinition)OpenConfigStatements.OPENCONFIG_VERSION, StatementSupport.StatementPolicy.reject(), config, SUBSTATEMENT_VALIDATOR);
    }

    public SemVer parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return SemVer.valueOf((String)value);
    }

    public void onLinkageDeclared(StmtContext.Mutable<SemVer, OpenConfigVersionStatement, OpenConfigVersionEffectiveStatement> stmt) {
        stmt.addToNs(SemanticVersionNamespace.class, (Object)stmt.getParentContext(), (Object)((SemVer)stmt.argument()));
    }

    protected OpenConfigVersionStatement createDeclared(BoundStmtCtx<SemVer> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return new OpenConfigVersionStatementImpl((SemVer)ctx.getArgument(), substatements);
    }

    protected OpenConfigVersionStatement attachDeclarationReference(OpenConfigVersionStatement stmt, DeclarationReference reference) {
        return new RefOpenConfigVersionStatement(stmt, reference);
    }

    protected OpenConfigVersionEffectiveStatement createEffective(EffectiveStmtCtx.Current<SemVer, OpenConfigVersionStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new OpenConfigVersionEffectiveStatementImpl(stmt, substatements);
    }
}

