/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.ir;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.parser.antlr.YangStatementParser;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRArgument;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRKeyword;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRStatement022;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRStatement031;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRStatement044;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRStatement144;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRStatementL44;

@Beta
public final class AntlrSupport {
    private static final CharMatcher WHITESPACE_MATCHER = CharMatcher.whitespace();
    private final Map<String, IRArgument.DoubleQuoted> dquotArguments = new HashMap<String, IRArgument.DoubleQuoted>();
    private final Map<String, IRArgument.SingleQuoted> squotArguments = new HashMap<String, IRArgument.SingleQuoted>();
    private final Map<String, IRArgument.Unquoted> uquotArguments = new HashMap<String, IRArgument.Unquoted>();
    private final Map<String, IRArgument.Identifier> idenArguments = new HashMap<String, IRArgument.Identifier>();
    private final Map<String, IRKeyword.Unqualified> uqualKeywords = new HashMap<String, IRKeyword.Unqualified>();
    private final Map<Map.Entry<String, String>, IRKeyword.Qualified> qualKeywords = new HashMap<Map.Entry<String, String>, IRKeyword.Qualified>();
    private final Map<String, String> strings = new HashMap<String, String>();

    private AntlrSupport() {
    }

    public static @NonNull IRStatement createStatement(YangStatementParser.FileContext file) {
        return AntlrSupport.createStatement(file.statement());
    }

    public static @NonNull IRStatement createStatement(YangStatementParser.StatementContext stmt) {
        return new AntlrSupport().statementOf(stmt);
    }

    private @NonNull IRStatement statementOf(YangStatementParser.StatementContext stmt) {
        IRKeyword keyword;
        ParseTree firstChild = stmt.getChild(0);
        Verify.verify((boolean)(firstChild instanceof YangStatementParser.KeywordContext), (String)"Unexpected shape of %s", (Object)((Object)stmt));
        ParseTree keywordStart = firstChild.getChild(0);
        Verify.verify((boolean)(keywordStart instanceof TerminalNode), (String)"Unexpected keyword start %s", (Object)keywordStart);
        Token keywordToken = ((TerminalNode)keywordStart).getSymbol();
        switch (firstChild.getChildCount()) {
            case 1: {
                keyword = this.uqualKeywords.computeIfAbsent(this.strOf(keywordToken), IRKeyword.Unqualified::new);
                break;
            }
            case 3: {
                keyword = this.qualKeywords.computeIfAbsent(Map.entry(this.strOf(keywordToken), this.strOf(firstChild.getChild(2))), entry -> new IRKeyword.Qualified((String)entry.getKey(), (String)entry.getValue()));
                break;
            }
            default: {
                throw new VerifyException("Unexpected keyword " + firstChild);
            }
        }
        IRArgument argument = this.createArgument(stmt);
        ImmutableList<IRStatement> statements = this.createStatements(stmt);
        int line = keywordToken.getLine();
        int column = keywordToken.getCharPositionInLine();
        switch (statements.size()) {
            case 0: {
                return AntlrSupport.statementOf(keyword, argument, line, column);
            }
            case 1: {
                return new IRStatement144(keyword, argument, (IRStatement)statements.get(0), line, column);
            }
        }
        return new IRStatementL44(keyword, argument, statements, line, column);
    }

    private static @NonNull IRStatement statementOf(IRKeyword keyword, IRArgument argument, int line, int column) {
        if (line >= 0 && column >= 0) {
            if (line <= 65535 && column <= 65535) {
                return new IRStatement022(keyword, argument, line, column);
            }
            if (line <= 0xFFFFFF && column <= 255) {
                return new IRStatement031(keyword, argument, line, column);
            }
        }
        return new IRStatement044(keyword, argument, line, column);
    }

    private IRArgument createArgument(YangStatementParser.StatementContext stmt) {
        YangStatementParser.ArgumentContext argument = stmt.argument();
        if (argument == null) {
            return null;
        }
        switch (argument.getChildCount()) {
            case 0: {
                throw new VerifyException("Unexpected shape of " + argument);
            }
            case 1: {
                return this.createSimple(argument);
            }
            case 2: {
                return this.createQuoted(argument);
            }
        }
        return this.createConcatenation(argument);
    }

    private IRArgument createConcatenation(YangStatementParser.ArgumentContext argument) {
        ArrayList<IRArgument.Single> parts = new ArrayList<IRArgument.Single>();
        block9: for (ParseTree child : argument.children) {
            Verify.verify((boolean)(child instanceof TerminalNode), (String)"Unexpected argument component %s", (Object)child);
            Token token = ((TerminalNode)child).getSymbol();
            switch (token.getType()) {
                case 4: 
                case 7: 
                case 17: 
                case 18: {
                    continue block9;
                }
                case 11: {
                    parts.add(this.createSingleQuoted(token));
                    continue block9;
                }
                case 10: {
                    parts.add(this.createDoubleQuoted(token));
                    continue block9;
                }
            }
            throw new VerifyException("Unexpected token " + token);
        }
        switch (parts.size()) {
            case 0: {
                return IRArgument.SingleQuoted.EMPTY;
            }
            case 1: {
                return (IRArgument)parts.get(0);
            }
        }
        return new IRArgument.Concatenation(parts);
    }

    private IRArgument.Single createQuoted(YangStatementParser.ArgumentContext argument) {
        ParseTree child = argument.getChild(0);
        Verify.verify((boolean)(child instanceof TerminalNode), (String)"Unexpected literal %s", (Object)child);
        Token token = ((TerminalNode)child).getSymbol();
        switch (token.getType()) {
            case 10: {
                return this.createDoubleQuoted(token);
            }
            case 11: {
                return this.createSingleQuoted(token);
            }
        }
        throw new VerifyException("Unexpected token " + token);
    }

    private IRArgument.DoubleQuoted createDoubleQuoted(Token token) {
        String str = this.intern(AntlrSupport.trimWhitespace(token.getText(), token.getCharPositionInLine() - 1));
        return this.dquotArguments.computeIfAbsent(str, IRArgument.DoubleQuoted::new);
    }

    private IRArgument createSimple(YangStatementParser.ArgumentContext argument) {
        ParseTree child = argument.getChild(0);
        if (child instanceof TerminalNode) {
            Token token = ((TerminalNode)child).getSymbol();
            switch (token.getType()) {
                case 5: {
                    return this.idenArguments.computeIfAbsent(this.strOf(token), IRArgument.Identifier::new);
                }
                case 17: 
                case 18: {
                    return IRArgument.SingleQuoted.EMPTY;
                }
            }
            throw new VerifyException("Unexpected token " + token);
        }
        Verify.verify((boolean)(child instanceof YangStatementParser.UnquotedStringContext), (String)"Unexpected shape of %s", (Object)((Object)argument));
        return this.uquotArguments.computeIfAbsent(this.strOf(child), IRArgument.Unquoted::new);
    }

    private IRArgument.SingleQuoted createSingleQuoted(Token token) {
        return this.squotArguments.computeIfAbsent(this.strOf(token), IRArgument.SingleQuoted::new);
    }

    private ImmutableList<IRStatement> createStatements(YangStatementParser.StatementContext stmt) {
        List<YangStatementParser.StatementContext> statements = stmt.statement();
        return statements.isEmpty() ? ImmutableList.of() : (ImmutableList)statements.stream().map(this::statementOf).collect(ImmutableList.toImmutableList());
    }

    private String strOf(ParseTree tree) {
        return this.intern(tree.getText());
    }

    private String strOf(Token token) {
        return this.intern(token.getText());
    }

    private String intern(String str) {
        return this.strings.computeIfAbsent(str, Function.identity());
    }

    @VisibleForTesting
    static String trimWhitespace(String str, int dquot) {
        int firstBrk = str.indexOf(10);
        if (firstBrk == -1) {
            return str;
        }
        int length = str.length();
        StringBuilder sb = new StringBuilder(length);
        sb.append(str, 0, AntlrSupport.trimTrailing(str, 0, firstBrk)).append('\n');
        int start = firstBrk + 1;
        int brk = str.indexOf(10, start);
        while (brk != -1) {
            AntlrSupport.trimLeadingAndAppend(sb, dquot, str, start, AntlrSupport.trimTrailing(str, start, brk)).append('\n');
            start = brk + 1;
            brk = str.indexOf(10, start);
        }
        return AntlrSupport.trimLeadingAndAppend(sb, dquot, str, start, length).toString();
    }

    private static StringBuilder trimLeadingAndAppend(StringBuilder sb, int dquot, String str, int start, int end) {
        int offset = start;
        int pos = 0;
        while (pos <= dquot) {
            if (offset == end) {
                return sb;
            }
            char ch = str.charAt(offset);
            if (ch == '\t') {
                pos += 8;
            } else {
                if (!WHITESPACE_MATCHER.matches(ch)) break;
                ++pos;
            }
            ++offset;
        }
        while (pos - 1 > dquot) {
            sb.append(' ');
            --pos;
        }
        return sb.append(str, offset, end);
    }

    private static int trimTrailing(String str, int start, int end) {
        int prev;
        int ret = end;
        while (ret > start && WHITESPACE_MATCHER.matches(str.charAt(prev = ret - 1))) {
            ret = prev;
        }
        return ret;
    }
}

