/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.ir;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.AbstractSimpleIdentifiable;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRKeyword;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRStatement;

@Beta
public final class IRSchemaSource
extends AbstractSimpleIdentifiable<SourceIdentifier>
implements SchemaSourceRepresentation {
    private final @NonNull IRStatement rootStatement;
    private final @Nullable String symbolicName;

    public IRSchemaSource(@NonNull SourceIdentifier identifier, @NonNull IRStatement rootStatement, @Nullable String symbolicName) {
        super((Object)identifier);
        String rootName;
        this.rootStatement = Objects.requireNonNull(rootStatement);
        this.symbolicName = symbolicName;
        IRKeyword rootKeyword = rootStatement.keyword();
        Preconditions.checkArgument((boolean)(rootKeyword instanceof IRKeyword.Unqualified), (String)"Root statement has invalid keyword %s", (Object)rootKeyword);
        switch (rootName = rootKeyword.identifier()) {
            case "module": 
            case "submodule": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid root statement keyword " + rootName);
            }
        }
        Preconditions.checkArgument((rootStatement.argument() != null ? 1 : 0) != 0, (Object)"Root statement does not have an argument");
    }

    public Optional<String> getSymbolicName() {
        return Optional.ofNullable(this.symbolicName);
    }

    public Class<@NonNull IRSchemaSource> getType() {
        return IRSchemaSource.class;
    }

    public @NonNull IRStatement getRootStatement() {
        return this.rootStatement;
    }
}

