/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.reactor;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupportBundle;
import org.opendaylight.yangtools.yang.parser.spi.validation.ValidationBundlesNamespace;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.CrossSourceStatementReactor;

@Beta
public class CustomCrossSourceStatementReactorBuilder
implements Mutable {
    private final ImmutableMap<ModelProcessingPhase, StatementSupportBundle.Builder> reactorSupportBundles;
    private final Map<ValidationBundlesNamespace.ValidationBundleType, Collection<StatementDefinition>> reactorValidationBundles = new HashMap<ValidationBundlesNamespace.ValidationBundleType, Collection<StatementDefinition>>();

    CustomCrossSourceStatementReactorBuilder(Set<YangVersion> supportedVersions) {
        this.reactorSupportBundles = ImmutableMap.builder().put((Object)ModelProcessingPhase.INIT, (Object)StatementSupportBundle.builder(supportedVersions)).put((Object)ModelProcessingPhase.SOURCE_PRE_LINKAGE, (Object)StatementSupportBundle.builder(supportedVersions)).put((Object)ModelProcessingPhase.SOURCE_LINKAGE, (Object)StatementSupportBundle.builder(supportedVersions)).put((Object)ModelProcessingPhase.STATEMENT_DEFINITION, (Object)StatementSupportBundle.builder(supportedVersions)).put((Object)ModelProcessingPhase.FULL_DECLARATION, (Object)StatementSupportBundle.builder(supportedVersions)).put((Object)ModelProcessingPhase.EFFECTIVE_MODEL, (Object)StatementSupportBundle.builder(supportedVersions)).build();
    }

    public @NonNull CustomCrossSourceStatementReactorBuilder addStatementSupport(ModelProcessingPhase phase, StatementSupport<?, ?, ?> stmtSupport) {
        this.getBuilder(phase).addSupport(stmtSupport);
        return this;
    }

    public @NonNull CustomCrossSourceStatementReactorBuilder overrideStatementSupport(ModelProcessingPhase phase, StatementSupport<?, ?, ?> stmtSupport) {
        this.getBuilder(phase).overrideSupport(stmtSupport);
        return this;
    }

    public @NonNull CustomCrossSourceStatementReactorBuilder addNamespaceSupport(ModelProcessingPhase phase, NamespaceBehaviour<?, ?, ?> namespaceSupport) {
        this.getBuilder(phase).addSupport(namespaceSupport);
        return this;
    }

    public @NonNull CustomCrossSourceStatementReactorBuilder addValidationBundle(ValidationBundlesNamespace.ValidationBundleType validationBundleType, Collection<StatementDefinition> validationBundle) {
        this.reactorValidationBundles.put(validationBundleType, validationBundle);
        return this;
    }

    public @NonNull CustomCrossSourceStatementReactorBuilder addAllSupports(ModelProcessingPhase phase, StatementSupportBundle stmtSupportBundle) {
        this.addAllCommonStatementSupports(phase, (Collection<StatementSupport<?, ?, ?>>)stmtSupportBundle.getCommonDefinitions().values());
        this.addAllVersionSpecificSupports(phase, (Table<YangVersion, QName, StatementSupport<?, ?, ?>>)stmtSupportBundle.getAllVersionSpecificDefinitions());
        this.addAllNamespaceSupports(phase, (Collection<NamespaceBehaviour<?, ?, ?>>)stmtSupportBundle.getNamespaceDefinitions().values());
        return this;
    }

    public @NonNull CustomCrossSourceStatementReactorBuilder addAllNamespaceSupports(ModelProcessingPhase phase, Collection<NamespaceBehaviour<?, ?, ?>> namespaceSupports) {
        StatementSupportBundle.Builder stmtBundleBuilder = (StatementSupportBundle.Builder)this.reactorSupportBundles.get((Object)phase);
        for (NamespaceBehaviour<?, ?, ?> namespaceSupport : namespaceSupports) {
            stmtBundleBuilder.addSupport(namespaceSupport);
        }
        return this;
    }

    public @NonNull CustomCrossSourceStatementReactorBuilder addAllCommonStatementSupports(ModelProcessingPhase phase, Collection<StatementSupport<?, ?, ?>> statementSupports) {
        StatementSupportBundle.Builder stmtBundleBuilder = (StatementSupportBundle.Builder)this.reactorSupportBundles.get((Object)phase);
        for (StatementSupport<?, ?, ?> statementSupport : statementSupports) {
            stmtBundleBuilder.addSupport(statementSupport);
        }
        return this;
    }

    public @NonNull CustomCrossSourceStatementReactorBuilder addAllVersionSpecificSupports(ModelProcessingPhase phase, Table<YangVersion, QName, StatementSupport<?, ?, ?>> versionSpecificSupports) {
        StatementSupportBundle.Builder stmtBundleBuilder = (StatementSupportBundle.Builder)this.reactorSupportBundles.get((Object)phase);
        for (Table.Cell cell : versionSpecificSupports.cellSet()) {
            stmtBundleBuilder.addVersionSpecificSupport((YangVersion)cell.getRowKey(), (StatementSupport)cell.getValue());
        }
        return this;
    }

    public @NonNull CrossSourceStatementReactor build() {
        StatementSupportBundle initBundle = this.getBuilder(ModelProcessingPhase.INIT).build();
        StatementSupportBundle preLinkageBundle = this.getBuilder(ModelProcessingPhase.SOURCE_PRE_LINKAGE).setParent(initBundle).build();
        StatementSupportBundle linkageBundle = this.getBuilder(ModelProcessingPhase.SOURCE_LINKAGE).setParent(preLinkageBundle).build();
        StatementSupportBundle stmtDefBundle = this.getBuilder(ModelProcessingPhase.STATEMENT_DEFINITION).setParent(linkageBundle).build();
        StatementSupportBundle fullDeclBundle = this.getBuilder(ModelProcessingPhase.FULL_DECLARATION).setParent(stmtDefBundle).build();
        StatementSupportBundle effectiveBundle = this.getBuilder(ModelProcessingPhase.EFFECTIVE_MODEL).setParent(fullDeclBundle).build();
        CrossSourceStatementReactor.Builder reactorBuilder = CrossSourceStatementReactor.builder().setBundle(ModelProcessingPhase.INIT, initBundle).setBundle(ModelProcessingPhase.SOURCE_PRE_LINKAGE, preLinkageBundle).setBundle(ModelProcessingPhase.SOURCE_LINKAGE, linkageBundle).setBundle(ModelProcessingPhase.STATEMENT_DEFINITION, stmtDefBundle).setBundle(ModelProcessingPhase.FULL_DECLARATION, fullDeclBundle).setBundle(ModelProcessingPhase.EFFECTIVE_MODEL, effectiveBundle);
        for (Map.Entry<ValidationBundlesNamespace.ValidationBundleType, Collection<StatementDefinition>> entry : this.reactorValidationBundles.entrySet()) {
            reactorBuilder.setValidationBundle(entry.getKey(), entry.getValue());
        }
        return reactorBuilder.build();
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull StatementSupportBundle.Builder getBuilder(ModelProcessingPhase phase) {
        return (StatementSupportBundle.Builder)Verify.verifyNotNull((Object)((StatementSupportBundle.Builder)this.reactorSupportBundles.get((Object)phase)));
    }
}

