/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.repo;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.Optional;
import javax.xml.transform.TransformerException;
import org.opendaylight.yangtools.concepts.AbstractSimpleIdentifiable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.meta.ArgumentDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YinDomSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.api.YinXmlSchemaSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.StatementSourceReferenceHandler;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.source.PrefixToModule;
import org.opendaylight.yangtools.yang.parser.spi.source.QNameToStatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementStreamSource;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Beta
public final class YinStatementStreamSource
extends AbstractSimpleIdentifiable<SourceIdentifier>
implements StatementStreamSource {
    private static final Logger LOG = LoggerFactory.getLogger(YinStatementStreamSource.class);
    private static final LoadingCache<String, XMLNamespace> NS_CACHE = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<String, XMLNamespace>(){

        public XMLNamespace load(String key) {
            return XMLNamespace.of((String)key).intern();
        }
    });
    private final Node root;

    private YinStatementStreamSource(SourceIdentifier identifier, Node root) {
        super((Object)identifier);
        this.root = Objects.requireNonNull(root);
    }

    public static StatementStreamSource create(YinXmlSchemaSource source) throws TransformerException {
        return YinStatementStreamSource.create(YinDomSchemaSource.transform((YinXmlSchemaSource)source));
    }

    public static StatementStreamSource create(YinDomSchemaSource source) {
        return new YinStatementStreamSource(source.getIdentifier(), source.getSource().getNode());
    }

    private static StatementDefinition getValidDefinition(Node node, StatementWriter writer, QNameToStatementDefinition stmtDef, StatementSourceReference ref) {
        XMLNamespace uri = (XMLNamespace)NS_CACHE.getUnchecked((Object)node.getNamespaceURI());
        StatementDefinition def = stmtDef.getByNamespaceAndLocalName(uri, node.getLocalName());
        if (def == null) {
            SourceException.throwIf((boolean)writer.getPhase().equals((Object)ModelProcessingPhase.FULL_DECLARATION), (StatementSourceReference)ref, (String)"%s is not a YIN statement or use of extension.", (Object[])new Object[]{node.getLocalName()});
        }
        return def;
    }

    private static boolean processAttribute(int childId, Attr attr, StatementWriter writer, QNameToStatementDefinition stmtDef, StatementSourceReference ref) {
        Optional optResumed = writer.resumeStatement(childId);
        if (optResumed.isPresent()) {
            StatementWriter.ResumedStatement resumed = (StatementWriter.ResumedStatement)optResumed.get();
            Preconditions.checkState((boolean)resumed.isFullyDefined(), (String)"Statement %s is not fully defined", (Object)resumed);
            return true;
        }
        StatementDefinition def = YinStatementStreamSource.getValidDefinition(attr, writer, stmtDef, ref);
        if (def == null) {
            return false;
        }
        String value = attr.getValue();
        writer.startStatement(childId, def.getStatementName(), value.isEmpty() ? null : value, ref);
        writer.storeStatement(0, true);
        writer.endStatement(ref);
        return true;
    }

    private static String getArgValue(Element element, QName argName, boolean yinElement) {
        if (yinElement) {
            NodeList children = element.getElementsByTagNameNS(argName.getNamespace().toString(), argName.getLocalName());
            if (children.getLength() == 0) {
                return null;
            }
            return children.item(0).getTextContent();
        }
        Attr attr = element.getAttributeNode(argName.getLocalName());
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    private static boolean processElement(int childId, Element element, StatementWriter writer, QNameToStatementDefinition stmtDef) {
        boolean allElements;
        boolean allAttrs;
        QName argName;
        ArgumentDefinition argDef;
        Optional optArgDef;
        StatementSourceReference ref;
        Optional optResumed = writer.resumeStatement(childId);
        if (optResumed.isPresent()) {
            StatementWriter.ResumedStatement resumed = (StatementWriter.ResumedStatement)optResumed.get();
            if (resumed.isFullyDefined()) {
                return true;
            }
            StatementDefinition def = resumed.getDefinition();
            ref = resumed.getSourceReference();
            optArgDef = def.getArgumentDefinition();
            if (optArgDef.isPresent()) {
                argDef = (ArgumentDefinition)optArgDef.get();
                argName = argDef.getArgumentName();
                allAttrs = argDef.isYinElement();
                allElements = !allAttrs;
            } else {
                argName = null;
                allAttrs = false;
                allElements = false;
            }
        } else {
            String argValue;
            ref = StatementSourceReferenceHandler.extractRef(element);
            StatementDefinition def = YinStatementStreamSource.getValidDefinition(element, writer, stmtDef, ref);
            if (def == null) {
                LOG.debug("Skipping element {}", (Object)element);
                return false;
            }
            optArgDef = def.getArgumentDefinition();
            if (optArgDef.isPresent()) {
                argDef = (ArgumentDefinition)optArgDef.get();
                argName = argDef.getArgumentName();
                allAttrs = argDef.isYinElement();
                allElements = !allAttrs;
                argValue = YinStatementStreamSource.getArgValue(element, argName, allAttrs);
                SourceException.throwIfNull((Object)argValue, (StatementSourceReference)ref, (String)"Statement {} is missing mandatory argument %s", (Object[])new Object[]{def.getStatementName(), argName});
            } else {
                argName = null;
                argValue = null;
                allAttrs = false;
                allElements = false;
            }
            writer.startStatement(childId, def.getStatementName(), argValue, ref);
        }
        int childCounter = 0;
        boolean fullyDefined = true;
        NamedNodeMap attributes = element.getAttributes();
        if (attributes != null) {
            int len = attributes.getLength();
            for (int i = 0; i < len; ++i) {
                Attr attr = (Attr)attributes.item(i);
                if (!allAttrs && YinStatementStreamSource.isArgument(argName, attr) || YinStatementStreamSource.processAttribute(childCounter++, attr, writer, stmtDef, ref)) continue;
                fullyDefined = false;
            }
        }
        NodeList children = element.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !allElements && YinStatementStreamSource.isArgument(argName, child) || YinStatementStreamSource.processElement(childCounter++, (Element)child, writer, stmtDef)) continue;
            fullyDefined = false;
        }
        writer.storeStatement(childCounter, fullyDefined);
        writer.endStatement(ref);
        return fullyDefined;
    }

    private static boolean isArgument(QName argName, Node node) {
        return argName != null && argName.getLocalName().equals(node.getLocalName()) && node.getPrefix() == null;
    }

    private void walkTree(StatementWriter writer, QNameToStatementDefinition stmtDef) {
        NodeList children = this.root.getChildNodes();
        int childCounter = 0;
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            YinStatementStreamSource.processElement(childCounter++, (Element)child, writer, stmtDef);
        }
    }

    public void writePreLinkage(StatementWriter writer, QNameToStatementDefinition stmtDef) {
        this.walkTree(writer, stmtDef);
    }

    public void writeLinkage(StatementWriter writer, QNameToStatementDefinition stmtDef, PrefixToModule preLinkagePrefixes, YangVersion yangVersion) {
        this.walkTree(writer, stmtDef);
    }

    public void writeLinkageAndStatementDefinitions(StatementWriter writer, QNameToStatementDefinition stmtDef, PrefixToModule prefixes, YangVersion yangVersion) {
        this.walkTree(writer, stmtDef);
    }

    public void writeFull(StatementWriter writer, QNameToStatementDefinition stmtDef, PrefixToModule prefixes, YangVersion yangVersion) {
        this.walkTree(writer, stmtDef);
    }
}

