/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.opendaylight.yangtools.openconfig.model.api.OpenConfigStatements;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ArgumentStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ExtensionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ExtensionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.YinElementStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension.ModelDefinedStatementDefinition;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension.UnrecognizedStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.ExtensionNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementDefinitionNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public final class ExtensionStatementSupport
extends AbstractQNameStatementSupport<ExtensionStatement, ExtensionEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.EXTENSION).addOptional((StatementDefinition)YangStmtMapping.ARGUMENT).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).build();
    private final YangParserConfiguration config;

    public ExtensionStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.EXTENSION, StatementSupport.StatementPolicy.reject(), config, SUBSTATEMENT_VALIDATOR);
        this.config = Objects.requireNonNull(config);
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public void onStatementDefinitionDeclared(StmtContext.Mutable<QName, ExtensionStatement, ExtensionEffectiveStatement> stmt) {
        super.onStatementDefinitionDeclared(stmt);
        QName stmtName = (QName)stmt.getArgument();
        if (OpenConfigStatements.OPENCONFIG_VERSION.getStatementName().isEqualWithoutRevision(stmtName)) {
            stmtName = stmtName.withoutRevision();
        }
        stmt.addContext(ExtensionNamespace.class, (Object)stmtName, stmt);
        StmtContext argument = StmtContextUtils.findFirstDeclaredSubstatement(stmt, ArgumentStatement.class);
        StmtContext yinElement = StmtContextUtils.findFirstDeclaredSubstatement(stmt, YinElementStatement.class);
        stmt.addToNs(StatementDefinitionNamespace.class, (Object)((QName)stmt.argument()), (Object)new UnrecognizedStatementSupport((StatementDefinition)new ModelDefinedStatementDefinition((QName)stmt.getArgument(), argument != null ? (QName)argument.argument() : null, yinElement != null && (Boolean)yinElement.getArgument() != false), this.config));
    }

    protected ExtensionStatement createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createExtension((QName)((QName)ctx.getArgument()), substatements);
    }

    protected ExtensionStatement attachDeclarationReference(ExtensionStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateExtesion((ExtensionStatement)stmt, (DeclarationReference)reference);
    }

    protected ExtensionEffectiveStatement createEffective(EffectiveStmtCtx.Current<QName, ExtensionStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createExtension((ExtensionStatement)((ExtensionStatement)stmt.declared()), substatements);
    }
}

