/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.ArgumentDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.UnrecognizedStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension.ModelDefinedStatementDefinition;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension.UnrecognizedEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.OverrideChildStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

final class UnrecognizedStatementSupport
extends AbstractStatementSupport<Object, UnrecognizedStatement, UnrecognizedEffectiveStatement>
implements OverrideChildStatementSupport {
    private final YangParserConfiguration config;

    UnrecognizedStatementSupport(StatementDefinition publicDefinition, YangParserConfiguration config) {
        super(publicDefinition, StatementSupport.StatementPolicy.exactReplica(), config, null);
        this.config = Objects.requireNonNull(config);
    }

    public String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return value;
    }

    public UnrecognizedStatementSupport statementDefinitionOverrideOf(StatementDefinition childDef) {
        ModelDefinedStatementDefinition def;
        QName baseQName = this.getStatementName();
        QName statementName = QName.create((QName)baseQName, (String)childDef.getStatementName().getLocalName());
        Optional optArgDef = childDef.getArgumentDefinition();
        if (optArgDef.isPresent()) {
            ArgumentDefinition argDef = (ArgumentDefinition)optArgDef.get();
            def = new ModelDefinedStatementDefinition(statementName, argDef.getArgumentName(), argDef.isYinElement());
        } else {
            def = new ModelDefinedStatementDefinition(statementName);
        }
        return new UnrecognizedStatementSupport((StatementDefinition)def, this.config);
    }

    protected UnrecognizedStatement createDeclared(BoundStmtCtx<Object> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createUnrecognized((String)ctx.rawArgument(), (StatementDefinition)ctx.publicDefinition(), substatements);
    }

    protected UnrecognizedStatement attachDeclarationReference(UnrecognizedStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateUnrecognized((UnrecognizedStatement)stmt, (DeclarationReference)reference);
    }

    public void onStatementAdded(StmtContext.Mutable<Object, UnrecognizedStatement, UnrecognizedEffectiveStatement> stmt) {
        stmt.setUnsupported();
    }

    protected UnrecognizedEffectiveStatement createEffective(EffectiveStmtCtx.Current<Object, UnrecognizedStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        throw new InferenceException(stmt, "Attempted to instantiate unrecognized effective statement %s", new Object[]{stmt.publicDefinition()});
    }
}

