/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.if_feature;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.IfFeatureEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IfFeatureExpr;
import org.opendaylight.yangtools.yang.model.api.stmt.IfFeatureStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.FeatureNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractIfFeatureStatementSupport
extends AbstractStatementSupport<IfFeatureExpr, IfFeatureStatement, IfFeatureEffectiveStatement> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractIfFeatureStatementSupport.class);
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.IF_FEATURE).build();

    AbstractIfFeatureStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.IF_FEATURE, StatementSupport.StatementPolicy.contextIndependent(), config, SUBSTATEMENT_VALIDATOR);
    }

    public final void onFullDefinitionDeclared(final StmtContext.Mutable<IfFeatureExpr, IfFeatureStatement, IfFeatureEffectiveStatement> stmt) {
        super.onFullDefinitionDeclared(stmt);
        ModelActionBuilder verifyFeatures = stmt.newInferenceAction(ModelProcessingPhase.EFFECTIVE_MODEL);
        final HashMap<ModelActionBuilder.Prerequisite, QName> backRef = new HashMap<ModelActionBuilder.Prerequisite, QName>();
        for (QName feature : ((IfFeatureExpr)stmt.getArgument()).getReferencedFeatures()) {
            backRef.put(verifyFeatures.requiresCtx(stmt, FeatureNamespace.class, (Object)feature, ModelProcessingPhase.EFFECTIVE_MODEL), feature);
        }
        verifyFeatures.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                LOG.debug("Resolved all feature references in {}", backRef.values());
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                HashSet<QName> unresolvedFeatures = new HashSet<QName>();
                for (ModelActionBuilder.Prerequisite<?> prereq : failed) {
                    unresolvedFeatures.add((QName)Verify.verifyNotNull((Object)((QName)backRef.get(prereq))));
                }
                throw new InferenceException((CommonStmtCtx)stmt, "Failed to resolve feature references %s in \"%s\"", new Object[]{unresolvedFeatures, stmt.rawArgument()});
            }
        });
    }

    protected final IfFeatureStatement createDeclared(BoundStmtCtx<IfFeatureExpr> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createIfFeature((String)ctx.getRawArgument(), (IfFeatureExpr)((IfFeatureExpr)ctx.getArgument()), substatements);
    }

    protected final IfFeatureStatement attachDeclarationReference(IfFeatureStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateIfFeature((IfFeatureStatement)stmt, (DeclarationReference)reference);
    }

    protected final IfFeatureEffectiveStatement createEffective(EffectiveStmtCtx.Current<IfFeatureExpr, IfFeatureStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createIfFeature((IfFeatureStatement)((IfFeatureStatement)stmt.declared()), substatements);
    }
}

