/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.import_;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.concepts.SemVer;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.stmt.ImportEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ImportStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.model.repo.api.SemVerSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.ModuleQNameToPrefix;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.import_.ImportedVersionNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceKeyCriterion;
import org.opendaylight.yangtools.yang.parser.spi.meta.SemanticVersionModuleNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.SemanticVersionNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.ImportPrefixToModuleCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.ImportPrefixToSemVerSourceIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.source.ImportedModuleContext;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleCtxToModuleQName;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleCtxToSourceIdentifier;

final class SemanticVersionImport {
    private SemanticVersionImport() {
    }

    static void onLinkageDeclared(final StmtContext.Mutable<String, ImportStatement, ImportEffectiveStatement> stmt) {
        ModelActionBuilder importAction = stmt.newInferenceAction(ModelProcessingPhase.SOURCE_LINKAGE);
        final String moduleName = (String)stmt.getArgument();
        SemVer semanticVersion = (SemVer)stmt.getFromNamespace(SemanticVersionNamespace.class, stmt);
        CompatibleCriterion criterion = semanticVersion == null ? new NoVerCompatibleCriterion(moduleName) : new SemVerCompatibleCriterion(moduleName, semanticVersion);
        final ModelActionBuilder.Prerequisite imported = importAction.requiresCtx(stmt, SemanticVersionModuleNamespace.class, (NamespaceKeyCriterion)criterion, ModelProcessingPhase.SOURCE_LINKAGE);
        final ModelActionBuilder.Prerequisite linkageTarget = importAction.mutatesCtx((StmtContext.Mutable)stmt.getRoot(), ModelProcessingPhase.SOURCE_LINKAGE);
        importAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                StmtContext importedModule = (StmtContext)imported.resolve(ctx);
                SemVer importedVersion = (SemVer)stmt.getFromNamespace(SemanticVersionNamespace.class, (Object)stmt);
                SourceIdentifier importedModuleIdentifier = (SourceIdentifier)importedModule.getFromNamespace(ModuleCtxToSourceIdentifier.class, (Object)importedModule);
                SemVerSourceIdentifier semVerModuleIdentifier = SemanticVersionImport.createSemVerModuleIdentifier(importedModuleIdentifier, importedVersion);
                stmt.addToNs(ImportedVersionNamespace.class, (Object)Empty.value(), (Object)semVerModuleIdentifier);
                ((StmtContext.Mutable)linkageTarget.resolve(ctx)).addToNs(ImportedModuleContext.class, (Object)importedModuleIdentifier, (Object)importedModule);
                String impPrefix = (String)StmtContextUtils.firstAttributeOf((Iterable)stmt.declaredSubstatements(), PrefixStatement.class);
                stmt.addToNs(ImportPrefixToModuleCtx.class, (Object)impPrefix, (Object)importedModule);
                stmt.addToNs(ImportPrefixToSemVerSourceIdentifier.class, (Object)impPrefix, (Object)semVerModuleIdentifier);
                QNameModule mod = (QNameModule)InferenceException.throwIfNull((Object)((QNameModule)stmt.getFromNamespace(ModuleCtxToModuleQName.class, (Object)importedModule)), (CommonStmtCtx)stmt, (String)"Failed to find module of %s", (Object[])new Object[]{importedModule});
                stmt.addToNs(ModuleQNameToPrefix.class, (Object)mod, (Object)impPrefix);
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                if (failed.contains(imported)) {
                    throw new InferenceException((CommonStmtCtx)stmt, "Unable to find module compatible with requested import [%s(%s)].", new Object[]{moduleName, SemanticVersionImport.getRequestedImportVersionString(stmt)});
                }
            }
        });
    }

    private static Optional<SemVer> getRequestedImportVersion(StmtContext<?, ?, ?> stmt) {
        return Optional.ofNullable((SemVer)stmt.getFromNamespace(SemanticVersionNamespace.class, stmt));
    }

    private static String getRequestedImportVersionString(StmtContext<?, ?, ?> stmt) {
        return SemanticVersionImport.getRequestedImportVersion(stmt).map(SemVer::toString).orElse("<any>");
    }

    private static SemVerSourceIdentifier createSemVerModuleIdentifier(SourceIdentifier importedModuleIdentifier, SemVer semVer) {
        return SemVerSourceIdentifier.create((String)importedModuleIdentifier.getName(), (Optional)importedModuleIdentifier.getRevision(), (SemVer)semVer);
    }

    private static final class SemVerCompatibleCriterion
    extends CompatibleCriterion {
        private final SemVer semVer;

        SemVerCompatibleCriterion(String moduleName, SemVer semVer) {
            super(moduleName);
            this.semVer = Objects.requireNonNull(semVer);
        }

        @Override
        public boolean match(SemVerSourceIdentifier key) {
            if (!super.match(key)) {
                return false;
            }
            Optional optKeyVer = key.getSemanticVersion();
            if (!optKeyVer.isPresent()) {
                return false;
            }
            SemVer keyVer = (SemVer)optKeyVer.get();
            if (this.semVer.getMajor() != keyVer.getMajor()) {
                return false;
            }
            if (this.semVer.getMinor() > keyVer.getMinor()) {
                return false;
            }
            return this.semVer.getMinor() < keyVer.getMinor() || this.semVer.getPatch() <= keyVer.getPatch();
        }

        public SemVerSourceIdentifier select(SemVerSourceIdentifier first, SemVerSourceIdentifier second) {
            return ((SemVer)first.getSemanticVersion().get()).compareTo((SemVer)second.getSemanticVersion().get()) >= 0 ? first : second;
        }

        @Override
        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
            return super.addToStringAttributes(toStringHelper).add("version", (Object)this.semVer);
        }
    }

    private static final class NoVerCompatibleCriterion
    extends CompatibleCriterion {
        NoVerCompatibleCriterion(String moduleName) {
            super(moduleName);
        }

        public SemVerSourceIdentifier select(SemVerSourceIdentifier first, SemVerSourceIdentifier second) {
            return null;
        }
    }

    private static abstract class CompatibleCriterion
    extends NamespaceKeyCriterion<SemVerSourceIdentifier> {
        private final String moduleName;

        CompatibleCriterion(String moduleName) {
            this.moduleName = Objects.requireNonNull(moduleName);
        }

        public boolean match(SemVerSourceIdentifier key) {
            return this.moduleName.equals(key.getName());
        }

        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
            return toStringHelper.add("moduleName", (Object)this.moduleName);
        }
    }
}

