/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CopyableNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.CaseEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.CaseStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.UndeclaredStatements;
import org.opendaylight.yangtools.yang.model.spi.meta.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.model.spi.meta.SubstatementIndexingException;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta.AbstractImplicitStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.QNameWithFlagsEffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class CaseStatementSupport
extends AbstractImplicitStatementSupport<CaseStatement, CaseEffectiveStatement> {
    private static final SubstatementValidator RFC6020_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.CASE).addAny((StatementDefinition)YangStmtMapping.ANYXML).addAny((StatementDefinition)YangStmtMapping.CHOICE).addAny((StatementDefinition)YangStmtMapping.CONTAINER).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addAny((StatementDefinition)YangStmtMapping.LEAF).addAny((StatementDefinition)YangStmtMapping.LEAF_LIST).addAny((StatementDefinition)YangStmtMapping.LIST).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addAny((StatementDefinition)YangStmtMapping.USES).addOptional((StatementDefinition)YangStmtMapping.WHEN).build();
    private static final SubstatementValidator RFC7950_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.CASE).addAny((StatementDefinition)YangStmtMapping.ANYDATA).addAny((StatementDefinition)YangStmtMapping.ANYXML).addAny((StatementDefinition)YangStmtMapping.CHOICE).addAny((StatementDefinition)YangStmtMapping.CONTAINER).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addAny((StatementDefinition)YangStmtMapping.LEAF).addAny((StatementDefinition)YangStmtMapping.LEAF_LIST).addAny((StatementDefinition)YangStmtMapping.LIST).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addAny((StatementDefinition)YangStmtMapping.USES).addOptional((StatementDefinition)YangStmtMapping.WHEN).build();

    private CaseStatementSupport(YangParserConfiguration config, SubstatementValidator validator) {
        super((StatementDefinition)YangStmtMapping.CASE, CaseStatementSupport.instantiatedPolicy(), config, validator);
    }

    public static @NonNull CaseStatementSupport rfc6020Instance(YangParserConfiguration config) {
        return new CaseStatementSupport(config, RFC6020_VALIDATOR);
    }

    public static @NonNull CaseStatementSupport rfc7950Instance(YangParserConfiguration config) {
        return new CaseStatementSupport(config, RFC7950_VALIDATOR);
    }

    protected CaseStatement createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createCase((QName)((QName)ctx.getArgument()), substatements);
    }

    protected CaseStatement attachDeclarationReference(CaseStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateCase((CaseStatement)stmt, (DeclarationReference)reference);
    }

    protected CaseEffectiveStatement createEffective(EffectiveStmtCtx.Current<QName, CaseStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        try {
            return EffectiveStatements.createCase((CaseStatement)((CaseStatement)stmt.declared()), (QName)((QName)stmt.getArgument()), (int)CaseStatementSupport.computeFlags(stmt, substatements), substatements);
        }
        catch (SubstatementIndexingException e) {
            throw new SourceException(e.getMessage(), stmt, (Throwable)e);
        }
    }

    public CaseEffectiveStatement copyEffective(EffectiveStmtCtx.Current<QName, CaseStatement> stmt, CaseEffectiveStatement original) {
        return EffectiveStatements.copyCase((CaseEffectiveStatement)original, (QName)((QName)stmt.getArgument()), (int)CaseStatementSupport.computeFlags(stmt, original.effectiveSubstatements()));
    }

    @Override
    protected CaseEffectiveStatement createUndeclaredEffective(EffectiveStmtCtx.UndeclaredCurrent<QName, CaseStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        try {
            return UndeclaredStatements.createCase((QName)((QName)stmt.getArgument()), (int)CaseStatementSupport.computeFlags(stmt, substatements), substatements);
        }
        catch (SubstatementIndexingException e) {
            throw new SourceException(e.getMessage(), stmt, (Throwable)e);
        }
    }

    public EffectiveStatementState extractEffectiveState(CaseEffectiveStatement stmt) {
        Verify.verify((boolean)(stmt instanceof CaseSchemaNode), (String)"Unexpected statement %s", (Object)stmt);
        CaseSchemaNode schema = (CaseSchemaNode)stmt;
        return new QNameWithFlagsEffectiveStatementState((QName)stmt.argument(), new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory((CopyableNode)schema).setStatus(schema.getStatus()).setConfiguration((Boolean)schema.effectiveConfig().orElse(null)).toFlags());
    }

    private static int computeFlags(EffectiveStmtCtx.Current<?, ?> stmt, Collection<? extends EffectiveStatement<?, ?>> substatements) {
        Boolean config;
        EffectiveStmtCtx.Parent.EffectiveConfig effective = stmt.effectiveConfig();
        switch (effective) {
            case FALSE: {
                config = Boolean.FALSE;
                break;
            }
            case IGNORED: {
                config = null;
                break;
            }
            case TRUE: {
                Boolean sub = CaseStatementSupport.substatementEffectiveConfig(substatements);
                config = sub != null ? sub : Boolean.TRUE;
                break;
            }
            case UNDETERMINED: {
                config = CaseStatementSupport.substatementEffectiveConfig(substatements);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled effective config " + effective);
            }
        }
        return new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory((CopyableNode)stmt.history()).setStatus((Status)CaseStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, (Object)Status.CURRENT)).setConfiguration(config).toFlags();
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Internal use tagged with @Nullable")
    private static @Nullable Boolean substatementEffectiveConfig(Collection<? extends EffectiveStatement<?, ?>> substatements) {
        for (EffectiveStatement<?, ?> stmt : substatements) {
            Optional opt;
            if (!(stmt instanceof DataSchemaNode) || !(opt = ((DataSchemaNode)stmt).effectiveConfig()).isPresent()) continue;
            return (Boolean)opt.orElseThrow();
        }
        return null;
    }
}

