/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.collect.ImmutableList;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.model.spi.meta.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.FeatureNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SupportedFeaturesNamespace;

public final class FeatureStatementSupport
extends AbstractQNameStatementSupport<FeatureStatement, FeatureEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.FEATURE).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).build();

    public FeatureStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.FEATURE, StatementSupport.StatementPolicy.reject(), config, SUBSTATEMENT_VALIDATOR);
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<QName, FeatureStatement, FeatureEffectiveStatement> stmt) {
        super.onFullDefinitionDeclared(stmt);
        stmt.addContext(FeatureNamespace.class, (Object)((QName)stmt.getArgument()), stmt);
        Set supportedFeatures = (Set)stmt.getFromNamespace(SupportedFeaturesNamespace.class, (Object)Empty.value());
        if (supportedFeatures != null && !supportedFeatures.contains(stmt.getArgument())) {
            stmt.setUnsupported();
        }
    }

    protected FeatureStatement createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createFeature((QName)((QName)ctx.getArgument()), substatements);
    }

    protected FeatureStatement attachDeclarationReference(FeatureStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateFeature((FeatureStatement)stmt, (DeclarationReference)reference);
    }

    protected FeatureEffectiveStatement createEffective(EffectiveStmtCtx.Current<QName, FeatureStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createFeature((FeatureStatement)((FeatureStatement)stmt.declared()), (int)FeatureStatementSupport.computeFlags(substatements), substatements);
    }

    private static int computeFlags(ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setStatus((Status)FeatureStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, (Object)Status.CURRENT)).toFlags();
    }
}

