/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.BaseEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.model.spi.meta.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.IdentityNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class IdentityStatementSupport
extends AbstractQNameStatementSupport<IdentityStatement, IdentityEffectiveStatement> {
    private static final SubstatementValidator RFC6020_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.IDENTITY).addOptional((StatementDefinition)YangStmtMapping.BASE).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).build();
    private static final SubstatementValidator RFC7950_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.IDENTITY).addAny((StatementDefinition)YangStmtMapping.BASE).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).build();

    private IdentityStatementSupport(YangParserConfiguration config, SubstatementValidator validator) {
        super((StatementDefinition)YangStmtMapping.IDENTITY, StatementSupport.StatementPolicy.reject(), config, validator);
    }

    public static @NonNull IdentityStatementSupport rfc6020Instance(YangParserConfiguration config) {
        return new IdentityStatementSupport(config, RFC6020_VALIDATOR);
    }

    public static @NonNull IdentityStatementSupport rfc7950Instance(YangParserConfiguration config) {
        return new IdentityStatementSupport(config, RFC7950_VALIDATOR);
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public void onStatementDefinitionDeclared(StmtContext.Mutable<QName, IdentityStatement, IdentityEffectiveStatement> stmt) {
        QName qname = (QName)stmt.getArgument();
        StmtContext prev = (StmtContext)stmt.getFromNamespace(IdentityNamespace.class, (Object)qname);
        SourceException.throwIf((prev != null ? 1 : 0) != 0, stmt, (String)"Duplicate identity definition %s", (Object[])new Object[]{qname});
        stmt.addToNs(IdentityNamespace.class, (Object)qname, stmt);
    }

    protected IdentityStatement createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createIdentity((QName)((QName)ctx.getArgument()), substatements);
    }

    protected IdentityStatement attachDeclarationReference(IdentityStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateIdentity((IdentityStatement)stmt, (DeclarationReference)reference);
    }

    protected IdentityEffectiveStatement createEffective(EffectiveStmtCtx.Current<QName, IdentityStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        if (substatements.isEmpty()) {
            return EffectiveStatements.createIdentity((IdentityStatement)((IdentityStatement)stmt.declared()));
        }
        ArrayList<IdentitySchemaNode> identities = new ArrayList<IdentitySchemaNode>();
        for (EffectiveStatement substatement : substatements) {
            if (!(substatement instanceof BaseEffectiveStatement)) continue;
            QName qname = (QName)((BaseEffectiveStatement)substatement).argument();
            IdentityEffectiveStatement identity = (IdentityEffectiveStatement)((StmtContext)Verify.verifyNotNull((Object)((StmtContext)stmt.getFromNamespace(IdentityNamespace.class, (Object)qname)), (String)"Failed to find identity %s", (Object[])new Object[]{qname})).buildEffective();
            Verify.verify((boolean)(identity instanceof IdentitySchemaNode), (String)"%s is not a IdentitySchemaNode", (Object)identity);
            identities.add((IdentitySchemaNode)identity);
        }
        return EffectiveStatements.createIdentity((IdentityStatement)((IdentityStatement)stmt.declared()), (int)new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setStatus((Status)IdentityStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, (Object)Status.CURRENT)).toFlags(), substatements, (ImmutableSet)ImmutableSet.copyOf(identities));
    }
}

