/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.InputStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OutputStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.model.spi.meta.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.model.spi.meta.SubstatementIndexingException;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractSchemaTreeStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupportNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class RpcStatementSupport
extends AbstractSchemaTreeStatementSupport<RpcStatement, RpcEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.RPC).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.GROUPING).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.INPUT).addOptional((StatementDefinition)YangStmtMapping.OUTPUT).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addAny((StatementDefinition)YangStmtMapping.TYPEDEF).build();

    public RpcStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.RPC, StatementSupport.StatementPolicy.reject(), config, SUBSTATEMENT_VALIDATOR);
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<QName, RpcStatement, RpcEffectiveStatement> stmt) {
        super.onFullDefinitionDeclared(stmt);
        if (StmtContextUtils.findFirstDeclaredSubstatement(stmt, InputStatement.class) == null) {
            RpcStatementSupport.appendImplicitSubstatement(stmt, YangStmtMapping.INPUT.getStatementName());
        }
        if (StmtContextUtils.findFirstDeclaredSubstatement(stmt, OutputStatement.class) == null) {
            RpcStatementSupport.appendImplicitSubstatement(stmt, YangStmtMapping.OUTPUT.getStatementName());
        }
    }

    protected RpcStatement createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createRpc((QName)((QName)ctx.getArgument()), substatements);
    }

    protected RpcStatement attachDeclarationReference(RpcStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateRpc((RpcStatement)stmt, (DeclarationReference)reference);
    }

    protected RpcEffectiveStatement createEffective(EffectiveStmtCtx.Current<QName, RpcStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        Preconditions.checkState((!substatements.isEmpty() ? 1 : 0) != 0, (String)"Missing implicit input/output statements at %s", (Object)stmt.sourceReference());
        try {
            return EffectiveStatements.createRpc((RpcStatement)((RpcStatement)stmt.declared()), substatements, (QName)((QName)stmt.getArgument()), (int)RpcStatementSupport.computeFlags(substatements));
        }
        catch (SubstatementIndexingException e) {
            throw new SourceException(e.getMessage(), stmt, (Throwable)e);
        }
    }

    private static int computeFlags(ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setStatus((Status)RpcStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, (Object)Status.CURRENT)).toFlags();
    }

    private static void appendImplicitSubstatement(StmtContext.Mutable<QName, RpcStatement, RpcEffectiveStatement> stmt, QName substatementName) {
        stmt.addEffectiveSubstatement(stmt.createUndeclaredSubstatement((StatementSupport)Verify.verifyNotNull((Object)((StatementSupport)stmt.getFromNamespace(StatementSupportNamespace.class, (Object)substatementName))), null));
    }
}

