/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class StatusStatementSupport
extends AbstractStatementSupport<Status, StatusStatement, StatusEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.STATUS).build();

    public StatusStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.STATUS, StatementSupport.StatementPolicy.contextIndependent(), config, SUBSTATEMENT_VALIDATOR);
    }

    public Status parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        switch (value) {
            case "current": {
                return Status.CURRENT;
            }
            case "deprecated": {
                return Status.DEPRECATED;
            }
            case "obsolete": {
                return Status.OBSOLETE;
            }
        }
        throw new SourceException(ctx, "Invalid status '%s', must be one of 'current', 'deprecated' or 'obsolete'", new Object[]{value});
    }

    public String internArgument(String rawArgument) {
        if ("current".equals(rawArgument)) {
            return "current";
        }
        if ("deprecated".equals(rawArgument)) {
            return "deprecated";
        }
        if ("obsolete".equals(rawArgument)) {
            return "obsolete";
        }
        return rawArgument;
    }

    protected StatusStatement createDeclared(BoundStmtCtx<Status> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createStatus((Status)((Status)ctx.getArgument()), substatements);
    }

    protected StatusStatement attachDeclarationReference(StatusStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateStatus((StatusStatement)stmt, (DeclarationReference)reference);
    }

    protected StatusEffectiveStatement createEffective(EffectiveStmtCtx.Current<Status, StatusStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createStatus((StatusStatement)((StatusStatement)stmt.declared()), substatements);
    }
}

