/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.BitEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.EnumEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.FractionDigitsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LengthEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PatternEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RangeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RequireInstanceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeRestrictedTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.TypeDefinitions;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.type.BitsTypeBuilder;
import org.opendaylight.yangtools.yang.model.ri.type.EnumerationTypeBuilder;
import org.opendaylight.yangtools.yang.model.ri.type.InstanceIdentifierTypeBuilder;
import org.opendaylight.yangtools.yang.model.ri.type.InvalidLengthConstraintException;
import org.opendaylight.yangtools.yang.model.ri.type.InvalidRangeConstraintException;
import org.opendaylight.yangtools.yang.model.ri.type.LengthRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.ri.type.RangeRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.ri.type.RequireInstanceRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.ri.type.RestrictedTypes;
import org.opendaylight.yangtools.yang.model.ri.type.StringTypeBuilder;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.AbstractTypeSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.BaseTypeNamespace;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.BitsSpecificationSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.BuiltinEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.BuiltinTypeStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.Decimal64SpecificationSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.EnumSpecificationSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.IdentityRefSpecificationSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.InstanceIdentifierSpecificationSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.LeafrefSpecificationSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.TypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.UnionSpecificationSupport;
import org.opendaylight.yangtools.yang.parser.spi.TypeNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.meta.UndeclaredStatementFactory;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

abstract class AbstractTypeStatementSupport
extends AbstractTypeSupport<TypeStatement>
implements UndeclaredStatementFactory<QName, TypeStatement, TypeEffectiveStatement<TypeStatement>> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.TYPE).addOptional((StatementDefinition)YangStmtMapping.BASE).addAny((StatementDefinition)YangStmtMapping.BIT).addAny((StatementDefinition)YangStmtMapping.ENUM).addOptional((StatementDefinition)YangStmtMapping.FRACTION_DIGITS).addOptional((StatementDefinition)YangStmtMapping.LENGTH).addOptional((StatementDefinition)YangStmtMapping.PATH).addAny((StatementDefinition)YangStmtMapping.PATTERN).addOptional((StatementDefinition)YangStmtMapping.RANGE).addOptional((StatementDefinition)YangStmtMapping.REQUIRE_INSTANCE).addAny((StatementDefinition)YangStmtMapping.TYPE).build();
    private static final ImmutableMap<QName, BuiltinEffectiveStatement> STATIC_BUILT_IN_TYPES = ImmutableMap.builder().put((Object)TypeDefinitions.BINARY, (Object)BuiltinEffectiveStatement.BINARY).put((Object)TypeDefinitions.BOOLEAN, (Object)BuiltinEffectiveStatement.BOOLEAN).put((Object)TypeDefinitions.EMPTY, (Object)BuiltinEffectiveStatement.EMPTY).put((Object)TypeDefinitions.INSTANCE_IDENTIFIER, (Object)BuiltinEffectiveStatement.INSTANCE_IDENTIFIER).put((Object)TypeDefinitions.INT8, (Object)BuiltinEffectiveStatement.INT8).put((Object)TypeDefinitions.INT16, (Object)BuiltinEffectiveStatement.INT16).put((Object)TypeDefinitions.INT32, (Object)BuiltinEffectiveStatement.INT32).put((Object)TypeDefinitions.INT64, (Object)BuiltinEffectiveStatement.INT64).put((Object)TypeDefinitions.STRING, (Object)BuiltinEffectiveStatement.STRING).put((Object)TypeDefinitions.UINT8, (Object)BuiltinEffectiveStatement.UINT8).put((Object)TypeDefinitions.UINT16, (Object)BuiltinEffectiveStatement.UINT16).put((Object)TypeDefinitions.UINT32, (Object)BuiltinEffectiveStatement.UINT32).put((Object)TypeDefinitions.UINT64, (Object)BuiltinEffectiveStatement.UINT64).build();
    private final ImmutableMap<String, StatementSupport<?, ?, ?>> dynamicBuiltInTypes;

    AbstractTypeStatementSupport(YangParserConfiguration config) {
        super(config, SUBSTATEMENT_VALIDATOR);
        this.dynamicBuiltInTypes = ImmutableMap.builder().put((Object)TypeDefinitions.BITS.getLocalName(), (Object)new BitsSpecificationSupport(config)).put((Object)TypeDefinitions.DECIMAL64.getLocalName(), (Object)new Decimal64SpecificationSupport(config)).put((Object)TypeDefinitions.ENUMERATION.getLocalName(), (Object)new EnumSpecificationSupport(config)).put((Object)TypeDefinitions.IDENTITYREF.getLocalName(), (Object)IdentityRefSpecificationSupport.rfc6020Instance(config)).put((Object)TypeDefinitions.INSTANCE_IDENTIFIER.getLocalName(), (Object)new InstanceIdentifierSpecificationSupport(config)).put((Object)TypeDefinitions.LEAFREF.getLocalName(), (Object)LeafrefSpecificationSupport.rfc6020Instance(config)).put((Object)TypeDefinitions.UNION.getLocalName(), (Object)new UnionSpecificationSupport(config)).build();
    }

    public final void onFullDefinitionDeclared(final StmtContext.Mutable<QName, TypeStatement, EffectiveStatement<QName, TypeStatement>> stmt) {
        super.onFullDefinitionDeclared(stmt);
        final QName typeQName = (QName)stmt.getArgument();
        BuiltinEffectiveStatement builtin = (BuiltinEffectiveStatement)((Object)STATIC_BUILT_IN_TYPES.get((Object)typeQName));
        if (builtin != null) {
            stmt.addToNs(BaseTypeNamespace.class, (Object)Empty.value(), (Object)builtin);
            return;
        }
        ModelActionBuilder typeAction = stmt.newInferenceAction(ModelProcessingPhase.EFFECTIVE_MODEL);
        final ModelActionBuilder.Prerequisite typePrereq = typeAction.requiresCtx(stmt, TypeNamespace.class, (Object)typeQName, ModelProcessingPhase.EFFECTIVE_MODEL);
        typeAction.mutatesEffectiveCtx(stmt.getParentContext());
        typeAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                stmt.addToNs(BaseTypeNamespace.class, (Object)Empty.value(), (Object)((StmtContext)typePrereq.resolve(ctx)));
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                InferenceException.throwIf((boolean)failed.contains(typePrereq), (CommonStmtCtx)stmt, (String)"Type [%s] was not found.", (Object[])new Object[]{typeQName});
            }
        });
    }

    public boolean hasArgumentSpecificSupports() {
        return !this.dynamicBuiltInTypes.isEmpty();
    }

    public StatementSupport<?, ?, ?> getSupportSpecificForArgument(String argument) {
        return (StatementSupport)this.dynamicBuiltInTypes.get((Object)argument);
    }

    public final TypeEffectiveStatement<TypeStatement> createUndeclaredEffective(EffectiveStmtCtx.UndeclaredCurrent<QName, TypeStatement> stmt, Stream<? extends StmtContext<?, ?, ?>> effectiveSubstatements) {
        ImmutableList substatements = this.buildEffectiveSubstatements((EffectiveStmtCtx.Current)stmt, this.statementsToBuild((EffectiveStmtCtx.Current)stmt, effectiveSubstatements.filter(StmtContext::isSupportedToBuildEffective).collect(Collectors.toUnmodifiableList())));
        TypeEffectiveStatement<TypeStatement> typeStmt = AbstractTypeStatementSupport.resolveType(stmt);
        if (substatements.isEmpty()) {
            return typeStmt;
        }
        throw new UnsupportedOperationException("Non-empty undeclared type statements are not implemented yet");
    }

    protected final TypeStatement createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        TypeStatement builtin;
        if (substatements.isEmpty() && (builtin = BuiltinTypeStatement.lookup(ctx.getRawArgument())) != null) {
            return builtin;
        }
        return DeclaredStatements.createType((String)ctx.getRawArgument(), (QName)((QName)ctx.getArgument()), substatements);
    }

    protected final TypeStatement attachDeclarationReference(TypeStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateType((TypeStatement)stmt, (DeclarationReference)reference);
    }

    protected EffectiveStatement<QName, TypeStatement> createEffective(EffectiveStmtCtx.Current<QName, TypeStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        TypeEffectiveStatement<TypeStatement> typeStmt = AbstractTypeStatementSupport.resolveType(stmt);
        if (substatements.isEmpty()) {
            return typeStmt;
        }
        TypeDefinition baseType = typeStmt.getTypeDefinition();
        TypeStatement declared = (TypeStatement)stmt.declared();
        if (baseType instanceof BinaryTypeDefinition) {
            return AbstractTypeStatementSupport.createBinary(stmt, (BinaryTypeDefinition)baseType, declared, substatements);
        }
        if (baseType instanceof BitsTypeDefinition) {
            return this.createBits(stmt, (BitsTypeDefinition)baseType, declared, substatements);
        }
        if (baseType instanceof BooleanTypeDefinition) {
            return AbstractTypeStatementSupport.createBoolean(stmt, (BooleanTypeDefinition)baseType, declared, substatements);
        }
        if (baseType instanceof DecimalTypeDefinition) {
            return AbstractTypeStatementSupport.createDecimal(stmt, (DecimalTypeDefinition)baseType, declared, substatements);
        }
        if (baseType instanceof EmptyTypeDefinition) {
            return AbstractTypeStatementSupport.createEmpty(stmt, (EmptyTypeDefinition)baseType, declared, substatements);
        }
        if (baseType instanceof EnumTypeDefinition) {
            return this.createEnum(stmt, (EnumTypeDefinition)baseType, declared, substatements);
        }
        if (baseType instanceof IdentityrefTypeDefinition) {
            return AbstractTypeStatementSupport.createIdentityref(stmt, (IdentityrefTypeDefinition)baseType, declared, substatements);
        }
        if (baseType instanceof InstanceIdentifierTypeDefinition) {
            return AbstractTypeStatementSupport.createInstanceIdentifier(stmt, (InstanceIdentifierTypeDefinition)baseType, declared, substatements);
        }
        if (baseType instanceof Int8TypeDefinition) {
            return AbstractTypeStatementSupport.createIntegral(stmt, declared, substatements, RestrictedTypes.newInt8Builder((Int8TypeDefinition)((Int8TypeDefinition)baseType), (QName)AbstractTypeStatementSupport.typeEffectiveQName(stmt)));
        }
        if (baseType instanceof Int16TypeDefinition) {
            return AbstractTypeStatementSupport.createIntegral(stmt, declared, substatements, RestrictedTypes.newInt16Builder((Int16TypeDefinition)((Int16TypeDefinition)baseType), (QName)AbstractTypeStatementSupport.typeEffectiveQName(stmt)));
        }
        if (baseType instanceof Int32TypeDefinition) {
            return AbstractTypeStatementSupport.createIntegral(stmt, declared, substatements, RestrictedTypes.newInt32Builder((Int32TypeDefinition)((Int32TypeDefinition)baseType), (QName)AbstractTypeStatementSupport.typeEffectiveQName(stmt)));
        }
        if (baseType instanceof Int64TypeDefinition) {
            return AbstractTypeStatementSupport.createIntegral(stmt, declared, substatements, RestrictedTypes.newInt64Builder((Int64TypeDefinition)((Int64TypeDefinition)baseType), (QName)AbstractTypeStatementSupport.typeEffectiveQName(stmt)));
        }
        if (baseType instanceof LeafrefTypeDefinition) {
            return AbstractTypeStatementSupport.createLeafref(stmt, (LeafrefTypeDefinition)baseType, declared, substatements);
        }
        if (baseType instanceof StringTypeDefinition) {
            return AbstractTypeStatementSupport.createString(stmt, (StringTypeDefinition)baseType, declared, substatements);
        }
        if (baseType instanceof Uint8TypeDefinition) {
            return AbstractTypeStatementSupport.createIntegral(stmt, declared, substatements, RestrictedTypes.newUint8Builder((Uint8TypeDefinition)((Uint8TypeDefinition)baseType), (QName)AbstractTypeStatementSupport.typeEffectiveQName(stmt)));
        }
        if (baseType instanceof Uint16TypeDefinition) {
            return AbstractTypeStatementSupport.createIntegral(stmt, declared, substatements, RestrictedTypes.newUint16Builder((Uint16TypeDefinition)((Uint16TypeDefinition)baseType), (QName)AbstractTypeStatementSupport.typeEffectiveQName(stmt)));
        }
        if (baseType instanceof Uint32TypeDefinition) {
            return AbstractTypeStatementSupport.createIntegral(stmt, declared, substatements, RestrictedTypes.newUint32Builder((Uint32TypeDefinition)((Uint32TypeDefinition)baseType), (QName)AbstractTypeStatementSupport.typeEffectiveQName(stmt)));
        }
        if (baseType instanceof Uint64TypeDefinition) {
            return AbstractTypeStatementSupport.createIntegral(stmt, declared, substatements, RestrictedTypes.newUint64Builder((Uint64TypeDefinition)((Uint64TypeDefinition)baseType), (QName)AbstractTypeStatementSupport.typeEffectiveQName(stmt)));
        }
        if (baseType instanceof UnionTypeDefinition) {
            return AbstractTypeStatementSupport.createUnion(stmt, (UnionTypeDefinition)baseType, declared, substatements);
        }
        throw new IllegalStateException("Unhandled base type " + baseType);
    }

    static final @NonNull QName typeEffectiveQName(EffectiveStmtCtx.Current<QName, ?> stmt) {
        return ((QName)stmt.getArgument()).bindTo(stmt.getEffectiveParent().effectiveNamespace()).intern();
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> resolveType(NamespaceStmtCtx ctx) {
        Object obj = Verify.verifyNotNull((Object)ctx.namespaceItem(BaseTypeNamespace.class, (Object)Empty.value()));
        if (obj instanceof BuiltinEffectiveStatement) {
            return (BuiltinEffectiveStatement)((Object)obj);
        }
        if (obj instanceof StmtContext) {
            return ((TypedefEffectiveStatement)((StmtContext)obj).buildEffective()).asTypeEffectiveStatement();
        }
        throw new InferenceException((CommonStmtCtx)ctx, "Unexpected base object %s", new Object[]{obj});
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createBinary(EffectiveStmtCtx.Current<QName, ?> ctx, BinaryTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        LengthRestrictedTypeBuilder builder = RestrictedTypes.newBinaryBuilder((BinaryTypeDefinition)baseType, (QName)AbstractTypeStatementSupport.typeEffectiveQName(ctx));
        for (EffectiveStatement stmt : substatements) {
            if (!(stmt instanceof LengthEffectiveStatement)) continue;
            LengthEffectiveStatement length = (LengthEffectiveStatement)stmt;
            try {
                builder.setLengthConstraint((ConstraintMetaDefinition)length, (List)length.argument());
            }
            catch (IllegalStateException e) {
                throw new SourceException(ctx, (Throwable)e, "Multiple length constraints encountered", new Object[0]);
            }
            catch (InvalidLengthConstraintException e) {
                throw new SourceException(ctx, (Throwable)e, "Invalid length constraint %s", new Object[]{length.argument()});
            }
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private @NonNull TypeEffectiveStatement<TypeStatement> createBits(EffectiveStmtCtx.Current<?, ?> ctx, BitsTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        BitsTypeBuilder builder = RestrictedTypes.newBitsBuilder((BitsTypeDefinition)baseType, (QName)ctx.argumentAsTypeQName());
        for (EffectiveStatement stmt : substatements) {
            if (!(stmt instanceof BitEffectiveStatement)) continue;
            builder.addBit(this.addRestrictedBit((EffectiveStmtCtx)ctx, baseType, (BitEffectiveStatement)stmt));
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    abstract // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BitsTypeDefinition.Bit addRestrictedBit(@NonNull EffectiveStmtCtx var1, @NonNull BitsTypeDefinition var2, @NonNull BitEffectiveStatement var3);

    private static @NonNull TypeEffectiveStatement<TypeStatement> createBoolean(EffectiveStmtCtx.Current<QName, ?> ctx, BooleanTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new TypeEffectiveStatementImpl(declared, substatements, RestrictedTypes.newBooleanBuilder((BooleanTypeDefinition)baseType, (QName)AbstractTypeStatementSupport.typeEffectiveQName(ctx)));
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createDecimal(EffectiveStmtCtx.Current<QName, ?> ctx, DecimalTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        RangeRestrictedTypeBuilder builder = RestrictedTypes.newDecima64Builder((DecimalTypeDefinition)baseType, (QName)AbstractTypeStatementSupport.typeEffectiveQName(ctx));
        for (EffectiveStatement stmt : substatements) {
            if (stmt instanceof RangeEffectiveStatement) {
                RangeEffectiveStatement range = (RangeEffectiveStatement)stmt;
                builder.setRangeConstraint((ConstraintMetaDefinition)range, (List)range.argument());
            }
            if (!(stmt instanceof FractionDigitsEffectiveStatement)) continue;
            Integer digits = (Integer)((FractionDigitsEffectiveStatement)stmt).argument();
            SourceException.throwIf((baseType.getFractionDigits() != digits.intValue() ? 1 : 0) != 0, ctx, (String)"Cannot override fraction-digits from base type %s to %s", (Object[])new Object[]{baseType, digits});
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createEmpty(EffectiveStmtCtx.Current<QName, ?> ctx, EmptyTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new TypeEffectiveStatementImpl(declared, substatements, RestrictedTypes.newEmptyBuilder((EmptyTypeDefinition)baseType, (QName)AbstractTypeStatementSupport.typeEffectiveQName(ctx)));
    }

    private @NonNull TypeEffectiveStatement<TypeStatement> createEnum(EffectiveStmtCtx.Current<?, ?> ctx, EnumTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        EnumerationTypeBuilder builder = RestrictedTypes.newEnumerationBuilder((EnumTypeDefinition)baseType, (QName)ctx.argumentAsTypeQName());
        for (EffectiveStatement stmt : substatements) {
            if (!(stmt instanceof EnumEffectiveStatement)) continue;
            builder.addEnum(this.addRestrictedEnum((EffectiveStmtCtx)ctx, baseType, (EnumEffectiveStatement)stmt));
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    abstract // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull EnumTypeDefinition.EnumPair addRestrictedEnum(@NonNull EffectiveStmtCtx var1, @NonNull EnumTypeDefinition var2, @NonNull EnumEffectiveStatement var3);

    private static @NonNull TypeEffectiveStatement<TypeStatement> createIdentityref(EffectiveStmtCtx.Current<QName, ?> ctx, IdentityrefTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new TypeEffectiveStatementImpl(declared, substatements, RestrictedTypes.newIdentityrefBuilder((IdentityrefTypeDefinition)baseType, (QName)AbstractTypeStatementSupport.typeEffectiveQName(ctx)));
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createInstanceIdentifier(EffectiveStmtCtx.Current<QName, ?> ctx, InstanceIdentifierTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        InstanceIdentifierTypeBuilder builder = RestrictedTypes.newInstanceIdentifierBuilder((InstanceIdentifierTypeDefinition)baseType, (QName)AbstractTypeStatementSupport.typeEffectiveQName(ctx));
        for (EffectiveStatement stmt : substatements) {
            if (!(stmt instanceof RequireInstanceEffectiveStatement)) continue;
            builder.setRequireInstance(((Boolean)((RequireInstanceEffectiveStatement)stmt).argument()).booleanValue());
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private static <T extends RangeRestrictedTypeDefinition<T, N>, N extends Number> @NonNull TypeEffectiveStatement<TypeStatement> createIntegral(EffectiveStmtCtx.Current<?, ?> ctx, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, RangeRestrictedTypeBuilder<T, N> builder) {
        for (EffectiveStatement stmt : substatements) {
            if (!(stmt instanceof RangeEffectiveStatement)) continue;
            RangeEffectiveStatement rangeStmt = (RangeEffectiveStatement)stmt;
            builder.setRangeConstraint((ConstraintMetaDefinition)rangeStmt, (List)rangeStmt.argument());
        }
        try {
            return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
        }
        catch (InvalidRangeConstraintException e) {
            throw new SourceException(ctx, (Throwable)e, "Invalid range constraint: %s", new Object[]{e.getOffendingRanges()});
        }
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createLeafref(EffectiveStmtCtx.Current<QName, ?> ctx, LeafrefTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        RequireInstanceRestrictedTypeBuilder builder = RestrictedTypes.newLeafrefBuilder((LeafrefTypeDefinition)baseType, (QName)AbstractTypeStatementSupport.typeEffectiveQName(ctx));
        for (EffectiveStatement stmt : substatements) {
            if (!(stmt instanceof RequireInstanceEffectiveStatement)) continue;
            builder.setRequireInstance(((Boolean)((RequireInstanceEffectiveStatement)stmt).argument()).booleanValue());
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createString(EffectiveStmtCtx.Current<QName, ?> ctx, StringTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        StringTypeBuilder builder = RestrictedTypes.newStringBuilder((StringTypeDefinition)baseType, (QName)AbstractTypeStatementSupport.typeEffectiveQName(ctx));
        for (EffectiveStatement stmt : substatements) {
            if (stmt instanceof LengthEffectiveStatement) {
                LengthEffectiveStatement length = (LengthEffectiveStatement)stmt;
                try {
                    builder.setLengthConstraint((ConstraintMetaDefinition)length, (List)length.argument());
                }
                catch (IllegalStateException e) {
                    throw new SourceException(ctx, (Throwable)e, "Multiple length constraints encountered", new Object[0]);
                }
                catch (InvalidLengthConstraintException e) {
                    throw new SourceException(ctx, (Throwable)e, "Invalid length constraint %s", new Object[]{length.argument()});
                }
            }
            if (!(stmt instanceof PatternEffectiveStatement)) continue;
            builder.addPatternConstraint((PatternConstraint)((PatternEffectiveStatement)stmt));
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private static @NonNull TypeEffectiveStatement<TypeStatement> createUnion(EffectiveStmtCtx.Current<QName, ?> ctx, UnionTypeDefinition baseType, TypeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new TypeEffectiveStatementImpl(declared, substatements, RestrictedTypes.newUnionBuilder((UnionTypeDefinition)baseType, (QName)AbstractTypeStatementSupport.typeEffectiveQName(ctx)));
    }
}

