/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.FractionDigitsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RangeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.ri.type.BaseTypes;
import org.opendaylight.yangtools.yang.model.ri.type.DecimalTypeBuilder;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.AbstractTypeSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.Decimal64SpecificationImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.RefDecimal64Specification;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.TypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

final class Decimal64SpecificationSupport
extends AbstractTypeSupport<TypeStatement.Decimal64Specification> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.TYPE).addMandatory((StatementDefinition)YangStmtMapping.FRACTION_DIGITS).addOptional((StatementDefinition)YangStmtMapping.RANGE).build();

    Decimal64SpecificationSupport(YangParserConfiguration config) {
        super(config, SUBSTATEMENT_VALIDATOR);
    }

    protected TypeStatement.Decimal64Specification createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        if (substatements.isEmpty()) {
            throw Decimal64SpecificationSupport.noFracDigits(ctx);
        }
        return new Decimal64SpecificationImpl(ctx.getRawArgument(), (QName)ctx.getArgument(), substatements);
    }

    protected TypeStatement.Decimal64Specification attachDeclarationReference(TypeStatement.Decimal64Specification stmt, DeclarationReference reference) {
        return new RefDecimal64Specification(stmt, reference);
    }

    protected EffectiveStatement<QName, TypeStatement.Decimal64Specification> createEffective(EffectiveStmtCtx.Current<QName, TypeStatement.Decimal64Specification> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        if (substatements.isEmpty()) {
            throw Decimal64SpecificationSupport.noFracDigits(stmt);
        }
        DecimalTypeBuilder builder = BaseTypes.decimalTypeBuilder((QName)stmt.argumentAsTypeQName());
        for (EffectiveStatement subStmt : substatements) {
            if (subStmt instanceof FractionDigitsEffectiveStatement) {
                builder.setFractionDigits(((Integer)((FractionDigitsEffectiveStatement)subStmt).argument()).intValue());
            }
            if (!(subStmt instanceof RangeEffectiveStatement)) continue;
            RangeEffectiveStatement range = (RangeEffectiveStatement)subStmt;
            builder.setRangeConstraint((ConstraintMetaDefinition)range, (List)range.argument());
        }
        return new TypeEffectiveStatementImpl((TypeStatement.Decimal64Specification)stmt.declared(), (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    private static SourceException noFracDigits(CommonStmtCtx stmt) {
        return new SourceException("At least one fraction-digits statement has to be present", stmt);
    }
}

