/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.model.api.stmt.BitEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.EnumEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.EnumStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ValueEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.TypeDefinitions;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.AbstractTypeStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.EffectiveTypeUtil;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.IdentityRefSpecificationSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.LeafrefSpecificationSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class TypeStatementRFC7950Support
extends AbstractTypeStatementSupport {
    private final ImmutableMap<String, StatementSupport<?, ?, ?>> argumentSpecificSupports;

    public TypeStatementRFC7950Support(YangParserConfiguration config) {
        super(config);
        this.argumentSpecificSupports = ImmutableMap.of((Object)TypeDefinitions.LEAFREF.getLocalName(), (Object)((Object)LeafrefSpecificationSupport.rfc7950Instance(config)), (Object)TypeDefinitions.IDENTITYREF.getLocalName(), (Object)((Object)IdentityRefSpecificationSupport.rfc7950Instance(config)));
    }

    @Override
    public boolean hasArgumentSpecificSupports() {
        return !this.argumentSpecificSupports.isEmpty() || super.hasArgumentSpecificSupports();
    }

    @Override
    public StatementSupport<?, ?, ?> getSupportSpecificForArgument(String argument) {
        StatementSupport<?, ?, ?> potential = (StatementSupport<?, ?, ?>)this.argumentSpecificSupports.get((Object)argument);
        return potential != null ? potential : super.getSupportSpecificForArgument(argument);
    }

    @Override
    BitsTypeDefinition.Bit addRestrictedBit(EffectiveStmtCtx stmt, BitsTypeDefinition base, BitEffectiveStatement bit) {
        Optional declaredPosition = bit.getDeclaredPosition();
        Uint32 effectivePos = declaredPosition.isEmpty() ? TypeStatementRFC7950Support.getBaseTypeBitPosition((String)bit.argument(), base, stmt) : (Uint32)declaredPosition.get();
        return EffectiveTypeUtil.buildBit(bit, effectivePos);
    }

    @Override
    EnumTypeDefinition.EnumPair addRestrictedEnum(EffectiveStmtCtx stmt, EnumTypeDefinition base, EnumEffectiveStatement enumStmt) {
        EnumEffectiveStatement enumSubStmt = enumStmt;
        Optional declaredValue = enumSubStmt.findFirstEffectiveSubstatementArgument(ValueEffectiveStatement.class);
        int effectiveValue = declaredValue.isEmpty() ? TypeStatementRFC7950Support.getBaseTypeEnumValue(((EnumStatement)enumSubStmt.getDeclared()).rawArgument(), base, stmt) : (Integer)declaredValue.orElseThrow();
        return EffectiveTypeUtil.buildEnumPair(enumSubStmt, effectiveValue);
    }

    private static Uint32 getBaseTypeBitPosition(String bitName, BitsTypeDefinition baseType, EffectiveStmtCtx stmt) {
        for (BitsTypeDefinition.Bit baseTypeBit : baseType.getBits()) {
            if (!bitName.equals(baseTypeBit.getName())) continue;
            return baseTypeBit.getPosition();
        }
        throw new SourceException((CommonStmtCtx)stmt, "Bit '%s' is not a subset of its base bits type %s.", new Object[]{bitName, baseType.getQName()});
    }

    private static int getBaseTypeEnumValue(String enumName, EnumTypeDefinition baseType, EffectiveStmtCtx ctx) {
        for (EnumTypeDefinition.EnumPair baseTypeEnumPair : baseType.getValues()) {
            if (!enumName.equals(baseTypeEnumPair.getName())) continue;
            return baseTypeEnumPair.getValue();
        }
        throw new SourceException((CommonStmtCtx)ctx, "Enum '%s' is not a subset of its base enumeration type %s.", new Object[]{enumName, baseType.getQName()});
    }
}

