/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.binfmt;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.yangtools.util.ImmutableOffsetMap;
import org.opendaylight.yangtools.util.ImmutableOffsetMapTemplate;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.binfmt.AbstractNormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.InvalidNormalizedNodeStreamException;
import org.opendaylight.yangtools.yang.data.codec.binfmt.QNameFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

abstract class AbstractLithiumDataInput
extends AbstractNormalizedNodeDataInput {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLithiumDataInput.class);
    private final List<String> codedStringMap = new ArrayList<String>();
    private QName lastLeafSetQName;

    AbstractLithiumDataInput(DataInput input) {
        super(input);
    }

    @Override
    public final void streamNormalizedNode(NormalizedNodeStreamWriter writer) throws IOException {
        this.streamNormalizedNode(Objects.requireNonNull(writer), this.input.readByte());
    }

    private void streamNormalizedNode(NormalizedNodeStreamWriter writer, byte nodeType) throws IOException {
        switch (nodeType) {
            case 12: {
                this.streamAnyxml(writer);
                break;
            }
            case 11: {
                this.streamAugmentation(writer);
                break;
            }
            case 10: {
                this.streamChoice(writer);
                break;
            }
            case 4: {
                this.streamContainer(writer);
                break;
            }
            case 1: {
                this.streamLeaf(writer);
                break;
            }
            case 2: {
                this.streamLeafSet(writer);
                break;
            }
            case 14: {
                this.streamOrderedLeafSet(writer);
                break;
            }
            case 3: {
                this.streamLeafSetEntry(writer);
                break;
            }
            case 8: {
                this.streamMapEntry(writer);
                break;
            }
            case 7: {
                this.streamMap(writer);
                break;
            }
            case 9: {
                this.streamOrderedMap(writer);
                break;
            }
            case 5: {
                this.streamUnkeyedList(writer);
                break;
            }
            case 6: {
                this.streamUnkeyedListItem(writer);
                break;
            }
            default: {
                throw new InvalidNormalizedNodeStreamException("Unexpected node " + nodeType);
            }
        }
    }

    private void streamAnyxml(NormalizedNodeStreamWriter writer) throws IOException {
        YangInstanceIdentifier.NodeIdentifier identifier = this.readNodeIdentifier();
        LOG.trace("Streaming anyxml node {}", (Object)identifier);
        DOMSource value = this.readDOMSource();
        if (writer.startAnyxmlNode(identifier, DOMSource.class)) {
            writer.domSourceValue(value);
            writer.endNode();
        }
    }

    private void streamAugmentation(NormalizedNodeStreamWriter writer) throws IOException {
        YangInstanceIdentifier.AugmentationIdentifier augIdentifier = this.readAugmentationIdentifier();
        LOG.trace("Streaming augmentation node {}", (Object)augIdentifier);
        writer.startAugmentationNode(augIdentifier);
        this.commonStreamContainer(writer);
    }

    private void streamChoice(NormalizedNodeStreamWriter writer) throws IOException {
        YangInstanceIdentifier.NodeIdentifier identifier = this.readNodeIdentifier();
        LOG.trace("Streaming choice node {}", (Object)identifier);
        writer.startChoiceNode(identifier, -1);
        this.commonStreamContainer(writer);
    }

    private void streamContainer(NormalizedNodeStreamWriter writer) throws IOException {
        YangInstanceIdentifier.NodeIdentifier identifier = this.readNodeIdentifier();
        LOG.trace("Streaming container node {}", (Object)identifier);
        writer.startContainerNode(identifier, -1);
        this.commonStreamContainer(writer);
    }

    private void streamLeaf(NormalizedNodeStreamWriter writer) throws IOException {
        this.startLeaf(writer);
        AbstractLithiumDataInput.endLeaf(writer, this.readObject());
    }

    private void streamLeaf(NormalizedNodeStreamWriter writer, YangInstanceIdentifier.NodeIdentifierWithPredicates entryId) throws IOException {
        YangInstanceIdentifier.NodeIdentifier identifier = this.startLeaf(writer);
        Object value = this.readObject();
        Object entryValue = entryId.getValue(identifier.getNodeType());
        AbstractLithiumDataInput.endLeaf(writer, entryValue == null ? value : entryValue);
    }

    private YangInstanceIdentifier.NodeIdentifier startLeaf(NormalizedNodeStreamWriter writer) throws IOException {
        YangInstanceIdentifier.NodeIdentifier identifier = this.readNodeIdentifier();
        LOG.trace("Streaming leaf node {}", (Object)identifier);
        writer.startLeafNode(identifier);
        return identifier;
    }

    private static void endLeaf(NormalizedNodeStreamWriter writer, Object value) throws IOException {
        writer.scalarValue(value);
        writer.endNode();
    }

    private void streamLeafSet(NormalizedNodeStreamWriter writer) throws IOException {
        YangInstanceIdentifier.NodeIdentifier identifier = this.readNodeIdentifier();
        LOG.trace("Streaming leaf set node {}", (Object)identifier);
        writer.startLeafSet(identifier, -1);
        this.commonStreamLeafSet(writer, identifier);
    }

    private void streamOrderedLeafSet(NormalizedNodeStreamWriter writer) throws IOException {
        YangInstanceIdentifier.NodeIdentifier identifier = this.readNodeIdentifier();
        LOG.trace("Streaming ordered leaf set node {}", (Object)identifier);
        writer.startOrderedLeafSet(identifier, -1);
        this.commonStreamLeafSet(writer, identifier);
    }

    private void commonStreamLeafSet(NormalizedNodeStreamWriter writer, YangInstanceIdentifier.NodeIdentifier identifier) throws IOException {
        this.lastLeafSetQName = identifier.getNodeType();
        try {
            this.commonStreamContainer(writer);
        }
        finally {
            this.lastLeafSetQName = null;
        }
    }

    private void streamLeafSetEntry(NormalizedNodeStreamWriter writer) throws IOException {
        QName name = this.lastLeafSetQName != null ? this.lastLeafSetQName : this.readQName();
        Object value = this.readObject();
        YangInstanceIdentifier.NodeWithValue leafIdentifier = new YangInstanceIdentifier.NodeWithValue(name, value);
        LOG.trace("Streaming leaf set entry node {}, value {}", (Object)leafIdentifier, value);
        writer.startLeafSetEntryNode(leafIdentifier);
        writer.scalarValue(value);
        writer.endNode();
    }

    private void streamMap(NormalizedNodeStreamWriter writer) throws IOException {
        YangInstanceIdentifier.NodeIdentifier identifier = this.readNodeIdentifier();
        LOG.trace("Streaming map node {}", (Object)identifier);
        writer.startMapNode(identifier, -1);
        this.commonStreamContainer(writer);
    }

    private void streamOrderedMap(NormalizedNodeStreamWriter writer) throws IOException {
        YangInstanceIdentifier.NodeIdentifier identifier = this.readNodeIdentifier();
        LOG.trace("Streaming ordered map node {}", (Object)identifier);
        writer.startOrderedMapNode(identifier, -1);
        this.commonStreamContainer(writer);
    }

    private void streamMapEntry(NormalizedNodeStreamWriter writer) throws IOException {
        YangInstanceIdentifier.NodeIdentifierWithPredicates entryIdentifier = this.readNormalizedNodeWithPredicates();
        LOG.trace("Streaming map entry node {}", (Object)entryIdentifier);
        writer.startMapEntryNode(entryIdentifier, -1);
        byte nodeType = this.input.readByte();
        while (nodeType != 13) {
            if (nodeType == 1) {
                this.streamLeaf(writer, entryIdentifier);
            } else {
                this.streamNormalizedNode(writer, nodeType);
            }
            nodeType = this.input.readByte();
        }
        writer.endNode();
    }

    private void streamUnkeyedList(NormalizedNodeStreamWriter writer) throws IOException {
        YangInstanceIdentifier.NodeIdentifier identifier = this.readNodeIdentifier();
        LOG.trace("Streaming unkeyed list node {}", (Object)identifier);
        writer.startUnkeyedList(identifier, -1);
        this.commonStreamContainer(writer);
    }

    private void streamUnkeyedListItem(NormalizedNodeStreamWriter writer) throws IOException {
        YangInstanceIdentifier.NodeIdentifier identifier = this.readNodeIdentifier();
        LOG.trace("Streaming unkeyed list item node {}", (Object)identifier);
        writer.startUnkeyedListItem(identifier, -1);
        this.commonStreamContainer(writer);
    }

    private void commonStreamContainer(NormalizedNodeStreamWriter writer) throws IOException {
        byte nodeType = this.input.readByte();
        while (nodeType != 13) {
            this.streamNormalizedNode(writer, nodeType);
            nodeType = this.input.readByte();
        }
        writer.endNode();
    }

    private DOMSource readDOMSource() throws IOException {
        String xml = this.readObject().toString();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Element node = factory.newDocumentBuilder().parse(new InputSource(new StringReader(xml))).getDocumentElement();
            return new DOMSource(node);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException("Error parsing XML: " + xml, e);
        }
    }

    final QName defaultReadQName() throws IOException {
        String localName = this.readCodedString();
        String namespace = this.readCodedString();
        String revision = Strings.emptyToNull((String)this.readCodedString());
        return QNameFactory.create(localName, namespace, revision);
    }

    final String readCodedString() throws IOException {
        byte valueType = this.input.readByte();
        switch (valueType) {
            case 3: {
                return null;
            }
            case 1: {
                int code = this.input.readInt();
                try {
                    return this.codedStringMap.get(code);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new IOException("String code " + code + " was not found", e);
                }
            }
            case 2: {
                String value = this.input.readUTF().intern();
                this.codedStringMap.add(value);
                return value;
            }
        }
        throw new IOException("Unhandled string value type " + valueType);
    }

    private Set<QName> readQNameSet() throws IOException {
        int count = this.input.readInt();
        HashSet children = Sets.newHashSetWithExpectedSize((int)count);
        for (int i = 0; i < count; ++i) {
            children.add(this.readQName());
        }
        return children;
    }

    abstract YangInstanceIdentifier.AugmentationIdentifier readAugmentationIdentifier() throws IOException;

    abstract YangInstanceIdentifier.NodeIdentifier readNodeIdentifier() throws IOException;

    final YangInstanceIdentifier.AugmentationIdentifier defaultReadAugmentationIdentifier() throws IOException {
        return YangInstanceIdentifier.AugmentationIdentifier.create(this.readQNameSet());
    }

    private YangInstanceIdentifier.NodeIdentifierWithPredicates readNormalizedNodeWithPredicates() throws IOException {
        QName qname = this.readQName();
        int count = this.input.readInt();
        switch (count) {
            case 0: {
                return YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)qname);
            }
            case 1: {
                return YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)qname, (QName)this.readQName(), (Object)this.readObject());
            }
        }
        ImmutableList.Builder keys = ImmutableList.builderWithExpectedSize((int)count);
        Object[] values = new Object[count];
        for (int i = 0; i < count; ++i) {
            keys.add((Object)this.readQName());
            values[i] = this.readObject();
        }
        return YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)qname, (ImmutableOffsetMap)ImmutableOffsetMapTemplate.ordered((Collection)keys.build()).instantiateWithValues(values));
    }

    private Object readObject() throws IOException {
        byte objectType = this.input.readByte();
        switch (objectType) {
            case 7: {
                return this.readObjSet();
            }
            case 5: {
                return this.input.readBoolean();
            }
            case 2: {
                return this.input.readByte();
            }
            case 3: {
                return this.input.readInt();
            }
            case 4: {
                return this.input.readLong();
            }
            case 6: {
                return this.readQName();
            }
            case 1: {
                return this.input.readShort();
            }
            case 9: {
                return this.input.readUTF();
            }
            case 14: {
                return this.readStringBytes();
            }
            case 11: {
                return Decimal64.valueOf((String)this.input.readUTF());
            }
            case 10: {
                return new BigInteger(this.input.readUTF());
            }
            case 12: {
                byte[] bytes = new byte[this.input.readInt()];
                this.input.readFully(bytes);
                return bytes;
            }
            case 8: {
                return this.readYangInstanceIdentifierInternal();
            }
            case 13: 
            case 15: {
                return Empty.value();
            }
        }
        return null;
    }

    private String readStringBytes() throws IOException {
        byte[] bytes = new byte[this.input.readInt()];
        this.input.readFully(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public final YangInstanceIdentifier readYangInstanceIdentifier() throws IOException {
        return this.readYangInstanceIdentifierInternal();
    }

    private YangInstanceIdentifier readYangInstanceIdentifierInternal() throws IOException {
        int size = this.input.readInt();
        ImmutableList.Builder pathArguments = ImmutableList.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            pathArguments.add((Object)this.readPathArgument());
        }
        return YangInstanceIdentifier.create((Iterable)pathArguments.build());
    }

    private Set<String> readObjSet() throws IOException {
        int count = this.input.readInt();
        HashSet<String> children = new HashSet<String>(count);
        for (int i = 0; i < count; ++i) {
            children.add(this.readCodedString());
        }
        return children;
    }

    @Override
    public final YangInstanceIdentifier.PathArgument readPathArgument() throws IOException {
        byte type = this.input.readByte();
        switch (type) {
            case 1: {
                return this.readAugmentationIdentifier();
            }
            case 2: {
                return this.readNodeIdentifier();
            }
            case 4: {
                return this.readNormalizedNodeWithPredicates();
            }
            case 3: {
                return new YangInstanceIdentifier.NodeWithValue(this.readQName(), this.readObject());
            }
        }
        return null;
    }
}

