/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.binfmt;

import com.google.common.collect.ImmutableList;
import java.io.DataInput;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.codec.binfmt.ForwardingDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

abstract class AbstractNormalizedNodeDataInput
extends ForwardingDataInput
implements NormalizedNodeDataInput {
    final @NonNull DataInput input;

    AbstractNormalizedNodeDataInput(DataInput input) {
        this.input = Objects.requireNonNull(input);
    }

    @Override
    final DataInput delegate() {
        return this.input;
    }

    @Override
    @Deprecated
    public final SchemaPath readSchemaPath() throws IOException {
        boolean absolute = this.input.readBoolean();
        return SchemaPath.create(this.readQNames(), (boolean)absolute);
    }

    @Override
    public final SchemaNodeIdentifier readSchemaNodeIdentifier() throws IOException {
        boolean absolute = this.input.readBoolean();
        ImmutableList<QName> qnames = this.readQNames();
        return absolute ? SchemaNodeIdentifier.Absolute.of(qnames) : SchemaNodeIdentifier.Descendant.of(qnames);
    }

    private ImmutableList<QName> readQNames() throws IOException {
        int size = this.input.readInt();
        ImmutableList.Builder qnames = ImmutableList.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            qnames.add((Object)this.readQName());
        }
        return qnames.build();
    }
}

