/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.binfmt;

import com.google.common.collect.Iterables;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataOutput;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

abstract class AbstractNormalizedNodeDataOutput
implements NormalizedNodeDataOutput,
NormalizedNodeStreamWriter {
    final DataOutput output;
    private NormalizedNodeWriter normalizedNodeWriter;
    private boolean headerWritten;

    AbstractNormalizedNodeDataOutput(DataOutput output) {
        this.output = Objects.requireNonNull(output);
    }

    private void ensureHeaderWritten() throws IOException {
        if (!this.headerWritten) {
            this.output.writeByte(-85);
            this.output.writeShort(this.streamVersion());
            this.headerWritten = true;
        }
    }

    public final void write(int value) throws IOException {
        this.ensureHeaderWritten();
        this.output.write(value);
    }

    public final void write(byte[] bytes) throws IOException {
        this.ensureHeaderWritten();
        this.output.write(bytes);
    }

    public final void write(byte[] bytes, int off, int len) throws IOException {
        this.ensureHeaderWritten();
        this.output.write(bytes, off, len);
    }

    public final void writeBoolean(boolean value) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeBoolean(value);
    }

    public final void writeByte(int value) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeByte(value);
    }

    public final void writeShort(int value) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeShort(value);
    }

    public final void writeChar(int value) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeChar(value);
    }

    public final void writeInt(int value) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeInt(value);
    }

    public final void writeLong(long value) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeLong(value);
    }

    public final void writeFloat(float value) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeFloat(value);
    }

    public final void writeDouble(double value) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeDouble(value);
    }

    public final void writeBytes(String str) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeBytes(str);
    }

    public final void writeChars(String str) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeChars(str);
    }

    public final void writeUTF(String str) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeUTF(str);
    }

    public final void writeQName(QName qname) throws IOException {
        this.ensureHeaderWritten();
        this.writeQNameInternal(qname);
    }

    @Override
    public final void writeNormalizedNode(NormalizedNode node) throws IOException {
        this.ensureHeaderWritten();
        if (this.normalizedNodeWriter == null) {
            this.normalizedNodeWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)this);
        }
        this.normalizedNodeWriter.write(node);
    }

    @Override
    public final void writePathArgument(YangInstanceIdentifier.PathArgument pathArgument) throws IOException {
        this.ensureHeaderWritten();
        this.writePathArgumentInternal(pathArgument);
    }

    @Override
    public final void writeYangInstanceIdentifier(YangInstanceIdentifier identifier) throws IOException {
        this.ensureHeaderWritten();
        this.writeYangInstanceIdentifierInternal(identifier);
    }

    @Override
    @Deprecated
    public final void writeSchemaPath(SchemaPath path) throws IOException {
        this.writeSchemaNodeIdentifier(path.isAbsolute(), path.getPathFromRoot());
    }

    @Override
    public final void writeSchemaNodeIdentifier(SchemaNodeIdentifier path) throws IOException {
        this.writeSchemaNodeIdentifier(path instanceof SchemaNodeIdentifier.Absolute, path.getNodeIdentifiers());
    }

    private void writeSchemaNodeIdentifier(boolean absolute, Iterable<QName> qnames) throws IOException {
        this.ensureHeaderWritten();
        this.output.writeBoolean(absolute);
        this.output.writeInt(Iterables.size(qnames));
        for (QName qname : qnames) {
            this.writeQNameInternal(qname);
        }
    }

    @Override
    public final void close() throws IOException {
        this.flush();
    }

    public void flush() throws IOException {
        if (this.output instanceof OutputStream) {
            ((OutputStream)((Object)this.output)).flush();
        }
    }

    public final boolean startAnydataNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) throws IOException {
        return false;
    }

    abstract short streamVersion();

    abstract void writeQNameInternal(@NonNull QName var1) throws IOException;

    abstract void writePathArgumentInternal(YangInstanceIdentifier.PathArgument var1) throws IOException;

    abstract void writeYangInstanceIdentifierInternal(YangInstanceIdentifier var1) throws IOException;
}

