/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.binfmt;

import com.google.common.base.Verify;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.binfmt.AbstractLithiumDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeStreamVersion;
import org.opendaylight.yangtools.yang.data.codec.binfmt.QNameFactory;

final class NeonSR2NormalizedNodeInputStreamReader
extends AbstractLithiumDataInput {
    private final ArrayList<YangInstanceIdentifier.NodeIdentifier> codedNodeIdentifiers = new ArrayList();
    private final List<YangInstanceIdentifier.AugmentationIdentifier> codedAugments = new ArrayList<YangInstanceIdentifier.AugmentationIdentifier>();
    private final List<QNameModule> codedModules = new ArrayList<QNameModule>();
    private final List<QName> codedQNames = new ArrayList<QName>();

    NeonSR2NormalizedNodeInputStreamReader(DataInput input) {
        super(input);
    }

    @Override
    public NormalizedNodeStreamVersion getVersion() {
        return NormalizedNodeStreamVersion.NEON_SR2;
    }

    public QName readQName() throws IOException {
        byte valueType = this.readByte();
        switch (valueType) {
            case 4: {
                return this.codedQName(this.readInt());
            }
            case 5: {
                return this.rawQName();
            }
        }
        throw new IOException("Unhandled QName value type " + valueType);
    }

    @Override
    YangInstanceIdentifier.AugmentationIdentifier readAugmentationIdentifier() throws IOException {
        byte valueType = this.readByte();
        switch (valueType) {
            case 6: {
                return this.codedAugmentId(this.readInt());
            }
            case 7: {
                return this.rawAugmentId();
            }
        }
        throw new IOException("Unhandled AugmentationIdentifier value type " + valueType);
    }

    @Override
    YangInstanceIdentifier.NodeIdentifier readNodeIdentifier() throws IOException {
        byte valueType = this.readByte();
        switch (valueType) {
            case 4: {
                return this.codedNodeIdentifier(this.readInt());
            }
            case 5: {
                return this.rawNodeIdentifier();
            }
        }
        throw new IOException("Unhandled NodeIdentifier value type " + valueType);
    }

    private QNameModule readModule() throws IOException {
        byte valueType = this.readByte();
        switch (valueType) {
            case 8: {
                return this.codedModule(this.readInt());
            }
            case 9: {
                return this.rawModule();
            }
        }
        throw new IOException("Unhandled QNameModule value type " + valueType);
    }

    private YangInstanceIdentifier.NodeIdentifier codedNodeIdentifier(int code) throws IOException {
        YangInstanceIdentifier.NodeIdentifier existing = this.codedNodeIdentifiers.size() > code ? this.codedNodeIdentifiers.get(code) : null;
        return existing != null ? existing : this.storeNodeIdentifier(code, this.codedQName(code));
    }

    private YangInstanceIdentifier.NodeIdentifier rawNodeIdentifier() throws IOException {
        int code = this.codedQNames.size();
        return this.storeNodeIdentifier(code, this.rawQName());
    }

    private YangInstanceIdentifier.NodeIdentifier storeNodeIdentifier(int code, QName qname) {
        YangInstanceIdentifier.NodeIdentifier ret = YangInstanceIdentifier.NodeIdentifier.create((QName)qname);
        int size = this.codedNodeIdentifiers.size();
        if (code >= size) {
            this.codedNodeIdentifiers.ensureCapacity(code + 1);
            for (int i = size; i < code; ++i) {
                this.codedNodeIdentifiers.add(null);
            }
            this.codedNodeIdentifiers.add(ret);
        } else {
            YangInstanceIdentifier.NodeIdentifier check = this.codedNodeIdentifiers.set(code, ret);
            Verify.verify((check == null ? 1 : 0) != 0);
        }
        return ret;
    }

    private QName codedQName(int code) throws IOException {
        return NeonSR2NormalizedNodeInputStreamReader.getCode("QName", this.codedQNames, code);
    }

    private QName rawQName() throws IOException {
        String localName = this.readCodedString();
        QNameModule module = this.readModule();
        QName qname = QNameFactory.create(module, localName);
        this.codedQNames.add(qname);
        return qname;
    }

    private YangInstanceIdentifier.AugmentationIdentifier codedAugmentId(int code) throws IOException {
        return NeonSR2NormalizedNodeInputStreamReader.getCode("QName set", this.codedAugments, code);
    }

    private YangInstanceIdentifier.AugmentationIdentifier rawAugmentId() throws IOException {
        YangInstanceIdentifier.AugmentationIdentifier aid = this.defaultReadAugmentationIdentifier();
        this.codedAugments.add(aid);
        return aid;
    }

    private QNameModule codedModule(int code) throws IOException {
        return NeonSR2NormalizedNodeInputStreamReader.getCode("Module", this.codedModules, code);
    }

    private QNameModule rawModule() throws IOException {
        String namespace = this.readCodedString();
        String revision = this.readCodedString();
        QNameModule mod = QNameFactory.createModule(namespace, revision);
        this.codedModules.add(mod);
        return mod;
    }

    private static <T> T getCode(String name, List<T> list, int code) throws IOException {
        try {
            return list.get(code);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException(name + " code " + code + " was not found", e);
        }
    }
}

