/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.binfmt;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

final class QNameFactory {
    private static final int MAX_QNAME_CACHE_SIZE = Integer.getInteger("org.opendaylight.controller.cluster.datastore.node.utils.qname-cache.max-size", 10000);
    private static final int MAX_MODULE_CACHE_SIZE = Integer.getInteger("org.opendaylight.controller.cluster.datastore.node.utils.module-cache.max-size", 2000);
    private static final LoadingCache<StringQName, QName> STRING_CACHE = CacheBuilder.newBuilder().maximumSize((long)MAX_QNAME_CACHE_SIZE).weakValues().build((CacheLoader)new CacheLoader<StringQName, QName>(){

        public QName load(StringQName key) {
            return key.toQName().intern();
        }
    });
    private static final LoadingCache<ModuleQName, QName> QNAME_CACHE = CacheBuilder.newBuilder().maximumSize((long)MAX_QNAME_CACHE_SIZE).weakValues().build((CacheLoader)new CacheLoader<ModuleQName, QName>(){

        public QName load(ModuleQName key) {
            return key.toQName().intern();
        }
    });
    private static final LoadingCache<StringModule, QNameModule> MODULE_CACHE = CacheBuilder.newBuilder().maximumSize((long)MAX_MODULE_CACHE_SIZE).weakValues().build((CacheLoader)new CacheLoader<StringModule, QNameModule>(){

        public QNameModule load(StringModule key) {
            return key.toQNameModule().intern();
        }
    });
    private static final LoadingCache<ModuleQName, YangInstanceIdentifier.NodeIdentifier> NODEID_CACHE = CacheBuilder.newBuilder().maximumSize((long)MAX_QNAME_CACHE_SIZE).weakValues().build((CacheLoader)new CacheLoader<ModuleQName, YangInstanceIdentifier.NodeIdentifier>(){

        public YangInstanceIdentifier.NodeIdentifier load(ModuleQName key) throws ExecutionException {
            return YangInstanceIdentifier.NodeIdentifier.create((QName)((QName)QNAME_CACHE.get((Object)key)));
        }
    });

    private QNameFactory() {
    }

    static QName create(String localName, String namespace, @Nullable String revision) {
        return (QName)STRING_CACHE.getUnchecked((Object)new StringQName(localName, namespace, revision));
    }

    static QName create(QNameModule module, String localName) {
        return (QName)QNAME_CACHE.getUnchecked((Object)new ModuleQName(module, localName));
    }

    static QNameModule createModule(String namespace, @Nullable String revision) {
        return (QNameModule)MODULE_CACHE.getUnchecked((Object)new StringModule(namespace, revision));
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier getNodeIdentifier(QNameModule module, String localName) throws ExecutionException {
        return (YangInstanceIdentifier.NodeIdentifier)NODEID_CACHE.get((Object)new ModuleQName(module, localName));
    }

    private static final class StringModule
    implements Immutable {
        private final @NonNull String namespace;
        private final @Nullable String revision;

        StringModule(String namespace, String revision) {
            this.namespace = Objects.requireNonNull(namespace);
            this.revision = revision;
        }

        public int hashCode() {
            return 31 * this.namespace.hashCode() + Objects.hashCode(this.revision);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof StringModule)) {
                return false;
            }
            StringModule other = (StringModule)obj;
            return this.namespace.equals(other.namespace) && Objects.equals(this.revision, other.revision);
        }

        QNameModule toQNameModule() {
            return QNameModule.create((XMLNamespace)XMLNamespace.of((String)this.namespace), (Optional)Revision.ofNullable((String)this.revision));
        }
    }

    private static final class ModuleQName
    implements Immutable {
        private final @NonNull QNameModule module;
        private final @NonNull String localName;

        ModuleQName(QNameModule module, String localName) {
            this.module = Objects.requireNonNull(module);
            this.localName = Objects.requireNonNull(localName);
        }

        public int hashCode() {
            return 31 * this.module.hashCode() + this.localName.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ModuleQName)) {
                return false;
            }
            ModuleQName other = (ModuleQName)obj;
            return this.localName.equals(other.localName) && this.module.equals((Object)other.module);
        }

        QName toQName() {
            return QName.create((QNameModule)this.module, (String)this.localName);
        }
    }

    private static final class StringQName
    implements Immutable {
        private final @NonNull String localName;
        private final @NonNull String namespace;
        private final @Nullable String revision;

        StringQName(String localName, String namespace, String revision) {
            this.localName = Objects.requireNonNull(localName);
            this.namespace = Objects.requireNonNull(namespace);
            this.revision = revision;
        }

        public int hashCode() {
            return Objects.hash(this.localName, this.namespace, this.revision);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof StringQName)) {
                return false;
            }
            StringQName other = (StringQName)obj;
            return this.localName.equals(other.localName) && this.namespace.equals(other.namespace) && Objects.equals(this.revision, other.revision);
        }

        QName toQName() {
            return this.revision != null ? QName.create((String)this.namespace, (String)this.revision, (String)this.localName) : QName.create((String)this.namespace, (String)this.localName);
        }
    }
}

