/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc7952.data.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.AbstractSimpleIdentifiable;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.rfc7952.data.api.NormalizedMetadata;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

@Beta
public class ImmutableNormalizedMetadata
extends AbstractSimpleIdentifiable<YangInstanceIdentifier.PathArgument>
implements NormalizedMetadata {
    private final @NonNull ImmutableMap<QName, Object> annotations;

    ImmutableNormalizedMetadata(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.PathArgument identifier, Map<QName, Object> annotations) {
        super((Object)identifier);
        this.annotations = ImmutableMap.copyOf(annotations);
    }

    public static final @NonNull Builder builder() {
        return new Builder();
    }

    public final ImmutableMap<QName, Object> getAnnotations() {
        return this.annotations;
    }

    public static final class Builder
    implements Mutable {
        private final Map<YangInstanceIdentifier.PathArgument, ImmutableNormalizedMetadata> children = new HashMap<YangInstanceIdentifier.PathArgument, ImmutableNormalizedMetadata>();
        private final Map<QName, Object> annotations = new HashMap<QName, Object>();
        private YangInstanceIdentifier.PathArgument identifier;

        Builder() {
        }

        public @NonNull Builder withIdentifier(YangInstanceIdentifier.PathArgument identifier) {
            this.identifier = Objects.requireNonNull(identifier);
            return this;
        }

        public @NonNull Builder withAnnotation(QName type, Object value) {
            this.annotations.put(Objects.requireNonNull(type, "type"), Objects.requireNonNull(value, "value"));
            return this;
        }

        public @NonNull Builder withAnnotations(Map<QName, Object> annotations) {
            annotations.forEach(this::withAnnotation);
            return this;
        }

        public @NonNull Builder withChild(ImmutableNormalizedMetadata child) {
            this.children.put((YangInstanceIdentifier.PathArgument)child.getIdentifier(), child);
            return this;
        }

        public @NonNull Builder withChildren(Collection<ImmutableNormalizedMetadata> children) {
            children.forEach(this::withChild);
            return this;
        }

        public @NonNull ImmutableNormalizedMetadata build() {
            YangInstanceIdentifier.PathArgument id = this.identifier;
            Preconditions.checkState((id != null ? 1 : 0) != 0, (Object)"Identifier has not been set");
            return this.children.isEmpty() ? new ImmutableNormalizedMetadata(id, this.annotations) : new Container(id, this.annotations, this.children);
        }
    }

    private static final class Container
    extends ImmutableNormalizedMetadata {
        private final @NonNull ImmutableMap<// Could not load outer class - annotation placement on inner may be incorrect
        YangInstanceIdentifier.PathArgument, NormalizedMetadata> children;

        Container(YangInstanceIdentifier.PathArgument identifier, Map<QName, Object> annotations, Map<YangInstanceIdentifier.PathArgument, ImmutableNormalizedMetadata> children) {
            super(identifier, annotations);
            this.children = ImmutableMap.copyOf(children);
        }

        public ImmutableMap<YangInstanceIdentifier.PathArgument, NormalizedMetadata> getChildren() {
            return this.children;
        }
    }
}

