/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionFactory;

public abstract class AbstractDOMBrokerTransaction<T extends DOMStoreTransaction>
implements DOMDataTreeTransaction {
    private final EnumMap<LogicalDatastoreType, T> backingTxs;
    private final Object identifier;
    private final Map<LogicalDatastoreType, ? extends DOMStoreTransactionFactory> storeTxFactories;

    protected AbstractDOMBrokerTransaction(Object identifier, Map<LogicalDatastoreType, ? extends DOMStoreTransactionFactory> storeTxFactories) {
        this.identifier = Objects.requireNonNull(identifier, "Identifier should not be null");
        this.storeTxFactories = Objects.requireNonNull(storeTxFactories, "Store Transaction Factories should not be null");
        this.backingTxs = new EnumMap(LogicalDatastoreType.class);
    }

    protected final T getSubtransaction(LogicalDatastoreType key) {
        Objects.requireNonNull(key, "key must not be null.");
        Object ret = (DOMStoreTransaction)this.backingTxs.get(key);
        if (ret == null) {
            ret = this.createTransaction(key);
            this.backingTxs.put(key, (T)ret);
        }
        Preconditions.checkArgument((ret != null ? 1 : 0) != 0, (String)"No subtransaction associated with %s", (Object)key);
        return (T)ret;
    }

    protected abstract T createTransaction(LogicalDatastoreType var1);

    protected Collection<T> getSubtransactions() {
        return this.backingTxs.values();
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    protected void closeSubtransactions() {
        Throwable failure = null;
        for (DOMStoreTransaction subtransaction : this.backingTxs.values()) {
            try {
                subtransaction.close();
            }
            catch (Exception e) {
                if (failure == null) {
                    failure = new IllegalStateException("Uncaught exception occured during closing transaction", e);
                    continue;
                }
                failure.addSuppressed(e);
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    protected DOMStoreTransactionFactory getTxFactory(LogicalDatastoreType type) {
        return this.storeTxFactories.get(type);
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("identifier", this.identifier);
    }
}

