/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.actor.ActorRef;
import akka.util.Timeout;
import com.google.common.base.Verify;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.client.AbstractClientActor;
import org.opendaylight.controller.cluster.access.client.ClientActorConfig;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.common.actor.ExplicitAsk;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractDataStoreClientBehavior;
import org.opendaylight.controller.cluster.databroker.actors.dds.DataStoreClient;
import org.opendaylight.controller.cluster.databroker.actors.dds.GetClientRequest;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import scala.Function1;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;

public abstract class AbstractDataStoreClientActor
extends AbstractClientActor {
    private static final Function1<ActorRef, ?> GET_CLIENT_FACTORY = ExplicitAsk.toScala(GetClientRequest::new);
    private final ActorUtils actorUtils;

    AbstractDataStoreClientActor(FrontendIdentifier frontendId, ActorUtils actorUtils) {
        super(frontendId);
        this.actorUtils = Objects.requireNonNull(actorUtils);
    }

    protected ClientActorConfig getClientActorConfig() {
        return this.actorUtils.getDatastoreContext();
    }

    protected final AbstractDataStoreClientBehavior initialBehavior(ClientActorContext context) {
        return (AbstractDataStoreClientBehavior)Verify.verifyNotNull((Object)this.initialBehavior(context, this.actorUtils));
    }

    abstract AbstractDataStoreClientBehavior initialBehavior(ClientActorContext var1, ActorUtils var2);

    public static DataStoreClient getDistributedDataStoreClient(@NonNull ActorRef actor, long timeout, TimeUnit unit) {
        try {
            return (DataStoreClient)Await.result((Awaitable)ExplicitAsk.ask((ActorRef)actor, GET_CLIENT_FACTORY, (Timeout)Timeout.apply((long)timeout, (TimeUnit)unit)), (Duration)Duration.Inf());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

