/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.FluentFuture;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.commands.AbortLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.AbstractLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.CommitLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ExistsTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequestBuilder;
import org.opendaylight.controller.cluster.access.commands.PersistenceProtocol;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionAbortRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionDelete;
import org.opendaylight.controller.cluster.access.commands.TransactionDoCommitRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionMerge;
import org.opendaylight.controller.cluster.access.commands.TransactionModification;
import org.opendaylight.controller.cluster.access.commands.TransactionPreCommitRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionWrite;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.controller.cluster.access.concepts.RuntimeRequestException;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.FailedDataTreeModification;
import org.opendaylight.controller.cluster.databroker.actors.dds.LocalProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ProxyHistory;
import org.opendaylight.controller.cluster.datastore.util.AbstractDataTreeModificationCursor;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.CursorAwareDataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.CursorAwareDataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LocalReadWriteProxyTransaction
extends LocalProxyTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(LocalReadWriteProxyTransaction.class);
    private final CursorAwareDataTreeModification modification;
    private Supplier<? extends RuntimeException> closedException;
    private CursorAwareDataTreeModification sealedModification;
    private Exception recordedFailure;

    LocalReadWriteProxyTransaction(ProxyHistory parent, TransactionIdentifier identifier, DataTreeSnapshot snapshot) {
        super(parent, identifier, false);
        if (snapshot instanceof FailedDataTreeModification) {
            FailedDataTreeModification failed = (FailedDataTreeModification)snapshot;
            this.recordedFailure = failed.cause();
            this.modification = failed;
        } else {
            CursorAwareDataTreeModification mod;
            try {
                mod = (CursorAwareDataTreeModification)snapshot.newModification();
            }
            catch (Exception e) {
                LOG.debug("Failed to instantiate modification for {}", (Object)identifier, (Object)e);
                this.recordedFailure = e;
                mod = new FailedDataTreeModification(snapshot.getEffectiveModelContext(), e);
            }
            this.modification = mod;
        }
    }

    LocalReadWriteProxyTransaction(ProxyHistory parent, TransactionIdentifier identifier) {
        super(parent, identifier, true);
        this.modification = null;
    }

    @Override
    boolean isSnapshotOnly() {
        return false;
    }

    CursorAwareDataTreeSnapshot readOnlyView() {
        return this.getModification();
    }

    @Override
    FluentFuture<Boolean> doExists(YangInstanceIdentifier path) {
        Exception ex = this.recordedFailure;
        return ex == null ? super.doExists(path) : FluentFutures.immediateFailedFluentFuture((Throwable)ReadFailedException.MAPPER.apply(ex));
    }

    @Override
    FluentFuture<Optional<NormalizedNode>> doRead(YangInstanceIdentifier path) {
        Exception ex = this.recordedFailure;
        return ex == null ? super.doRead(path) : FluentFutures.immediateFailedFluentFuture((Throwable)ReadFailedException.MAPPER.apply(ex));
    }

    @Override
    void doDelete(YangInstanceIdentifier path) {
        CursorAwareDataTreeModification mod = this.getModification();
        if (this.recordedFailure != null) {
            LOG.debug("Transaction {} recorded failure, ignoring delete of {}", (Object)this.getIdentifier(), (Object)path);
            return;
        }
        try {
            mod.delete(path);
        }
        catch (Exception e) {
            LOG.debug("Transaction {} delete on {} incurred failure, delaying it until commit", new Object[]{this.getIdentifier(), path, e});
            this.recordedFailure = e;
        }
    }

    @Override
    void doMerge(YangInstanceIdentifier path, NormalizedNode data) {
        CursorAwareDataTreeModification mod = this.getModification();
        if (this.recordedFailure != null) {
            LOG.debug("Transaction {} recorded failure, ignoring merge to {}", (Object)this.getIdentifier(), (Object)path);
            return;
        }
        try {
            mod.merge(path, data);
        }
        catch (Exception e) {
            LOG.debug("Transaction {} merge to {} incurred failure, delaying it until commit", new Object[]{this.getIdentifier(), path, e});
            this.recordedFailure = e;
        }
    }

    @Override
    void doWrite(YangInstanceIdentifier path, NormalizedNode data) {
        CursorAwareDataTreeModification mod = this.getModification();
        if (this.recordedFailure != null) {
            LOG.debug("Transaction {} recorded failure, ignoring write to {}", (Object)this.getIdentifier(), (Object)path);
            return;
        }
        try {
            mod.write(path, data);
        }
        catch (Exception e) {
            LOG.debug("Transaction {} write to {} incurred failure, delaying it until commit", new Object[]{this.getIdentifier(), path, e});
            this.recordedFailure = e;
        }
    }

    private RuntimeException abortedException() {
        return new IllegalStateException("Tracker " + this.getIdentifier() + " has been aborted");
    }

    private RuntimeException submittedException() {
        return new IllegalStateException("Tracker " + this.getIdentifier() + " has been submitted");
    }

    CommitLocalTransactionRequest commitRequest(boolean coordinated) {
        CursorAwareDataTreeModification mod = this.getModification();
        CommitLocalTransactionRequest ret = new CommitLocalTransactionRequest(this.getIdentifier(), this.nextSequence(), this.localActor(), (DataTreeModification)mod, this.recordedFailure, coordinated);
        this.closedException = this::submittedException;
        return ret;
    }

    private void sealModification() {
        Preconditions.checkState((this.sealedModification == null ? 1 : 0) != 0, (String)"Transaction %s is already sealed", (Object)this);
        CursorAwareDataTreeModification mod = this.getModification();
        mod.ready();
        this.sealedModification = mod;
    }

    @Override
    boolean sealOnly() {
        this.sealModification();
        return super.sealOnly();
    }

    @Override
    boolean sealAndSend(OptionalLong enqueuedTicks) {
        this.sealModification();
        return super.sealAndSend(enqueuedTicks);
    }

    @Override
    Optional<ModifyTransactionRequest> flushState() {
        final ModifyTransactionRequestBuilder b = new ModifyTransactionRequestBuilder(this.getIdentifier(), this.localActor());
        b.setSequence(0L);
        this.sealedModification.applyToCursor((DataTreeModificationCursor)new AbstractDataTreeModificationCursor(){

            public void write(YangInstanceIdentifier.PathArgument child, NormalizedNode data) {
                b.addModification((TransactionModification)new TransactionWrite(this.current().node(child), data));
            }

            public void merge(YangInstanceIdentifier.PathArgument child, NormalizedNode data) {
                b.addModification((TransactionModification)new TransactionMerge(this.current().node(child), data));
            }

            public void delete(YangInstanceIdentifier.PathArgument child) {
                b.addModification((TransactionModification)new TransactionDelete(this.current().node(child)));
            }
        });
        return Optional.of(b.build());
    }

    CursorAwareDataTreeSnapshot getSnapshot() {
        Preconditions.checkState((this.sealedModification != null ? 1 : 0) != 0, (String)"Proxy %s is not sealed yet", (Object)this.getIdentifier());
        return this.sealedModification;
    }

    @Override
    void applyForwardedModifyTransactionRequest(ModifyTransactionRequest request, Consumer<Response<?, ?>> callback) {
        this.commonModifyTransactionRequest(request, callback, this::sendRequest);
    }

    @Override
    void replayModifyTransactionRequest(ModifyTransactionRequest request, Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        this.commonModifyTransactionRequest(request, callback, (req, cb) -> this.enqueueRequest((TransactionRequest<?>)req, (Consumer<Response<?, ?>>)cb, enqueuedTicks));
    }

    private void commonModifyTransactionRequest(ModifyTransactionRequest request, @Nullable Consumer<Response<?, ?>> callback, BiConsumer<TransactionRequest<?>, Consumer<Response<?, ?>>> sendMethod) {
        for (TransactionModification mod : request.getModifications()) {
            if (mod instanceof TransactionWrite) {
                this.write(mod.getPath(), ((TransactionWrite)mod).getData());
                continue;
            }
            if (mod instanceof TransactionMerge) {
                this.merge(mod.getPath(), ((TransactionMerge)mod).getData());
                continue;
            }
            if (mod instanceof TransactionDelete) {
                this.delete(mod.getPath());
                continue;
            }
            throw new IllegalArgumentException("Unsupported modification " + mod);
        }
        Optional maybeProtocol = request.getPersistenceProtocol();
        if (maybeProtocol.isPresent()) {
            Consumer cb = (Consumer)Verify.verifyNotNull(callback, (String)"Request %s has null callback", (Object[])new Object[]{request});
            if (this.markSealed()) {
                this.sealOnly();
            }
            switch ((PersistenceProtocol)maybeProtocol.get()) {
                case ABORT: {
                    sendMethod.accept((TransactionRequest<?>)new AbortLocalTransactionRequest(this.getIdentifier(), this.localActor()), cb);
                    break;
                }
                case READY: {
                    break;
                }
                case SIMPLE: {
                    sendMethod.accept((TransactionRequest<?>)this.commitRequest(false), cb);
                    break;
                }
                case THREE_PHASE: {
                    sendMethod.accept((TransactionRequest<?>)this.commitRequest(true), cb);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled protocol " + maybeProtocol.get());
                }
            }
        }
    }

    @Override
    void handleReplayedLocalRequest(AbstractLocalTransactionRequest<?> request, Consumer<Response<?, ?>> callback, long now) {
        if (request instanceof CommitLocalTransactionRequest) {
            this.enqueueRequest((TransactionRequest<?>)this.rebaseCommit((CommitLocalTransactionRequest)request), callback, now);
        } else {
            super.handleReplayedLocalRequest(request, callback, now);
        }
    }

    @Override
    void handleReplayedRemoteRequest(TransactionRequest<?> request, Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        LOG.debug("Applying replayed request {}", request);
        if (request instanceof TransactionPreCommitRequest) {
            this.enqueueRequest((TransactionRequest<?>)new TransactionPreCommitRequest(this.getIdentifier(), this.nextSequence(), this.localActor()), callback, enqueuedTicks);
        } else if (request instanceof TransactionDoCommitRequest) {
            this.enqueueRequest((TransactionRequest<?>)new TransactionDoCommitRequest(this.getIdentifier(), this.nextSequence(), this.localActor()), callback, enqueuedTicks);
        } else if (request instanceof TransactionAbortRequest) {
            this.enqueueDoAbort(callback, enqueuedTicks);
        } else {
            super.handleReplayedRemoteRequest(request, callback, enqueuedTicks);
        }
    }

    @Override
    void handleForwardedRemoteRequest(TransactionRequest<?> request, Consumer<Response<?, ?>> callback) {
        LOG.debug("Applying forwarded request {}", request);
        if (request instanceof TransactionPreCommitRequest) {
            this.sendRequest((TransactionRequest<?>)new TransactionPreCommitRequest(this.getIdentifier(), this.nextSequence(), this.localActor()), callback);
        } else if (request instanceof TransactionDoCommitRequest) {
            this.sendRequest((TransactionRequest<?>)new TransactionDoCommitRequest(this.getIdentifier(), this.nextSequence(), this.localActor()), callback);
        } else if (request instanceof TransactionAbortRequest) {
            this.sendDoAbort(callback);
        } else {
            super.handleForwardedRemoteRequest(request, callback);
        }
    }

    @Override
    Response<?, ?> handleExistsRequest(DataTreeSnapshot snapshot, ExistsTransactionRequest request) {
        Exception ex = this.recordedFailure;
        return ex == null ? super.handleExistsRequest(snapshot, request) : request.toRequestFailure((RequestException)new RuntimeRequestException("Previous modification failed", (Throwable)ReadFailedException.MAPPER.apply(ex)));
    }

    @Override
    Response<?, ?> handleReadRequest(DataTreeSnapshot snapshot, ReadTransactionRequest request) {
        Exception ex = this.recordedFailure;
        return ex == null ? super.handleReadRequest(snapshot, request) : request.toRequestFailure((RequestException)new RuntimeRequestException("Previous modification failed", (Throwable)ReadFailedException.MAPPER.apply(ex)));
    }

    @Override
    void forwardToLocal(LocalProxyTransaction successor, TransactionRequest<?> request, Consumer<Response<?, ?>> callback) {
        if (request instanceof CommitLocalTransactionRequest) {
            LocalReadWriteProxyTransaction.verifyLocalReadWrite(successor).sendRebased((CommitLocalTransactionRequest)request, callback);
        } else if (request instanceof ModifyTransactionRequest) {
            LocalReadWriteProxyTransaction.verifyLocalReadWrite(successor).handleForwardedRemoteRequest(request, callback);
        } else {
            super.forwardToLocal(successor, request, callback);
            return;
        }
        LOG.debug("Forwarded request {} to successor {}", request, (Object)successor);
    }

    private static LocalReadWriteProxyTransaction verifyLocalReadWrite(LocalProxyTransaction successor) {
        Verify.verify((boolean)(successor instanceof LocalReadWriteProxyTransaction), (String)"Unexpected successor %s", (Object)successor);
        return (LocalReadWriteProxyTransaction)successor;
    }

    @Override
    void sendAbort(TransactionRequest<?> request, Consumer<Response<?, ?>> callback) {
        super.sendAbort(request, callback);
        this.closedException = this::abortedException;
    }

    @Override
    void enqueueAbort(TransactionRequest<?> request, Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        super.enqueueAbort(request, callback, enqueuedTicks);
        this.closedException = this::abortedException;
    }

    private @NonNull CursorAwareDataTreeModification getModification() {
        if (this.closedException != null) {
            throw this.closedException.get();
        }
        return (CursorAwareDataTreeModification)Verify.verifyNotNull((Object)this.modification, (String)"Transaction %s is DONE", (Object[])new Object[]{this.getIdentifier()});
    }

    private void sendRebased(CommitLocalTransactionRequest request, Consumer<Response<?, ?>> callback) {
        this.sendRequest((TransactionRequest<?>)this.rebaseCommit(request), callback);
    }

    private CommitLocalTransactionRequest rebaseCommit(CommitLocalTransactionRequest request) {
        CursorAwareDataTreeModification mod = this.getModification();
        if (!(mod instanceof FailedDataTreeModification)) {
            request.getDelayedFailure().ifPresentOrElse(failure -> {
                if (this.recordedFailure == null) {
                    this.recordedFailure = failure;
                } else {
                    this.recordedFailure.addSuppressed((Throwable)failure);
                }
            }, () -> {
                try (DataTreeModificationCursor cursor = mod.openCursor();){
                    request.getModification().applyToCursor(cursor);
                }
            });
        }
        if (this.markSealed()) {
            this.sealOnly();
        }
        return this.commitRequest(request.isCoordinated());
    }
}

