/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractFrontendHistory;
import org.opendaylight.controller.cluster.datastore.FrontendHistoryMetadataBuilder;
import org.opendaylight.controller.cluster.datastore.LeaderFrontendState;
import org.opendaylight.controller.cluster.datastore.LocalFrontendHistory;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.StandaloneFrontendHistory;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendClientMetadata;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendHistoryMetadata;
import org.opendaylight.controller.cluster.datastore.utils.ImmutableUnsignedLongSet;
import org.opendaylight.controller.cluster.datastore.utils.MutableUnsignedLongSet;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class FrontendClientMetadataBuilder
implements Builder<FrontendClientMetadata>,
Identifiable<ClientIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(FrontendClientMetadataBuilder.class);
    private final @NonNull ClientIdentifier identifier;
    private final @NonNull String shardName;

    FrontendClientMetadataBuilder(String shardName, ClientIdentifier identifier) {
        this.shardName = Objects.requireNonNull(shardName);
        this.identifier = Objects.requireNonNull(identifier);
    }

    static FrontendClientMetadataBuilder of(String shardName, FrontendClientMetadata meta) {
        return meta.getCurrentHistories().isEmpty() && meta.getPurgedHistories().isEmpty() ? new Disabled(shardName, meta.getIdentifier()) : new Enabled(shardName, meta);
    }

    public final ClientIdentifier getIdentifier() {
        return this.identifier;
    }

    final String shardName() {
        return this.shardName;
    }

    abstract void onHistoryCreated(LocalHistoryIdentifier var1);

    abstract void onHistoryClosed(LocalHistoryIdentifier var1);

    abstract void onHistoryPurged(LocalHistoryIdentifier var1);

    abstract void onTransactionAborted(TransactionIdentifier var1);

    abstract void onTransactionCommitted(TransactionIdentifier var1);

    abstract void onTransactionPurged(TransactionIdentifier var1);

    abstract void onTransactionsSkipped(LocalHistoryIdentifier var1, ImmutableUnsignedLongSet var2);

    abstract @NonNull LeaderFrontendState toLeaderState(@NonNull Shard var1);

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("identifier", (Object)this.identifier);
    }

    static final class Enabled
    extends FrontendClientMetadataBuilder {
        private final Map<LocalHistoryIdentifier, FrontendHistoryMetadataBuilder> currentHistories = new HashMap<LocalHistoryIdentifier, FrontendHistoryMetadataBuilder>();
        private final MutableUnsignedLongSet purgedHistories;
        private final LocalHistoryIdentifier standaloneId;

        Enabled(String shardName, ClientIdentifier identifier) {
            super(shardName, identifier);
            this.purgedHistories = MutableUnsignedLongSet.of();
            this.standaloneId = this.standaloneHistoryId();
            this.currentHistories.put(this.standaloneId, new FrontendHistoryMetadataBuilder(this.standaloneId));
        }

        Enabled(String shardName, FrontendClientMetadata meta) {
            super(shardName, meta.getIdentifier());
            this.purgedHistories = meta.getPurgedHistories().mutableCopy();
            for (FrontendHistoryMetadata h : meta.getCurrentHistories()) {
                FrontendHistoryMetadataBuilder b = new FrontendHistoryMetadataBuilder(this.getIdentifier(), h);
                this.currentHistories.put(b.getIdentifier(), b);
            }
            this.standaloneId = this.standaloneHistoryId();
            if (!this.currentHistories.containsKey(this.standaloneId)) {
                LOG.warn("{}: Client {} recovered histories {} do not contain stand-alone history, attempting recovery", new Object[]{shardName, this.getIdentifier(), this.currentHistories});
                this.currentHistories.put(this.standaloneId, new FrontendHistoryMetadataBuilder(this.standaloneId));
            }
        }

        public FrontendClientMetadata build() {
            return new FrontendClientMetadata(this.getIdentifier(), this.purgedHistories.immutableCopy(), Collections2.transform(this.currentHistories.values(), FrontendHistoryMetadataBuilder::build));
        }

        @Override
        void onHistoryCreated(LocalHistoryIdentifier historyId) {
            FrontendHistoryMetadataBuilder newMeta = new FrontendHistoryMetadataBuilder(historyId);
            FrontendHistoryMetadataBuilder oldMeta = this.currentHistories.putIfAbsent(historyId, newMeta);
            if (oldMeta != null) {
                LOG.warn("{}: Reused local history {}", (Object)this.shardName(), (Object)historyId);
            } else {
                LOG.debug("{}: Created local history {}", (Object)this.shardName(), (Object)historyId);
            }
        }

        @Override
        void onHistoryClosed(LocalHistoryIdentifier historyId) {
            FrontendHistoryMetadataBuilder builder = this.currentHistories.get(historyId);
            if (builder != null) {
                builder.onHistoryClosed();
                LOG.debug("{}: Closed history {}", (Object)this.shardName(), (Object)historyId);
            } else {
                LOG.warn("{}: Closed unknown history {}, ignoring", (Object)this.shardName(), (Object)historyId);
            }
        }

        @Override
        void onHistoryPurged(LocalHistoryIdentifier historyId) {
            FrontendHistoryMetadataBuilder history = this.currentHistories.remove(historyId);
            long historyBits = historyId.getHistoryId();
            if (history == null) {
                if (!this.purgedHistories.contains(historyBits)) {
                    this.purgedHistories.add(historyBits);
                    LOG.warn("{}: Purging unknown history {}", (Object)this.shardName(), (Object)historyId);
                } else {
                    LOG.warn("{}: Duplicate purge of history {}", (Object)this.shardName(), (Object)historyId);
                }
            } else {
                this.purgedHistories.add(historyBits);
                LOG.debug("{}: Purged history {}", (Object)this.shardName(), (Object)historyId);
            }
        }

        @Override
        void onTransactionAborted(TransactionIdentifier txId) {
            FrontendHistoryMetadataBuilder history = this.getHistory(txId);
            if (history != null) {
                history.onTransactionAborted(txId);
                LOG.debug("{}: Aborted transaction {}", (Object)this.shardName(), (Object)txId);
            } else {
                LOG.warn("{}: Unknown history for aborted transaction {}, ignoring", (Object)this.shardName(), (Object)txId);
            }
        }

        @Override
        void onTransactionCommitted(TransactionIdentifier txId) {
            FrontendHistoryMetadataBuilder history = this.getHistory(txId);
            if (history != null) {
                history.onTransactionCommitted(txId);
                LOG.debug("{}: Committed transaction {}", (Object)this.shardName(), (Object)txId);
            } else {
                LOG.warn("{}: Unknown history for commited transaction {}, ignoring", (Object)this.shardName(), (Object)txId);
            }
        }

        @Override
        void onTransactionPurged(TransactionIdentifier txId) {
            FrontendHistoryMetadataBuilder history = this.getHistory(txId);
            if (history != null) {
                history.onTransactionPurged(txId);
                LOG.debug("{}: Purged transaction {}", (Object)this.shardName(), (Object)txId);
            } else {
                LOG.warn("{}: Unknown history for purged transaction {}, ignoring", (Object)this.shardName(), (Object)txId);
            }
        }

        @Override
        void onTransactionsSkipped(LocalHistoryIdentifier historyId, ImmutableUnsignedLongSet txIds) {
            FrontendHistoryMetadataBuilder history = this.getHistory(historyId);
            if (history != null) {
                history.onTransactionsSkipped(txIds);
                LOG.debug("{}: History {} skipped transactions {}", new Object[]{this.shardName(), historyId, txIds});
            } else {
                LOG.warn("{}: Unknown history {} for skipped transactions, ignoring", (Object)this.shardName(), (Object)historyId);
            }
        }

        @Override
        LeaderFrontendState toLeaderState(Shard shard) {
            AbstractFrontendHistory singleHistory;
            HashMap<LocalHistoryIdentifier, LocalFrontendHistory> histories = new HashMap<LocalHistoryIdentifier, LocalFrontendHistory>();
            for (FrontendHistoryMetadataBuilder e : this.currentHistories.values()) {
                if (e.getIdentifier().getHistoryId() == 0L) continue;
                AbstractFrontendHistory state = e.toLeaderState(shard);
                Verify.verify((boolean)(state instanceof LocalFrontendHistory), (String)"Unexpected state %s", (Object)state);
                histories.put(e.getIdentifier(), (LocalFrontendHistory)state);
            }
            FrontendHistoryMetadataBuilder singleHistoryMeta = this.currentHistories.get(new LocalHistoryIdentifier(this.getIdentifier(), 0L));
            if (singleHistoryMeta == null) {
                ShardDataTree tree = shard.getDataStore();
                singleHistory = StandaloneFrontendHistory.create(shard.persistenceId(), this.getIdentifier(), tree);
            } else {
                singleHistory = singleHistoryMeta.toLeaderState(shard);
            }
            return new LeaderFrontendState.Enabled(shard.persistenceId(), this.getIdentifier(), shard.getDataStore(), this.purgedHistories.mutableCopy(), singleHistory, histories);
        }

        @Override
        MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return super.addToStringAttributes(helper).add("current", this.currentHistories).add("purged", (Object)this.purgedHistories);
        }

        private FrontendHistoryMetadataBuilder getHistory(TransactionIdentifier txId) {
            return this.getHistory(txId.getHistoryId());
        }

        private FrontendHistoryMetadataBuilder getHistory(LocalHistoryIdentifier historyId) {
            LocalHistoryIdentifier local;
            if (historyId.getHistoryId() == 0L && historyId.getCookie() != 0L) {
                LOG.debug("{}: looking up {} instead of {}", new Object[]{this.shardName(), this.standaloneId, historyId});
                local = this.standaloneId;
            } else {
                local = historyId;
            }
            return this.currentHistories.get(local);
        }

        private LocalHistoryIdentifier standaloneHistoryId() {
            return new LocalHistoryIdentifier(this.getIdentifier(), 0L);
        }
    }

    static final class Disabled
    extends FrontendClientMetadataBuilder {
        Disabled(String shardName, ClientIdentifier identifier) {
            super(shardName, identifier);
        }

        public FrontendClientMetadata build() {
            return new FrontendClientMetadata(this.getIdentifier(), ImmutableUnsignedLongSet.of(), (Collection<FrontendHistoryMetadata>)ImmutableList.of());
        }

        @Override
        void onHistoryCreated(LocalHistoryIdentifier historyId) {
        }

        @Override
        void onHistoryClosed(LocalHistoryIdentifier historyId) {
        }

        @Override
        void onHistoryPurged(LocalHistoryIdentifier historyId) {
        }

        @Override
        void onTransactionAborted(TransactionIdentifier txId) {
        }

        @Override
        void onTransactionCommitted(TransactionIdentifier txId) {
        }

        @Override
        void onTransactionPurged(TransactionIdentifier txId) {
        }

        @Override
        void onTransactionsSkipped(LocalHistoryIdentifier historyId, ImmutableUnsignedLongSet txIds) {
        }

        @Override
        LeaderFrontendState toLeaderState(Shard shard) {
            return new LeaderFrontendState.Disabled(shard.persistenceId(), this.getIdentifier(), shard.getDataStore());
        }
    }
}

