/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.opendaylight.controller.cluster.ActorSystemProvider;
import org.opendaylight.controller.cluster.datastore.AbstractDataStore;
import org.opendaylight.controller.cluster.datastore.DatastoreContextIntrospector;
import org.opendaylight.controller.cluster.datastore.DatastoreContextIntrospectorFactory;
import org.opendaylight.controller.cluster.datastore.DatastoreSnapshotRestore;
import org.opendaylight.controller.cluster.datastore.DistributedDataStoreFactory;
import org.opendaylight.controller.cluster.datastore.OSGiDOMStore;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.config.ConfigurationImpl;
import org.opendaylight.controller.cluster.datastore.config.ModuleShardConfigProvider;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextListener;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.ExecutionContext;

@Beta
@Component(immediate=true, configurationPid={"org.opendaylight.controller.cluster.datastore"})
public final class OSGiDistributedDataStore {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiDistributedDataStore.class);
    @Reference
    DOMSchemaService schemaService = null;
    @Reference
    ActorSystemProvider actorSystemProvider = null;
    @Reference
    DatastoreContextIntrospectorFactory introspectorFactory = null;
    @Reference
    DatastoreSnapshotRestore snapshotRestore = null;
    @Reference
    ModuleShardConfigProvider configProvider = null;
    @Reference(target="(component.factory=org.opendaylight.controller.cluster.datastore.OSGiDOMStore)")
    ComponentFactory<OSGiDOMStore> datastoreFactory = null;
    private DatastoreState configDatastore;
    private DatastoreState operDatastore;

    @Activate
    void activate(Map<String, Object> properties) {
        this.configDatastore = this.createDatastore(LogicalDatastoreType.CONFIGURATION, "distributed-config", properties, null);
        this.operDatastore = this.createDatastore(LogicalDatastoreType.OPERATIONAL, "distributed-operational", properties, new ConfigurationImpl(this.configProvider));
    }

    @Modified
    void modified(Map<String, Object> properties) {
        LOG.debug("Overlaying settings: {}", properties);
        this.configDatastore.updateProperties(properties);
        this.operDatastore.updateProperties(properties);
    }

    @Deactivate
    void deactivate() {
        this.operDatastore.stop();
        this.operDatastore = null;
        this.configDatastore.stop();
        this.configDatastore = null;
    }

    private DatastoreState createDatastore(LogicalDatastoreType datastoreType, String serviceType, Map<String, Object> properties, Configuration config) {
        LOG.info("Distributed Datastore type {} starting", (Object)datastoreType);
        DatastoreContextIntrospector introspector = this.introspectorFactory.newInstance(datastoreType, properties);
        AbstractDataStore datastore = DistributedDataStoreFactory.createInstance(this.actorSystemProvider, introspector.getContext(), introspector, this.snapshotRestore, config);
        datastore.setCloseable((AutoCloseable)this.schemaService.registerSchemaContextListener((EffectiveModelContextListener)datastore));
        DatastoreState state = new DatastoreState(introspector, datastoreType, datastore, serviceType);
        Futures.addCallback(datastore.initialSettleFuture(), (FutureCallback)state, arg_0 -> ((ExecutionContext)datastore.getActorUtils().getClientDispatcher()).execute(arg_0));
        return state;
    }

    private final class DatastoreState
    implements FutureCallback<Object> {
        private final DatastoreContextIntrospector introspector;
        private final LogicalDatastoreType datastoreType;
        private final AbstractDataStore datastore;
        private final String serviceType;
        private @GuardedBy(value={"this"}) ComponentInstance<OSGiDOMStore> component;
        private @GuardedBy(value={"this"}) boolean stopped;

        DatastoreState(DatastoreContextIntrospector introspector, LogicalDatastoreType datastoreType, AbstractDataStore datastore, String serviceType) {
            this.introspector = Objects.requireNonNull(introspector);
            this.datastoreType = Objects.requireNonNull(datastoreType);
            this.datastore = Objects.requireNonNull(datastore);
            this.serviceType = Objects.requireNonNull(serviceType);
        }

        synchronized void updateProperties(Map<String, Object> properties) {
            if (this.introspector.update(properties)) {
                LOG.info("Distributed Datastore type {} updating context", (Object)this.datastoreType);
                this.datastore.onDatastoreContextUpdated(this.introspector.newContextFactory());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            LOG.info("Distributed Datastore type {} stopping", (Object)this.datastoreType);
            DatastoreState datastoreState = this;
            synchronized (datastoreState) {
                this.stopped = true;
                if (this.component != null) {
                    this.component.dispose();
                    this.component = null;
                }
                this.datastore.close();
                LOG.info("Distributed Datastore type {} stopped", (Object)this.datastoreType);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressModernizer
        public void onSuccess(Object result) {
            LOG.debug("Distributed Datastore type {} reached initial settle", (Object)this.datastoreType);
            DatastoreState datastoreState = this;
            synchronized (datastoreState) {
                if (!this.stopped) {
                    Hashtable<String, Object> dict = new Hashtable<String, Object>();
                    ((Dictionary)dict).put(".datastore.type", this.datastoreType);
                    ((Dictionary)dict).put(".datastore.instance", this.datastore);
                    ((Dictionary)dict).put("type", this.serviceType);
                    this.component = OSGiDistributedDataStore.this.datastoreFactory.newInstance(dict);
                    LOG.info("Distributed Datastore type {} started", (Object)this.datastoreType);
                }
            }
        }

        public synchronized void onFailure(Throwable cause) {
            LOG.error("Distributed Datastore type {} failed to settle", (Object)this.datastoreType, (Object)cause);
        }
    }
}

