/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.common.base.Stopwatch;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.datastore.messages.OnDemandShardState;
import org.opendaylight.controller.cluster.raft.client.messages.GetOnDemandRaftState;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;

final class OnDemandShardStateCache {
    private static final Cache<String, OnDemandShardState> ONDEMAND_SHARD_STATE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.SECONDS).build();
    private final ActorRef shardActor;
    private final String shardName;
    private volatile String stateRetrievalTime;

    OnDemandShardStateCache(String shardName, ActorRef shardActor) {
        this.shardName = Objects.requireNonNull(shardName);
        this.shardActor = shardActor;
    }

    OnDemandShardState get() throws Exception {
        if (this.shardActor == null) {
            return OnDemandShardState.newBuilder().build();
        }
        return (OnDemandShardState)((Object)ONDEMAND_SHARD_STATE_CACHE.get((Object)this.shardName, this::retrieveState));
    }

    String getStatRetrievaelTime() {
        return this.stateRetrievalTime;
    }

    private OnDemandShardState retrieveState() throws Exception {
        this.stateRetrievalTime = null;
        Timeout timeout = new Timeout(10L, TimeUnit.SECONDS);
        Stopwatch timer = Stopwatch.createStarted();
        OnDemandShardState state = (OnDemandShardState)((Object)Await.result((Awaitable)Patterns.ask((ActorRef)this.shardActor, (Object)GetOnDemandRaftState.INSTANCE, (Timeout)timeout), (Duration)timeout.duration()));
        this.stateRetrievalTime = timer.stop().toString();
        return state;
    }
}

