/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSelection;
import akka.dispatch.OnComplete;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractThreePhaseCommitCohort;
import org.opendaylight.controller.cluster.datastore.OperationCallback;
import org.opendaylight.controller.cluster.datastore.TransactionRateLimitingCallback;
import org.opendaylight.controller.cluster.datastore.messages.AbortTransaction;
import org.opendaylight.controller.cluster.datastore.messages.AbortTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.CanCommitTransaction;
import org.opendaylight.controller.cluster.datastore.messages.CanCommitTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.CommitTransaction;
import org.opendaylight.controller.cluster.datastore.messages.CommitTransactionReply;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.yangtools.yang.common.Empty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

public class ThreePhaseCommitCohortProxy
extends AbstractThreePhaseCommitCohort<ActorSelection> {
    private static final Logger LOG = LoggerFactory.getLogger(ThreePhaseCommitCohortProxy.class);
    private static final MessageSupplier COMMIT_MESSAGE_SUPPLIER = new MessageSupplier(){

        @Override
        public Object newMessage(TransactionIdentifier transactionId, short version) {
            return new CommitTransaction(transactionId, version).toSerializable();
        }

        @Override
        public boolean isSerializedReplyType(Object reply) {
            return CommitTransactionReply.isSerializedType(reply);
        }
    };
    private static final MessageSupplier ABORT_MESSAGE_SUPPLIER = new MessageSupplier(){

        @Override
        public Object newMessage(TransactionIdentifier transactionId, short version) {
            return new AbortTransaction(transactionId, version).toSerializable();
        }

        @Override
        public boolean isSerializedReplyType(Object reply) {
            return AbortTransactionReply.isSerializedType(reply);
        }
    };
    private final ActorUtils actorUtils;
    private final List<CohortInfo> cohorts;
    private final SettableFuture<Empty> cohortsResolvedFuture = SettableFuture.create();
    private final TransactionIdentifier transactionId;
    private volatile OperationCallback commitOperationCallback;

    public ThreePhaseCommitCohortProxy(ActorUtils actorUtils, List<CohortInfo> cohorts, TransactionIdentifier transactionId) {
        this.actorUtils = actorUtils;
        this.cohorts = cohorts;
        this.transactionId = Objects.requireNonNull(transactionId);
        if (cohorts.isEmpty()) {
            this.cohortsResolvedFuture.set((Object)Empty.value());
        }
    }

    private ListenableFuture<Empty> resolveCohorts() {
        if (this.cohortsResolvedFuture.isDone()) {
            return this.cohortsResolvedFuture;
        }
        final AtomicInteger completed = new AtomicInteger(this.cohorts.size());
        final Object lock = new Object();
        for (final CohortInfo info : this.cohorts) {
            info.getActorFuture().onComplete((Function1)new OnComplete<ActorSelection>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onComplete(Throwable failure, ActorSelection actor) {
                    Object object = lock;
                    synchronized (object) {
                        boolean done;
                        boolean bl = done = completed.decrementAndGet() == 0;
                        if (failure != null) {
                            LOG.debug("Tx {}: a cohort Future failed", (Object)ThreePhaseCommitCohortProxy.this.transactionId, (Object)failure);
                            ThreePhaseCommitCohortProxy.this.cohortsResolvedFuture.setException(failure);
                        } else if (!ThreePhaseCommitCohortProxy.this.cohortsResolvedFuture.isDone()) {
                            LOG.debug("Tx {}: cohort actor {} resolved", (Object)ThreePhaseCommitCohortProxy.this.transactionId, (Object)actor);
                            info.setResolvedActor(actor);
                            if (done) {
                                LOG.debug("Tx {}: successfully resolved all cohort actors", (Object)ThreePhaseCommitCohortProxy.this.transactionId);
                                ThreePhaseCommitCohortProxy.this.cohortsResolvedFuture.set((Object)Empty.value());
                            }
                        }
                    }
                }
            }, this.actorUtils.getClientDispatcher());
        }
        return this.cohortsResolvedFuture;
    }

    public ListenableFuture<Boolean> canCommit() {
        LOG.debug("Tx {} canCommit", (Object)this.transactionId);
        final SettableFuture returnFuture = SettableFuture.create();
        Futures.addCallback(this.resolveCohorts(), (FutureCallback)new FutureCallback<Empty>(){

            public void onSuccess(Empty result) {
                ThreePhaseCommitCohortProxy.this.finishCanCommit((SettableFuture<Boolean>)returnFuture);
            }

            public void onFailure(Throwable failure) {
                returnFuture.setException(failure);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return returnFuture;
    }

    private void finishCanCommit(final SettableFuture<Boolean> returnFuture) {
        LOG.debug("Tx {} finishCanCommit", (Object)this.transactionId);
        if (this.cohorts.size() == 0) {
            LOG.debug("Tx {}: canCommit returning result true", (Object)this.transactionId);
            returnFuture.set((Object)Boolean.TRUE);
            return;
        }
        this.commitOperationCallback = new TransactionRateLimitingCallback(this.actorUtils);
        this.commitOperationCallback.run();
        final Iterator<CohortInfo> iterator = this.cohorts.iterator();
        OnComplete<Object> onComplete = new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object response) {
                if (failure != null) {
                    LOG.debug("Tx {}: a canCommit cohort Future failed", (Object)ThreePhaseCommitCohortProxy.this.transactionId, (Object)failure);
                    returnFuture.setException(failure);
                    ThreePhaseCommitCohortProxy.this.commitOperationCallback.failure();
                    return;
                }
                ThreePhaseCommitCohortProxy.this.commitOperationCallback.pause();
                boolean result = true;
                if (CanCommitTransactionReply.isSerializedType(response)) {
                    CanCommitTransactionReply reply = CanCommitTransactionReply.fromSerializable(response);
                    LOG.debug("Tx {}: received {}", (Object)ThreePhaseCommitCohortProxy.this.transactionId, response);
                    if (!reply.getCanCommit()) {
                        result = false;
                    }
                } else {
                    LOG.error("Unexpected response type {}", response.getClass());
                    returnFuture.setException((Throwable)new IllegalArgumentException(String.format("Unexpected response type %s", response.getClass())));
                    return;
                }
                if (iterator.hasNext() && result) {
                    ThreePhaseCommitCohortProxy.this.sendCanCommitTransaction((CohortInfo)iterator.next(), this);
                } else {
                    LOG.debug("Tx {}: canCommit returning result: {}", (Object)ThreePhaseCommitCohortProxy.this.transactionId, (Object)result);
                    returnFuture.set((Object)result);
                }
            }
        };
        this.sendCanCommitTransaction(iterator.next(), onComplete);
    }

    private void sendCanCommitTransaction(CohortInfo toCohortInfo, OnComplete<Object> onComplete) {
        CanCommitTransaction message = new CanCommitTransaction(this.transactionId, toCohortInfo.getActorVersion());
        LOG.debug("Tx {}: sending {} to {}", new Object[]{this.transactionId, message, toCohortInfo.getResolvedActor()});
        Future<Object> future = this.actorUtils.executeOperationAsync(toCohortInfo.getResolvedActor(), message.toSerializable(), this.actorUtils.getTransactionCommitOperationTimeout());
        future.onComplete(onComplete, this.actorUtils.getClientDispatcher());
    }

    private Future<Iterable<Object>> invokeCohorts(MessageSupplier messageSupplier) {
        ArrayList<Future<Object>> futureList = new ArrayList<Future<Object>>(this.cohorts.size());
        for (CohortInfo cohort : this.cohorts) {
            Object message = messageSupplier.newMessage(this.transactionId, cohort.getActorVersion());
            LOG.debug("Tx {}: Sending {} to cohort {}", new Object[]{this.transactionId, message, cohort.getResolvedActor()});
            futureList.add(this.actorUtils.executeOperationAsync(cohort.getResolvedActor(), message, this.actorUtils.getTransactionCommitOperationTimeout()));
        }
        return akka.dispatch.Futures.sequence(futureList, (ExecutionContext)this.actorUtils.getClientDispatcher());
    }

    public ListenableFuture<Empty> preCommit() {
        return IMMEDIATE_EMPTY_SUCCESS;
    }

    public ListenableFuture<Empty> abort() {
        return this.operation("abort", Empty.value(), ABORT_MESSAGE_SUPPLIER, AbortTransactionReply.class, false, OperationCallback.NO_OP_CALLBACK);
    }

    public ListenableFuture<? extends CommitInfo> commit() {
        OperationCallback operationCallback = this.commitOperationCallback != null ? this.commitOperationCallback : OperationCallback.NO_OP_CALLBACK;
        return this.operation("commit", CommitInfo.empty(), COMMIT_MESSAGE_SUPPLIER, CommitTransactionReply.class, true, operationCallback);
    }

    private static boolean successfulFuture(ListenableFuture<?> future) {
        if (!future.isDone()) {
            return false;
        }
        try {
            future.get();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private <T> ListenableFuture<T> operation(final String operationName, final T futureValue, final MessageSupplier messageSupplier, final Class<?> expectedResponseClass, final boolean propagateException, final OperationCallback callback) {
        LOG.debug("Tx {} {}", (Object)this.transactionId, (Object)operationName);
        final SettableFuture returnFuture = SettableFuture.create();
        ListenableFuture<Empty> future = this.resolveCohorts();
        if (ThreePhaseCommitCohortProxy.successfulFuture(future)) {
            this.finishOperation(operationName, messageSupplier, expectedResponseClass, propagateException, returnFuture, futureValue, callback);
        } else {
            Futures.addCallback(future, (FutureCallback)new FutureCallback<Empty>(){

                public void onSuccess(Empty result) {
                    ThreePhaseCommitCohortProxy.this.finishOperation(operationName, messageSupplier, expectedResponseClass, propagateException, returnFuture, futureValue, callback);
                }

                public void onFailure(Throwable failure) {
                    LOG.debug("Tx {}: a {} cohort path Future failed", new Object[]{ThreePhaseCommitCohortProxy.this.transactionId, operationName, failure});
                    if (propagateException) {
                        returnFuture.setException(failure);
                    } else {
                        returnFuture.set(futureValue);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
        return returnFuture;
    }

    private <T> void finishOperation(final String operationName, MessageSupplier messageSupplier, final Class<?> expectedResponseClass, final boolean propagateException, final SettableFuture<T> returnFuture, final T futureValue, final OperationCallback callback) {
        LOG.debug("Tx {} finish {}", (Object)this.transactionId, (Object)operationName);
        callback.resume();
        Future<Iterable<Object>> combinedFuture = this.invokeCohorts(messageSupplier);
        combinedFuture.onComplete((Function1)new OnComplete<Iterable<Object>>(){

            public void onComplete(Throwable failure, Iterable<Object> responses) {
                Throwable exceptionToPropagate = failure;
                if (exceptionToPropagate == null) {
                    for (Object response : responses) {
                        if (response.getClass().equals(expectedResponseClass)) continue;
                        exceptionToPropagate = new IllegalArgumentException(String.format("Unexpected response type %s", response.getClass()));
                        break;
                    }
                }
                if (exceptionToPropagate != null) {
                    LOG.debug("Tx {}: a {} cohort Future failed", new Object[]{ThreePhaseCommitCohortProxy.this.transactionId, operationName, exceptionToPropagate});
                    if (propagateException) {
                        returnFuture.setException(exceptionToPropagate);
                    } else {
                        returnFuture.set(futureValue);
                    }
                    callback.failure();
                } else {
                    LOG.debug("Tx {}: {} succeeded", (Object)ThreePhaseCommitCohortProxy.this.transactionId, (Object)operationName);
                    returnFuture.set(futureValue);
                    callback.success();
                }
            }
        }, this.actorUtils.getClientDispatcher());
    }

    @Override
    List<Future<ActorSelection>> getCohortFutures() {
        ArrayList<Future<ActorSelection>> cohortFutures = new ArrayList<Future<ActorSelection>>(this.cohorts.size());
        for (CohortInfo info : this.cohorts) {
            cohortFutures.add(info.getActorFuture());
        }
        return cohortFutures;
    }

    private static interface MessageSupplier {
        public Object newMessage(TransactionIdentifier var1, short var2);

        public boolean isSerializedReplyType(Object var1);
    }

    static class CohortInfo {
        private final Future<ActorSelection> actorFuture;
        private final Supplier<Short> actorVersionSupplier;
        private volatile ActorSelection resolvedActor;

        CohortInfo(Future<ActorSelection> actorFuture, Supplier<Short> actorVersionSupplier) {
            this.actorFuture = actorFuture;
            this.actorVersionSupplier = actorVersionSupplier;
        }

        Future<ActorSelection> getActorFuture() {
            return this.actorFuture;
        }

        ActorSelection getResolvedActor() {
            return this.resolvedActor;
        }

        void setResolvedActor(ActorSelection resolvedActor) {
            this.resolvedActor = resolvedActor;
        }

        short getActorVersion() {
            Preconditions.checkState((this.resolvedActor != null ? 1 : 0) != 0, (Object)"getActorVersion cannot be called until the actor is resolved");
            return this.actorVersionSupplier.get();
        }
    }
}

