/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSelection;
import akka.dispatch.Futures;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractThreePhaseCommitCohort;
import org.opendaylight.controller.cluster.datastore.AbstractTransactionContextFactory;
import org.opendaylight.controller.cluster.datastore.AbstractTransactionContextWrapper;
import org.opendaylight.controller.cluster.datastore.DebugThreePhaseCommitCohort;
import org.opendaylight.controller.cluster.datastore.NoOpDOMStoreThreePhaseCommitCohort;
import org.opendaylight.controller.cluster.datastore.OperationCallback;
import org.opendaylight.controller.cluster.datastore.SingleCommitCohortProxy;
import org.opendaylight.controller.cluster.datastore.ThreePhaseCommitCohortProxy;
import org.opendaylight.controller.cluster.datastore.TransactionContext;
import org.opendaylight.controller.cluster.datastore.TransactionModificationOperation;
import org.opendaylight.controller.cluster.datastore.TransactionOperation;
import org.opendaylight.controller.cluster.datastore.TransactionRateLimitingCallback;
import org.opendaylight.controller.cluster.datastore.TransactionType;
import org.opendaylight.controller.cluster.datastore.messages.AbstractRead;
import org.opendaylight.controller.cluster.datastore.messages.DataExists;
import org.opendaylight.controller.cluster.datastore.messages.ReadData;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.cluster.datastore.utils.RootScatterGather;
import org.opendaylight.mdsal.dom.spi.store.AbstractDOMStoreTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Future;
import scala.concurrent.Promise;

public class TransactionProxy
extends AbstractDOMStoreTransaction<TransactionIdentifier>
implements DOMStoreReadWriteTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionProxy.class);
    private static final TransactionModificationOperation.DeleteOperation ROOT_DELETE_OPERATION = new TransactionModificationOperation.DeleteOperation(YangInstanceIdentifier.empty());
    private final Map<String, AbstractTransactionContextWrapper> txContextWrappers = new TreeMap<String, AbstractTransactionContextWrapper>();
    private final AbstractTransactionContextFactory<?> txContextFactory;
    private final TransactionType type;
    private TransactionState state = TransactionState.OPEN;

    @VisibleForTesting
    public TransactionProxy(AbstractTransactionContextFactory<?> txContextFactory, TransactionType type) {
        super((Object)txContextFactory.nextIdentifier(), txContextFactory.getActorUtils().getDatastoreContext().isTransactionDebugContextEnabled());
        this.txContextFactory = txContextFactory;
        this.type = Objects.requireNonNull(type);
        LOG.debug("New {} Tx - {}", (Object)type, this.getIdentifier());
    }

    public FluentFuture<Boolean> exists(YangInstanceIdentifier path) {
        return this.executeRead(this.shardNameFromIdentifier(path), new DataExists(path, 12));
    }

    private <T> FluentFuture<T> executeRead(String shardName, final AbstractRead<T> readCmd) {
        Preconditions.checkState((this.type != TransactionType.WRITE_ONLY ? 1 : 0) != 0, (Object)"Reads from write-only transactions are not allowed");
        LOG.trace("Tx {} {} {}", new Object[]{this.getIdentifier(), readCmd.getClass().getSimpleName(), readCmd.getPath()});
        final SettableFuture proxyFuture = SettableFuture.create();
        AbstractTransactionContextWrapper contextWrapper = this.wrapperFromShardName(shardName);
        contextWrapper.maybeExecuteTransactionOperation(new TransactionOperation(){

            @Override
            public void invoke(TransactionContext transactionContext, Boolean havePermit) {
                transactionContext.executeRead(readCmd, proxyFuture, havePermit);
            }
        });
        return FluentFuture.from((ListenableFuture)proxyFuture);
    }

    public FluentFuture<Optional<NormalizedNode>> read(YangInstanceIdentifier path) {
        Preconditions.checkState((this.type != TransactionType.WRITE_ONLY ? 1 : 0) != 0, (Object)"Reads from write-only transactions are not allowed");
        Objects.requireNonNull(path, "path should not be null");
        LOG.trace("Tx {} read {}", this.getIdentifier(), (Object)path);
        return path.isEmpty() ? this.readAllData() : this.singleShardRead(this.shardNameFromIdentifier(path), path);
    }

    private FluentFuture<Optional<NormalizedNode>> singleShardRead(String shardName, YangInstanceIdentifier path) {
        return this.executeRead(shardName, new ReadData(path, 12));
    }

    private FluentFuture<Optional<NormalizedNode>> readAllData() {
        ActorUtils actorUtils = this.getActorUtils();
        return RootScatterGather.gather(actorUtils, actorUtils.getConfiguration().getAllShardNames().stream().map(shardName -> this.singleShardRead((String)shardName, YangInstanceIdentifier.empty())));
    }

    public void delete(YangInstanceIdentifier path) {
        this.checkModificationState("delete", path);
        if (path.isEmpty()) {
            this.deleteAllData();
        } else {
            this.executeModification(new TransactionModificationOperation.DeleteOperation(path));
        }
    }

    private void deleteAllData() {
        for (String shardName : this.getActorUtils().getConfiguration().getAllShardNames()) {
            this.wrapperFromShardName(shardName).maybeExecuteTransactionOperation(ROOT_DELETE_OPERATION);
        }
    }

    public void merge(YangInstanceIdentifier path, NormalizedNode data) {
        this.checkModificationState("merge", path);
        if (path.isEmpty()) {
            this.mergeAllData(RootScatterGather.castRootNode(data));
        } else {
            this.executeModification(new TransactionModificationOperation.MergeOperation(path, data));
        }
    }

    private void mergeAllData(ContainerNode rootData) {
        if (!rootData.isEmpty()) {
            RootScatterGather.scatterTouched(rootData, this::wrapperFromRootChild).forEach(scattered -> ((AbstractTransactionContextWrapper)scattered.shard()).maybeExecuteTransactionOperation(new TransactionModificationOperation.MergeOperation(YangInstanceIdentifier.empty(), (NormalizedNode)scattered.container())));
        }
    }

    public void write(YangInstanceIdentifier path, NormalizedNode data) {
        this.checkModificationState("write", path);
        if (path.isEmpty()) {
            this.writeAllData(RootScatterGather.castRootNode(data));
        } else {
            this.executeModification(new TransactionModificationOperation.WriteOperation(path, data));
        }
    }

    private void writeAllData(ContainerNode rootData) {
        RootScatterGather.scatterAll(rootData, this::wrapperFromRootChild, this.getActorUtils().getConfiguration().getAllShardNames().stream().map(this::wrapperFromShardName)).forEach(scattered -> ((AbstractTransactionContextWrapper)scattered.shard()).maybeExecuteTransactionOperation(new TransactionModificationOperation.WriteOperation(YangInstanceIdentifier.empty(), (NormalizedNode)scattered.container())));
    }

    private void executeModification(TransactionModificationOperation operation) {
        this.wrapperFromShardName(this.shardNameFromIdentifier(operation.path())).maybeExecuteTransactionOperation(operation);
    }

    private void checkModificationState(String opName, YangInstanceIdentifier path) {
        Preconditions.checkState((this.type != TransactionType.READ_ONLY ? 1 : 0) != 0, (Object)"Modification operation on read-only transaction is not allowed");
        Preconditions.checkState((this.state == TransactionState.OPEN ? 1 : 0) != 0, (Object)"Transaction is sealed - further modifications are not allowed");
        LOG.trace("Tx {} {} {}", new Object[]{this.getIdentifier(), opName, path});
    }

    private boolean seal(TransactionState newState) {
        if (this.state == TransactionState.OPEN) {
            this.state = newState;
            return true;
        }
        return false;
    }

    public final void close() {
        if (!this.seal(TransactionState.CLOSED)) {
            Preconditions.checkState((this.state == TransactionState.CLOSED ? 1 : 0) != 0, (String)"Transaction %s is ready, it cannot be closed", (Object)this.getIdentifier());
            return;
        }
        for (AbstractTransactionContextWrapper contextWrapper : this.txContextWrappers.values()) {
            contextWrapper.maybeExecuteTransactionOperation(new TransactionOperation(){

                @Override
                public void invoke(TransactionContext transactionContext, Boolean havePermit) {
                    transactionContext.closeTransaction();
                }
            });
        }
        this.txContextWrappers.clear();
    }

    public final AbstractThreePhaseCommitCohort<?> ready() {
        AbstractThreePhaseCommitCohort ret;
        Preconditions.checkState((this.type != TransactionType.READ_ONLY ? 1 : 0) != 0, (Object)"Read-only transactions cannot be readied");
        boolean success = this.seal(TransactionState.READY);
        Preconditions.checkState((boolean)success, (String)"Transaction %s is %s, it cannot be readied", (Object)this.getIdentifier(), (Object)((Object)this.state));
        LOG.debug("Tx {} Readying {} components for commit", this.getIdentifier(), (Object)this.txContextWrappers.size());
        switch (this.txContextWrappers.size()) {
            case 0: {
                ret = NoOpDOMStoreThreePhaseCommitCohort.INSTANCE;
                break;
            }
            case 1: {
                Map.Entry e = (Map.Entry)Iterables.getOnlyElement(this.txContextWrappers.entrySet());
                ret = this.createSingleCommitCohort((String)e.getKey(), (AbstractTransactionContextWrapper)e.getValue());
                break;
            }
            default: {
                ret = this.createMultiCommitCohort();
            }
        }
        this.txContextFactory.onTransactionReady((TransactionIdentifier)this.getIdentifier(), ret.getCohortFutures());
        Throwable debugContext = this.getDebugContext();
        return debugContext == null ? ret : new DebugThreePhaseCommitCohort((TransactionIdentifier)this.getIdentifier(), ret, debugContext);
    }

    private AbstractThreePhaseCommitCohort<?> createSingleCommitCohort(String shardName, AbstractTransactionContextWrapper contextWrapper) {
        Future future;
        LOG.debug("Tx {} Readying transaction for shard {}", this.getIdentifier(), (Object)shardName);
        final OperationCallback.Reference operationCallbackRef = new OperationCallback.Reference(OperationCallback.NO_OP_CALLBACK);
        TransactionContext transactionContext = contextWrapper.getTransactionContext();
        if (transactionContext == null) {
            final Promise promise = Futures.promise();
            contextWrapper.maybeExecuteTransactionOperation(new TransactionOperation(){

                @Override
                public void invoke(TransactionContext newTransactionContext, Boolean havePermit) {
                    promise.completeWith(TransactionProxy.this.getDirectCommitFuture(newTransactionContext, operationCallbackRef, havePermit));
                }
            });
            future = promise.future();
        } else {
            future = this.getDirectCommitFuture(transactionContext, operationCallbackRef, null);
        }
        return new SingleCommitCohortProxy(this.txContextFactory.getActorUtils(), (Future<Object>)future, (TransactionIdentifier)this.getIdentifier(), operationCallbackRef);
    }

    private Future<?> getDirectCommitFuture(TransactionContext transactionContext, OperationCallback.Reference operationCallbackRef, Boolean havePermit) {
        TransactionRateLimitingCallback rateLimitingCallback = new TransactionRateLimitingCallback(this.txContextFactory.getActorUtils());
        operationCallbackRef.set(rateLimitingCallback);
        rateLimitingCallback.run();
        return transactionContext.directCommit(havePermit);
    }

    private AbstractThreePhaseCommitCohort<ActorSelection> createMultiCommitCohort() {
        ArrayList<ThreePhaseCommitCohortProxy.CohortInfo> cohorts = new ArrayList<ThreePhaseCommitCohortProxy.CohortInfo>(this.txContextWrappers.size());
        Optional<SortedSet<String>> shardNames = Optional.of(new TreeSet<String>(this.txContextWrappers.keySet()));
        for (Map.Entry<String, AbstractTransactionContextWrapper> e : this.txContextWrappers.entrySet()) {
            LOG.debug("Tx {} Readying transaction for shard {}", this.getIdentifier(), (Object)e.getKey());
            AbstractTransactionContextWrapper wrapper = e.getValue();
            cohorts.add(new ThreePhaseCommitCohortProxy.CohortInfo(wrapper.readyTransaction(shardNames), () -> wrapper.getTransactionContext().getTransactionVersion()));
        }
        return new ThreePhaseCommitCohortProxy(this.txContextFactory.getActorUtils(), cohorts, (TransactionIdentifier)this.getIdentifier());
    }

    private String shardNameFromIdentifier(YangInstanceIdentifier path) {
        return this.getActorUtils().getShardStrategyFactory().getStrategy(path).findShard(path);
    }

    private AbstractTransactionContextWrapper wrapperFromRootChild(YangInstanceIdentifier.PathArgument childId) {
        return this.wrapperFromShardName(this.shardNameFromIdentifier(YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument)childId)));
    }

    private AbstractTransactionContextWrapper wrapperFromShardName(String shardName) {
        AbstractTransactionContextWrapper existing = this.txContextWrappers.get(shardName);
        if (existing != null) {
            return existing;
        }
        AbstractTransactionContextWrapper fresh = this.txContextFactory.newTransactionContextWrapper(this, shardName);
        this.txContextWrappers.put(shardName, fresh);
        return fresh;
    }

    TransactionType getType() {
        return this.type;
    }

    boolean isReady() {
        return this.state != TransactionState.OPEN;
    }

    final ActorUtils getActorUtils() {
        return this.txContextFactory.getActorUtils();
    }

    private static enum TransactionState {
        OPEN,
        READY,
        CLOSED;

    }
}

