/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.actors;

import akka.actor.Props;
import com.google.common.base.Preconditions;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedActor;
import org.opendaylight.controller.cluster.datastore.persisted.CommitTransactionPayload;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.messages.Payload;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

public final class JsonExportActor
extends AbstractUntypedActor {
    private final List<ReplicatedLogEntry> entries = new ArrayList<ReplicatedLogEntry>();
    private final @NonNull EffectiveModelContext schemaContext;
    private final @NonNull Path baseDirPath;

    private JsonExportActor(EffectiveModelContext schemaContext, Path dirPath) {
        this.schemaContext = Objects.requireNonNull(schemaContext);
        this.baseDirPath = Objects.requireNonNull(dirPath);
    }

    public static Props props(EffectiveModelContext schemaContext, String dirPath) {
        return Props.create(JsonExportActor.class, (Object[])new Object[]{schemaContext, Paths.get(dirPath, new String[0])});
    }

    protected void handleReceive(Object message) {
        if (message instanceof ExportSnapshot) {
            this.onExportSnapshot((ExportSnapshot)message);
        } else if (message instanceof ExportJournal) {
            this.onExportJournal((ExportJournal)message);
        } else if (message instanceof FinishExport) {
            this.onFinishExport((FinishExport)message);
        } else {
            this.unknownMessage(message);
        }
    }

    private void onExportSnapshot(ExportSnapshot exportSnapshot) {
        Path snapshotDir = this.baseDirPath.resolve("snapshots");
        this.createDir(snapshotDir);
        Path filePath = snapshotDir.resolve(exportSnapshot.id + "-snapshot.json");
        this.LOG.debug("Creating JSON file : {}", (Object)filePath);
        NormalizedNode root = (NormalizedNode)exportSnapshot.dataTreeCandidate.getRootNode().getDataAfter().get();
        Preconditions.checkState((boolean)(root instanceof NormalizedNodeContainer), (String)"Unexpected root %s", (Object)root);
        this.writeSnapshot(filePath, (NormalizedNodeContainer)root);
        this.LOG.debug("Created JSON file: {}", (Object)filePath);
    }

    private void onExportJournal(ExportJournal exportJournal) {
        this.entries.add(exportJournal.replicatedLogEntry);
    }

    private void onFinishExport(FinishExport finishExport) {
        Path journalDir = this.baseDirPath.resolve("journals");
        this.createDir(journalDir);
        Path filePath = journalDir.resolve(finishExport.id + "-journal.json");
        this.LOG.debug("Creating JSON file : {}", (Object)filePath);
        this.writeJournal(filePath);
        this.LOG.debug("Created JSON file: {}", (Object)filePath);
    }

    private void writeSnapshot(Path path, NormalizedNodeContainer<?> root) {
        try (JsonWriter jsonWriter = new JsonWriter((Writer)Files.newBufferedWriter(path, new OpenOption[0]));){
            jsonWriter.beginObject();
            try (NormalizedNodeWriter nnWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)JSONNormalizedNodeStreamWriter.createNestedWriter((JSONCodecFactory)JSONCodecFactorySupplier.RFC7951.getShared(this.schemaContext), (EffectiveStatementInference)SchemaInferenceStack.of((EffectiveModelContext)this.schemaContext).toInference(), null, (JsonWriter)jsonWriter), (boolean)true);){
                for (NormalizedNode node : root.body()) {
                    nnWriter.write(node);
                }
            }
            jsonWriter.endObject();
        }
        catch (IOException e) {
            this.LOG.error("Failed to export stapshot to {}", (Object)path, (Object)e);
        }
    }

    private void writeJournal(Path path) {
        try (JsonWriter jsonWriter = new JsonWriter((Writer)Files.newBufferedWriter(path, new OpenOption[0]));){
            jsonWriter.beginObject().name("Entries");
            jsonWriter.beginArray();
            for (ReplicatedLogEntry entry : this.entries) {
                Payload data = entry.getData();
                if (data instanceof CommitTransactionPayload) {
                    CommitTransactionPayload payload = (CommitTransactionPayload)entry.getData();
                    DataTreeCandidate candidate = payload.getCandidate().getValue().getCandidate();
                    JsonExportActor.writeNode(jsonWriter, candidate);
                    continue;
                }
                jsonWriter.beginObject().name("Payload").value(data.toString()).endObject();
            }
            jsonWriter.endArray();
            jsonWriter.endObject();
        }
        catch (IOException e) {
            this.LOG.error("Failed to export journal to {}", (Object)path, (Object)e);
        }
    }

    private static void writeNode(JsonWriter writer, DataTreeCandidate candidate) throws IOException {
        writer.beginObject();
        writer.name("Entry");
        writer.beginArray();
        JsonExportActor.doWriteNode(writer, candidate.getRootPath(), candidate.getRootNode());
        writer.endArray();
        writer.endObject();
    }

    private static void doWriteNode(JsonWriter writer, YangInstanceIdentifier path, DataTreeCandidateNode node) throws IOException {
        switch (node.getModificationType()) {
            case APPEARED: 
            case DISAPPEARED: 
            case SUBTREE_MODIFIED: {
                NodeIterator iterator = new NodeIterator(null, path, node.getChildNodes().iterator());
                while ((iterator = iterator.next(writer)) != null) {
                }
                break;
            }
            case DELETE: 
            case UNMODIFIED: 
            case WRITE: {
                JsonExportActor.outputNodeInfo(writer, path, node);
                break;
            }
            default: {
                JsonExportActor.outputDefault(writer, path, node);
            }
        }
    }

    private static void outputNodeInfo(JsonWriter writer, YangInstanceIdentifier path, DataTreeCandidateNode node) throws IOException {
        ModificationType modificationType = node.getModificationType();
        writer.beginObject().name("Node");
        writer.beginArray();
        writer.beginObject().name("Path").value(path.toString()).endObject();
        writer.beginObject().name("ModificationType").value(modificationType.toString()).endObject();
        if (modificationType == ModificationType.WRITE) {
            writer.beginObject().name("Data").value(((NormalizedNode)node.getDataAfter().get()).body().toString()).endObject();
        }
        writer.endArray();
        writer.endObject();
    }

    private static void outputDefault(JsonWriter writer, YangInstanceIdentifier path, DataTreeCandidateNode node) throws IOException {
        writer.beginObject().name("Node");
        writer.beginArray();
        writer.beginObject().name("Path").value(path.toString()).endObject();
        writer.beginObject().name("ModificationType").value("UNSUPPORTED MODIFICATION: " + node.getModificationType()).endObject();
        writer.endArray();
        writer.endObject();
    }

    private void createDir(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.LOG.warn("Directory {} cannot be created", (Object)path, (Object)e);
        }
    }

    private static final class NodeIterator {
        private final Iterator<DataTreeCandidateNode> iterator;
        private final YangInstanceIdentifier path;
        private final NodeIterator parent;

        NodeIterator(@Nullable NodeIterator parent, YangInstanceIdentifier path, Iterator<DataTreeCandidateNode> iterator) {
            this.iterator = Objects.requireNonNull(iterator);
            this.path = Objects.requireNonNull(path);
            this.parent = parent;
        }

        NodeIterator next(JsonWriter writer) throws IOException {
            block4: while (this.iterator.hasNext()) {
                DataTreeCandidateNode node = this.iterator.next();
                YangInstanceIdentifier child = this.path.node(node.getIdentifier());
                switch (node.getModificationType()) {
                    case APPEARED: 
                    case DISAPPEARED: 
                    case SUBTREE_MODIFIED: {
                        return new NodeIterator(this, child, node.getChildNodes().iterator());
                    }
                    case DELETE: 
                    case UNMODIFIED: 
                    case WRITE: {
                        JsonExportActor.outputNodeInfo(writer, this.path, node);
                        continue block4;
                    }
                }
                JsonExportActor.outputDefault(writer, child, node);
            }
            return this.parent;
        }
    }

    public static final class FinishExport {
        private final String id;

        public FinishExport(String id) {
            this.id = Objects.requireNonNull(id);
        }
    }

    public static final class ExportJournal {
        private final ReplicatedLogEntry replicatedLogEntry;

        public ExportJournal(ReplicatedLogEntry replicatedLogEntry) {
            this.replicatedLogEntry = Objects.requireNonNull(replicatedLogEntry);
        }
    }

    public static final class ExportSnapshot {
        private final String id;
        private final DataTreeCandidate dataTreeCandidate;

        public ExportSnapshot(DataTreeCandidate candidate, String id) {
            this.dataTreeCandidate = Objects.requireNonNull(candidate);
            this.id = Objects.requireNonNull(id);
        }
    }
}

