/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.SerializationUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.raft.messages.IdentifiablePayload;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.concepts.Identifier;

public abstract class AbstractIdentifiablePayload<T extends Identifier>
extends IdentifiablePayload<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final byte @NonNull [] serialized;
    private final @NonNull T identifier;

    AbstractIdentifiablePayload(@NonNull T identifier, byte @NonNull [] serialized) {
        this.identifier = (Identifier)Objects.requireNonNull(identifier);
        this.serialized = Objects.requireNonNull(serialized);
    }

    public final T getIdentifier() {
        return this.identifier;
    }

    public final int size() {
        return this.serialized.length;
    }

    protected final byte @NonNull [] serialized() {
        return this.serialized;
    }

    public final int serializedSize() {
        return this.size() + this.externalizableProxySize();
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("identifier", this.identifier).add("size", this.size()).toString();
    }

    protected final Object writeReplace() {
        return Verify.verifyNotNull(this.externalizableProxy(this.serialized));
    }

    protected abstract @NonNull AbstractProxy<T> externalizableProxy(byte @NonNull [] var1);

    protected abstract int externalizableProxySize();

    protected static final int externalizableProxySize(Function<byte[], ? extends AbstractProxy<?>> constructor) {
        return SerializationUtils.serialize((Serializable)constructor.apply(new byte[0])).length;
    }

    protected static abstract class AbstractProxy<T extends Identifier>
    implements SerialForm {
        private static final long serialVersionUID = 1L;
        private byte[] serialized;
        private T identifier;

        public AbstractProxy() {
        }

        protected AbstractProxy(byte[] serialized) {
            this.serialized = Objects.requireNonNull(serialized);
        }

        @Override
        public final byte[] bytes() {
            return this.serialized;
        }

        @Override
        public final void readExternal(byte[] bytes) throws IOException {
            this.serialized = Objects.requireNonNull(bytes);
            this.identifier = (Identifier)Verify.verifyNotNull(this.readIdentifier((DataInput)ByteStreams.newDataInput((byte[])this.serialized)));
        }

        @Override
        public final Object readResolve() {
            return Verify.verifyNotNull(this.createObject(this.identifier, this.serialized));
        }

        protected abstract @NonNull T readIdentifier(@NonNull DataInput var1) throws IOException;

        protected abstract @NonNull Identifiable<T> createObject(@NonNull T var1, byte @NonNull [] var2);
    }

    protected static interface SerialForm
    extends Externalizable {
        public byte[] bytes();

        public Object readResolve();

        public void readExternal(byte[] var1) throws IOException;

        @Override
        default public void readExternal(ObjectInput in) throws IOException {
            byte[] bytes = new byte[in.readInt()];
            in.readFully(bytes);
            this.readExternal(bytes);
        }

        @Override
        default public void writeExternal(ObjectOutput out) throws IOException {
            byte[] bytes = this.bytes();
            out.writeInt(bytes.length);
            out.write(bytes);
        }
    }
}

