/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.datastore.persisted.AbstractIdentifiablePayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CloseLocalHistoryPayload
extends AbstractIdentifiablePayload<LocalHistoryIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(CloseLocalHistoryPayload.class);
    private static final long serialVersionUID = 1L;
    private static final int PROXY_SIZE = CloseLocalHistoryPayload.externalizableProxySize(Proxy::new);

    CloseLocalHistoryPayload(LocalHistoryIdentifier historyId, byte[] serialized) {
        super(historyId, serialized);
    }

    public static CloseLocalHistoryPayload create(LocalHistoryIdentifier historyId, int initialSerializedBufferCapacity) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput((int)initialSerializedBufferCapacity);
        try {
            historyId.writeTo((DataOutput)out);
        }
        catch (IOException e) {
            LOG.error("Failed to serialize {}", (Object)historyId, (Object)e);
            throw new RuntimeException("Failed to serialize " + historyId, e);
        }
        return new CloseLocalHistoryPayload(historyId, out.toByteArray());
    }

    protected Proxy externalizableProxy(byte[] serialized) {
        return new Proxy(serialized);
    }

    @Override
    protected int externalizableProxySize() {
        return PROXY_SIZE;
    }

    private static final class Proxy
    extends AbstractIdentifiablePayload.AbstractProxy<LocalHistoryIdentifier> {
        private static final long serialVersionUID = 1L;

        public Proxy() {
        }

        Proxy(byte[] serialized) {
            super(serialized);
        }

        @Override
        protected LocalHistoryIdentifier readIdentifier(DataInput in) throws IOException {
            return LocalHistoryIdentifier.readFrom((DataInput)in);
        }

        protected CloseLocalHistoryPayload createObject(LocalHistoryIdentifier identifier, byte[] serialized) {
            return new CloseLocalHistoryPayload(identifier, serialized);
        }
    }
}

