/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.datastore.persisted.AbstractIdentifiablePayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DisableTrackingPayload
extends AbstractIdentifiablePayload<ClientIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(DisableTrackingPayload.class);
    private static final long serialVersionUID = 1L;
    private static final int PROXY_SIZE = DisableTrackingPayload.externalizableProxySize(Proxy::new);

    DisableTrackingPayload(ClientIdentifier clientId, byte[] serialized) {
        super(clientId, serialized);
    }

    public static DisableTrackingPayload create(ClientIdentifier clientId, int initialSerializedBufferCapacity) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput((int)initialSerializedBufferCapacity);
        try {
            clientId.writeTo((DataOutput)out);
        }
        catch (IOException e) {
            LOG.error("Failed to serialize {}", (Object)clientId, (Object)e);
            throw new RuntimeException("Failed to serialize " + clientId, e);
        }
        return new DisableTrackingPayload(clientId, out.toByteArray());
    }

    protected Proxy externalizableProxy(byte[] serialized) {
        return new Proxy(serialized);
    }

    @Override
    protected int externalizableProxySize() {
        return PROXY_SIZE;
    }

    private static final class Proxy
    extends AbstractIdentifiablePayload.AbstractProxy<ClientIdentifier> {
        private static final long serialVersionUID = -5490519942445085251L;

        public Proxy() {
        }

        Proxy(byte[] serialized) {
            super(serialized);
        }

        @Override
        protected ClientIdentifier readIdentifier(DataInput in) throws IOException {
            return ClientIdentifier.readFrom((DataInput)in);
        }

        protected DisableTrackingPayload createObject(ClientIdentifier identifier, byte[] serialized) {
            return new DisableTrackingPayload(identifier, serialized);
        }
    }
}

