/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;

public class ShardManagerSnapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> shardList;

    public ShardManagerSnapshot(@NonNull List<String> shardList) {
        this.shardList = ImmutableList.copyOf(shardList);
    }

    public List<String> getShardList() {
        return this.shardList;
    }

    private Object writeReplace() {
        return new Proxy(this);
    }

    public String toString() {
        return "ShardManagerSnapshot [ShardList = " + this.shardList + " ]";
    }

    private static final class Proxy
    implements SerializedForm {
        private static final long serialVersionUID = 1L;
        private ShardManagerSnapshot snapshot;

        public Proxy() {
        }

        Proxy(ShardManagerSnapshot snapshot) {
            this.snapshot = snapshot;
        }

        @Override
        public List<String> shardNames() {
            return this.snapshot.getShardList();
        }

        @Override
        public void resolveTo(ShardManagerSnapshot newSnapshot) {
            this.snapshot = Objects.requireNonNull(newSnapshot);
        }

        @Override
        public Object readResolve() {
            return Verify.verifyNotNull((Object)this.snapshot);
        }
    }

    static interface SerializedForm
    extends Externalizable {
        public List<String> shardNames();

        public Object readResolve();

        public void resolveTo(@NonNull ShardManagerSnapshot var1);

        @Override
        default public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            ArrayList<String> shardList = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                shardList.add((String)in.readObject());
            }
            this.resolveTo(new ShardManagerSnapshot(shardList));
        }

        @Override
        default public void writeExternal(ObjectOutput out) throws IOException {
            List<String> shardList = this.shardNames();
            out.writeInt(shardList.size());
            for (String shardName : shardList) {
                out.writeObject(shardName);
            }
        }
    }
}

