/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;

public class ShardSnapshotState
implements Snapshot.State {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="This field is not Serializable but this class implements writeReplace to delegate serialization to a Proxy class and thus instances of this class aren't serialized. FindBugs does not recognize this.")
    private final @NonNull ShardDataTreeSnapshot snapshot;
    private final boolean migrated;

    @VisibleForTesting
    public ShardSnapshotState(@NonNull ShardDataTreeSnapshot snapshot, boolean migrated) {
        this.snapshot = Objects.requireNonNull(snapshot);
        this.migrated = migrated;
    }

    public ShardSnapshotState(@NonNull ShardDataTreeSnapshot snapshot) {
        this(snapshot, false);
    }

    public @NonNull ShardDataTreeSnapshot getSnapshot() {
        return this.snapshot;
    }

    public boolean needsMigration() {
        return this.migrated;
    }

    private Object writeReplace() {
        return new Proxy(this);
    }

    private static final class Proxy
    implements SerialForm {
        private static final long serialVersionUID = 1L;
        private ShardSnapshotState snapshotState;

        public Proxy() {
        }

        Proxy(ShardSnapshotState snapshotState) {
            this.snapshotState = snapshotState;
        }

        @Override
        public ShardSnapshotState snapshotState() {
            return this.snapshotState;
        }

        @Override
        public void resolveTo(ShardSnapshotState newSnapshotState) {
            this.snapshotState = Objects.requireNonNull(newSnapshotState);
        }

        @Override
        public Object readResolve() {
            return Verify.verifyNotNull((Object)this.snapshotState);
        }
    }

    static interface SerialForm
    extends Externalizable {
        public ShardSnapshotState snapshotState();

        public void resolveTo(@NonNull ShardSnapshotState var1);

        public Object readResolve();

        @Override
        default public void readExternal(ObjectInput in) throws IOException {
            this.resolveTo(ShardDataTreeSnapshot.deserialize(in));
        }

        @Override
        default public void writeExternal(ObjectOutput out) throws IOException {
            this.snapshotState().getSnapshot().serialize(out);
        }
    }
}

