/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.base.Verify;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.datastore.persisted.AbstractIdentifiablePayload;
import org.opendaylight.controller.cluster.datastore.utils.ImmutableUnsignedLongSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SkipTransactionsPayload
extends AbstractIdentifiablePayload<LocalHistoryIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(SkipTransactionsPayload.class);
    private static final long serialVersionUID = 1L;
    private static final int PROXY_SIZE = SkipTransactionsPayload.externalizableProxySize(Proxy::new);
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Handled via externalizable proxy")
    private final @NonNull ImmutableUnsignedLongSet transactionIds;

    SkipTransactionsPayload(@NonNull LocalHistoryIdentifier historyId, byte @NonNull [] serialized, ImmutableUnsignedLongSet transactionIds) {
        super(historyId, serialized);
        this.transactionIds = Objects.requireNonNull(transactionIds);
    }

    public static @NonNull SkipTransactionsPayload create(LocalHistoryIdentifier historyId, ImmutableUnsignedLongSet transactionIds, int initialSerializedBufferCapacity) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput((int)initialSerializedBufferCapacity);
        try {
            historyId.writeTo((DataOutput)out);
            transactionIds.writeTo((DataOutput)out);
        }
        catch (IOException e) {
            LOG.error("Failed to serialize {} ids {}", new Object[]{historyId, transactionIds, e});
            throw new RuntimeException("Failed to serialize " + historyId + " ids " + transactionIds, e);
        }
        return new SkipTransactionsPayload(historyId, out.toByteArray(), transactionIds);
    }

    public @NonNull ImmutableUnsignedLongSet getTransactionIds() {
        return this.transactionIds;
    }

    protected Proxy externalizableProxy(byte[] serialized) {
        return new Proxy(serialized);
    }

    @Override
    protected int externalizableProxySize() {
        return PROXY_SIZE;
    }

    private static final class Proxy
    extends AbstractIdentifiablePayload.AbstractProxy<LocalHistoryIdentifier> {
        private static final long serialVersionUID = 1L;
        private ImmutableUnsignedLongSet transactionIds;

        public Proxy() {
        }

        Proxy(byte[] serialized) {
            super(serialized);
        }

        @Override
        protected LocalHistoryIdentifier readIdentifier(DataInput in) throws IOException {
            LocalHistoryIdentifier id = LocalHistoryIdentifier.readFrom((DataInput)in);
            this.transactionIds = ImmutableUnsignedLongSet.readFrom(in);
            return id;
        }

        protected SkipTransactionsPayload createObject(LocalHistoryIdentifier identifier, byte[] serialized) {
            return new SkipTransactionsPayload(identifier, serialized, (ImmutableUnsignedLongSet)Verify.verifyNotNull((Object)this.transactionIds));
        }
    }
}

