/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl;

import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractExplicitGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.Generator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.GeneratorReactor;
import org.opendaylight.mdsal.binding.generator.impl.reactor.IdentityGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.RpcGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.RpcInputGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.RpcOutputGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.mdsal.binding.generator.impl.rt.DefaultBindingRuntimeTypes;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeTypes;
import org.opendaylight.mdsal.binding.runtime.api.CaseRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.IdentityRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.InputRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.ModuleRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.OutputRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcEffectiveStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BindingRuntimeTypesFactory
implements Mutable {
    private static final Logger LOG = LoggerFactory.getLogger(BindingRuntimeTypesFactory.class);
    private final Map<QNameModule, ModuleRuntimeType> modules = new HashMap<QNameModule, ModuleRuntimeType>();
    private final Map<QName, IdentityRuntimeType> identities = new HashMap<QName, IdentityRuntimeType>();
    private final Map<JavaTypeName, RuntimeType> allTypes = new HashMap<JavaTypeName, RuntimeType>();
    private final Map<QName, OutputRuntimeType> rpcOutputs = new HashMap<QName, OutputRuntimeType>();
    private final Map<QName, InputRuntimeType> rpcInputs = new HashMap<QName, InputRuntimeType>();
    private final SetMultimap<JavaTypeName, CaseRuntimeType> choiceToCases = HashMultimap.create();

    private BindingRuntimeTypesFactory() {
    }

    static @NonNull BindingRuntimeTypes createTypes(@NonNull EffectiveModelContext context) {
        Map<QNameModule, ModuleGenerator> moduleGens = new GeneratorReactor(context).execute(TypeBuilderFactory.runtime());
        Stopwatch sw = Stopwatch.createStarted();
        BindingRuntimeTypesFactory factory = new BindingRuntimeTypesFactory();
        factory.indexModules(moduleGens);
        LOG.debug("Indexed {} generators in {}", (Object)moduleGens.size(), (Object)sw);
        return new DefaultBindingRuntimeTypes(context, factory.modules, factory.allTypes, factory.identities, factory.rpcInputs, factory.rpcOutputs, factory.choiceToCases);
    }

    private void indexModules(Map<QNameModule, ModuleGenerator> moduleGens) {
        for (Map.Entry<QNameModule, ModuleGenerator> entry : moduleGens.entrySet()) {
            ModuleGenerator modGen = entry.getValue();
            BindingRuntimeTypesFactory.safePut(this.modules, "modules", entry.getKey(), (ModuleRuntimeType)modGen.runtimeType().orElseThrow());
            for (Generator gen : modGen) {
                if (gen instanceof IdentityGenerator) {
                    ((IdentityGenerator)gen).runtimeType().ifPresent(identity -> BindingRuntimeTypesFactory.safePut(this.identities, "identities", (QName)identity.statement().argument(), identity));
                }
                if (!(gen instanceof RpcGenerator)) continue;
                QName rpcName = (QName)((RpcEffectiveStatement)((RpcGenerator)gen).statement()).argument();
                for (Generator subgen : gen) {
                    if (subgen instanceof RpcInputGenerator) {
                        ((RpcInputGenerator)subgen).runtimeType().ifPresent(input -> this.rpcInputs.put(rpcName, (InputRuntimeType)input));
                        continue;
                    }
                    if (!(subgen instanceof RpcOutputGenerator)) continue;
                    ((RpcOutputGenerator)subgen).runtimeType().ifPresent(output -> this.rpcOutputs.put(rpcName, (OutputRuntimeType)output));
                }
            }
        }
        this.indexRuntimeTypes(moduleGens.values());
    }

    private void indexRuntimeTypes(Iterable<? extends Generator> generators) {
        for (Generator generator : generators) {
            RuntimeType type;
            Type javaType;
            if (generator instanceof AbstractExplicitGenerator && generator.generatedType().isPresent() && (javaType = (type = (RuntimeType)((AbstractExplicitGenerator)generator).runtimeType().orElseThrow()).javaType()) instanceof GeneratedType) {
                JavaTypeName name = (JavaTypeName)javaType.getIdentifier();
                RuntimeType prev = this.allTypes.put(name, type);
                Verify.verify((prev == null || prev == type ? 1 : 0) != 0, (String)"Conflict on runtime type mapping of %s between %s and %s", (Object)name, (Object)prev, (Object)type);
                if (type instanceof CaseRuntimeType) {
                    List ifaces = ((GeneratedType)javaType).getImplements();
                    Verify.verify((ifaces.size() >= 2 ? 1 : 0) != 0, (String)"Unexpected implemented interfaces %s", (Object)ifaces);
                    this.choiceToCases.put((Object)((JavaTypeName)((Type)ifaces.get(0)).getIdentifier()), (Object)((CaseRuntimeType)type));
                }
            }
            this.indexRuntimeTypes(generator);
        }
    }

    private static <K, V> void safePut(Map<K, V> map, String name, K key, V value) {
        V prev = map.put(key, value);
        Verify.verify((prev == null ? 1 : 0) != 0, (String)"Conflict in %s, key %s conflicts on %s versus %s", (Object)name, key, prev, value);
    }
}

