/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractAugmentGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractExplicitGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ActionGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AugmentRequirement;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AugmentResolver;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CaseGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ChoiceGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CollisionDomain;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CompositeRuntimeTypeBuilder;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ContainerGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.Generator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.GeneratorContext;
import org.opendaylight.mdsal.binding.generator.impl.reactor.GroupingGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.IdentityGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.InputGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.KeyGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.LeafGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.LeafListGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.LinkageProgress;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ListGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.MatchStrategy;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ModuleAugmentGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.NotificationGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.NotificationServiceGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.OpaqueObjectGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.OriginalLink;
import org.opendaylight.mdsal.binding.generator.impl.reactor.OutputGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.RpcGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.RpcInputGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.RpcOutputGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.RpcServiceGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypedefGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.UsesAugmentGenerator;
import org.opendaylight.mdsal.binding.model.api.Enumeration;
import org.opendaylight.mdsal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.model.ri.BindingTypes;
import org.opendaylight.mdsal.binding.runtime.api.CompositeRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AddedByUsesAware;
import org.opendaylight.yangtools.yang.model.api.CopyableNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ActionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AnydataEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AnyxmlEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.CaseEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ContainerEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.GroupingEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.InputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OutputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesEffectiveStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompositeGenerator<S extends EffectiveStatement<?, ?>, R extends CompositeRuntimeType>
extends AbstractExplicitGenerator<S, R> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCompositeGenerator.class);
    private final @NonNull CollisionDomain domain = new CollisionDomain(this);
    private final @NonNull List<Generator> childGenerators;
    private @NonNull List<AbstractAugmentGenerator> augments = List.of();
    private List<GroupingGenerator> groupings;
    private List<AbstractCompositeGenerator<?, ?>> unlinkedComposites = List.of();
    private List<Generator> unlinkedChildren;

    AbstractCompositeGenerator(S statement) {
        super(statement);
        this.childGenerators = this.createChildren((EffectiveStatement<?, ?>)statement);
    }

    AbstractCompositeGenerator(S statement, AbstractCompositeGenerator<?, ?> parent) {
        super(statement, parent);
        this.childGenerators = this.createChildren((EffectiveStatement<?, ?>)statement);
    }

    @Override
    public final Iterator<Generator> iterator() {
        return this.childGenerators.iterator();
    }

    final @NonNull List<AbstractAugmentGenerator> augments() {
        return this.augments;
    }

    final @NonNull List<GroupingGenerator> groupings() {
        return (List)Verify.verifyNotNull(this.groupings, (String)"Groupings not initialized in %s", (Object[])new Object[]{this});
    }

    @Override
    final R createExternalRuntimeType(Type type) {
        Verify.verify((boolean)(type instanceof GeneratedType), (String)"Unexpected type %s", (Object)type);
        return this.createBuilder(this.statement()).populate(new AugmentResolver(), this).build((GeneratedType)type);
    }

    abstract @NonNull CompositeRuntimeTypeBuilder<S, R> createBuilder(S var1);

    @Override
    final R createInternalRuntimeType(AugmentResolver resolver, S statement, Type type) {
        Verify.verify((boolean)(type instanceof GeneratedType), (String)"Unexpected type %s", (Object)type);
        return this.createBuilder(statement).populate(resolver, this).build((GeneratedType)type);
    }

    @Override
    final boolean isEmpty() {
        return this.childGenerators.isEmpty();
    }

    final @Nullable AbstractExplicitGenerator<?, ?> findGenerator(List<EffectiveStatement<?, ?>> stmtPath) {
        return this.findGenerator(MatchStrategy.identity(), stmtPath, 0);
    }

    final @Nullable AbstractExplicitGenerator<?, ?> findGenerator(MatchStrategy childStrategy, List<EffectiveStatement<?, ?>> stmtPath, int offset) {
        EffectiveStatement<?, ?> stmt = stmtPath.get(offset);
        AbstractExplicitGenerator<?, ?> ret = childStrategy.findGenerator(stmt, this.childGenerators);
        if (ret != null) {
            int next = offset + 1;
            if (stmtPath.size() == next) {
                return ret;
            }
            if (ret instanceof AbstractCompositeGenerator) {
                return ((AbstractCompositeGenerator)ret).findGenerator(childStrategy, stmtPath, next);
            }
            return null;
        }
        if (stmt instanceof SchemaTreeEffectiveStatement) {
            for (GroupingGenerator gen : this.groupings) {
                MatchStrategy strat;
                ret = gen.findGenerator(strat = MatchStrategy.grouping(gen), stmtPath, offset);
                if (ret == null) continue;
                return ret;
            }
            MatchStrategy strat = MatchStrategy.augment();
            for (AbstractAugmentGenerator gen : this.augments) {
                ret = gen.findGenerator(strat, stmtPath, offset);
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    final @NonNull CollisionDomain domain() {
        return this.domain;
    }

    final void linkUsesDependencies(GeneratorContext context) {
        ArrayList<GroupingGenerator> tmp = new ArrayList<GroupingGenerator>();
        for (EffectiveStatement stmt : this.statement().effectiveSubstatements()) {
            if (!(stmt instanceof UsesEffectiveStatement)) continue;
            UsesEffectiveStatement uses = (UsesEffectiveStatement)stmt;
            GroupingGenerator grouping = context.resolveTreeScoped(GroupingGenerator.class, (QName)uses.argument());
            tmp.add(grouping);
            for (Generator gen : this) {
                if (!(gen instanceof UsesAugmentGenerator)) continue;
                ((UsesAugmentGenerator)gen).resolveGrouping(uses, grouping);
            }
        }
        this.groupings = List.copyOf(tmp);
    }

    final void startUsesAugmentLinkage(List<AugmentRequirement> requirements) {
        for (Generator child : this.childGenerators) {
            if (child instanceof UsesAugmentGenerator) {
                requirements.add(((UsesAugmentGenerator)child).startLinkage());
            }
            if (!(child instanceof AbstractCompositeGenerator)) continue;
            ((AbstractCompositeGenerator)child).startUsesAugmentLinkage(requirements);
        }
    }

    final void addAugment(AbstractAugmentGenerator augment) {
        if (this.augments.isEmpty()) {
            this.augments = new ArrayList<AbstractAugmentGenerator>(2);
        }
        this.augments.add(Objects.requireNonNull(augment));
    }

    final @NonNull LinkageProgress linkOriginalGeneratorRecursive() {
        Iterator<Generator> it;
        if (this.unlinkedComposites == null) {
            return LinkageProgress.DONE;
        }
        if (this.unlinkedChildren == null) {
            this.unlinkedChildren = this.childGenerators.stream().filter(AbstractExplicitGenerator.class::isInstance).map(child -> (AbstractExplicitGenerator)child).collect(Collectors.toList());
        }
        LinkageProgress progress = LinkageProgress.NONE;
        if (!this.unlinkedChildren.isEmpty()) {
            it = this.unlinkedChildren.iterator();
            while (it.hasNext()) {
                Generator child2 = it.next();
                if (!(child2 instanceof AbstractExplicitGenerator) || !((AbstractExplicitGenerator)child2).linkOriginalGenerator()) continue;
                progress = LinkageProgress.SOME;
                it.remove();
                if (!(child2 instanceof AbstractCompositeGenerator)) continue;
                if (this.unlinkedComposites.isEmpty()) {
                    this.unlinkedComposites = new ArrayList();
                }
                this.unlinkedComposites.add((AbstractCompositeGenerator)child2);
            }
            if (this.unlinkedChildren.isEmpty()) {
                this.unlinkedChildren = List.of();
            }
        }
        it = this.unlinkedComposites.iterator();
        while (it.hasNext()) {
            LinkageProgress tmp = ((AbstractCompositeGenerator)it.next()).linkOriginalGeneratorRecursive();
            if (tmp != LinkageProgress.NONE) {
                progress = LinkageProgress.SOME;
            }
            if (tmp != LinkageProgress.DONE) continue;
            it.remove();
        }
        if (this.unlinkedChildren.isEmpty() && this.unlinkedComposites.isEmpty()) {
            this.unlinkedComposites = null;
            return LinkageProgress.DONE;
        }
        return progress;
    }

    @Override
    final AbstractCompositeGenerator<S, R> getOriginal() {
        return (AbstractCompositeGenerator)super.getOriginal();
    }

    @Override
    final AbstractCompositeGenerator<S, R> tryOriginal() {
        return (AbstractCompositeGenerator)super.tryOriginal();
    }

    final <X extends EffectiveStatement<?, ?>, Y extends RuntimeType> @Nullable OriginalLink<X, Y> originalChild(QName childQName) {
        QName prevQName;
        AbstractExplicitGenerator<?, ?> found = this.findInferredGenerator(childQName);
        if (found != null) {
            return OriginalLink.partial(found);
        }
        AbstractExplicitGenerator prev = this.previous();
        if (prev != null && (found = prev.findSchemaTreeGenerator(prevQName = childQName.bindTo(prev.getQName().getModule()))) != null) {
            return found.originalLink();
        }
        return null;
    }

    @Override
    final AbstractExplicitGenerator<?, ?> findSchemaTreeGenerator(QName qname) {
        AbstractExplicitGenerator<?, ?> found = super.findSchemaTreeGenerator(qname);
        return found != null ? found : this.findInferredGenerator(qname);
    }

    final @Nullable AbstractAugmentGenerator findAugmentForGenerator(QName qname) {
        for (AbstractAugmentGenerator augment : this.augments) {
            AbstractExplicitGenerator<?, ?> gen = augment.findSchemaTreeGenerator(qname);
            if (gen == null) continue;
            return augment;
        }
        return null;
    }

    final @Nullable GroupingGenerator findGroupingForGenerator(QName qname) {
        for (GroupingGenerator grouping : this.groupings) {
            AbstractExplicitGenerator<?, ?> gen = grouping.findSchemaTreeGenerator(qname.bindTo(((QName)((GroupingEffectiveStatement)grouping.statement()).argument()).getModule()));
            if (gen == null) continue;
            return grouping;
        }
        return null;
    }

    private @Nullable AbstractExplicitGenerator<?, ?> findInferredGenerator(QName qname) {
        AbstractExplicitGenerator<?, ?> gen;
        for (GroupingGenerator grouping : this.groupings) {
            gen = grouping.findSchemaTreeGenerator(qname.bindTo(((QName)((GroupingEffectiveStatement)grouping.statement()).argument()).getModule()));
            if (gen == null) continue;
            return gen;
        }
        for (AbstractAugmentGenerator augment : this.augments) {
            gen = augment.findSchemaTreeGenerator(qname);
            if (gen == null) continue;
            return gen;
        }
        return null;
    }

    final int addUsesInterfaces(GeneratedTypeBuilder builder, TypeBuilderFactory builderFactory) {
        for (GroupingGenerator grp : this.groupings) {
            builder.addImplementsType((Type)grp.getGeneratedType(builderFactory));
        }
        return this.groupings.size();
    }

    static final void addAugmentable(GeneratedTypeBuilder builder) {
        builder.addImplementsType((Type)BindingTypes.augmentable((Type)builder));
    }

    final void addGetterMethods(GeneratedTypeBuilder builder, TypeBuilderFactory builderFactory) {
        for (Generator child : this) {
            GeneratedType enclosedType;
            if (child instanceof AbstractExplicitGenerator) {
                ((AbstractExplicitGenerator)child).addAsGetterMethod((GeneratedTypeBuilderBase<?>)builder, builderFactory);
            }
            if ((enclosedType = child.enclosedType(builderFactory)) instanceof GeneratedTransferObject) {
                builder.addEnclosingTransferObject((GeneratedTransferObject)enclosedType);
                continue;
            }
            if (enclosedType instanceof Enumeration) {
                builder.addEnumeration((Enumeration)enclosedType);
                continue;
            }
            Verify.verify((enclosedType == null ? 1 : 0) != 0, (String)"Unhandled enclosed type %s in %s", (Object)enclosedType, (Object)child);
        }
    }

    private @NonNull List<Generator> createChildren(EffectiveStatement<?, ?> statement) {
        ArrayList<Generator> tmp = new ArrayList<Generator>();
        ArrayList<? super AbstractAugmentGenerator> tmpAug = new ArrayList<AbstractAugmentGenerator>();
        for (EffectiveStatement stmt : statement.effectiveSubstatements()) {
            InputEffectiveStatement cast;
            if (stmt instanceof ActionEffectiveStatement) {
                if (AbstractCompositeGenerator.isAugmenting(stmt)) continue;
                tmp.add(new ActionGenerator((ActionEffectiveStatement)stmt, this));
                continue;
            }
            if (stmt instanceof AnydataEffectiveStatement) {
                if (AbstractCompositeGenerator.isAugmenting(stmt)) continue;
                tmp.add(new OpaqueObjectGenerator.Anydata((AnydataEffectiveStatement)stmt, this));
                continue;
            }
            if (stmt instanceof AnyxmlEffectiveStatement) {
                if (AbstractCompositeGenerator.isAugmenting(stmt)) continue;
                tmp.add(new OpaqueObjectGenerator.Anyxml((AnyxmlEffectiveStatement)stmt, this));
                continue;
            }
            if (stmt instanceof CaseEffectiveStatement) {
                tmp.add(new CaseGenerator((CaseEffectiveStatement)stmt, this));
                continue;
            }
            if (stmt instanceof ChoiceEffectiveStatement) {
                if (AbstractCompositeGenerator.isAddedByUses(stmt)) continue;
                tmp.add(new ChoiceGenerator((ChoiceEffectiveStatement)stmt, this));
                continue;
            }
            if (stmt instanceof ContainerEffectiveStatement) {
                if (!AbstractCompositeGenerator.isOriginalDeclaration(stmt)) continue;
                tmp.add(new ContainerGenerator((ContainerEffectiveStatement)stmt, this));
                continue;
            }
            if (stmt instanceof GroupingEffectiveStatement) {
                tmp.add(new GroupingGenerator((GroupingEffectiveStatement)stmt, this));
                continue;
            }
            if (stmt instanceof IdentityEffectiveStatement) {
                tmp.add(new IdentityGenerator((IdentityEffectiveStatement)stmt, this));
                continue;
            }
            if (stmt instanceof InputEffectiveStatement) {
                cast = (InputEffectiveStatement)stmt;
                tmp.add(this instanceof RpcGenerator ? new RpcInputGenerator(cast, this) : new InputGenerator(cast, this));
                continue;
            }
            if (stmt instanceof LeafEffectiveStatement) {
                if (AbstractCompositeGenerator.isAugmenting(stmt)) continue;
                tmp.add(new LeafGenerator((LeafEffectiveStatement)stmt, this));
                continue;
            }
            if (stmt instanceof LeafListEffectiveStatement) {
                if (AbstractCompositeGenerator.isAugmenting(stmt)) continue;
                tmp.add(new LeafListGenerator((LeafListEffectiveStatement)stmt, this));
                continue;
            }
            if (stmt instanceof ListEffectiveStatement) {
                if (!AbstractCompositeGenerator.isOriginalDeclaration(stmt)) continue;
                ListGenerator listGen = new ListGenerator((ListEffectiveStatement)stmt, this);
                tmp.add(listGen);
                KeyGenerator keyGen = listGen.keyGenerator();
                if (keyGen == null) continue;
                tmp.add(keyGen);
                continue;
            }
            if (stmt instanceof NotificationEffectiveStatement) {
                if (AbstractCompositeGenerator.isAugmenting(stmt)) continue;
                tmp.add(new NotificationGenerator((NotificationEffectiveStatement)stmt, this));
                continue;
            }
            if (stmt instanceof OutputEffectiveStatement) {
                cast = (OutputEffectiveStatement)stmt;
                tmp.add(this instanceof RpcGenerator ? new RpcOutputGenerator((OutputEffectiveStatement)cast, this) : new OutputGenerator((OutputEffectiveStatement)cast, this));
                continue;
            }
            if (stmt instanceof RpcEffectiveStatement) {
                tmp.add(new RpcGenerator((RpcEffectiveStatement)stmt, this));
                continue;
            }
            if (stmt instanceof TypedefEffectiveStatement) {
                tmp.add(new TypedefGenerator((TypedefEffectiveStatement)stmt, this));
                continue;
            }
            if (stmt instanceof AugmentEffectiveStatement) {
                if (!(this instanceof ModuleGenerator)) continue;
                tmpAug.add(new ModuleAugmentGenerator((AugmentEffectiveStatement)stmt, this));
                continue;
            }
            if (stmt instanceof UsesEffectiveStatement) {
                UsesEffectiveStatement uses = (UsesEffectiveStatement)stmt;
                for (EffectiveStatement usesSub : uses.effectiveSubstatements()) {
                    if (!(usesSub instanceof AugmentEffectiveStatement)) continue;
                    tmpAug.add(new UsesAugmentGenerator((AugmentEffectiveStatement)usesSub, uses, this));
                }
                continue;
            }
            LOG.trace("Ignoring statement {}", (Object)stmt);
        }
        tmpAug.sort(AbstractAugmentGenerator.COMPARATOR);
        tmp.addAll(tmpAug);
        if (this instanceof ModuleGenerator) {
            ModuleGenerator moduleGen = (ModuleGenerator)this;
            List<NotificationGenerator> notifs = tmp.stream().filter(NotificationGenerator.class::isInstance).map(NotificationGenerator.class::cast).collect(Collectors.toUnmodifiableList());
            if (!notifs.isEmpty()) {
                tmp.add(new NotificationServiceGenerator(moduleGen, notifs));
            }
            List<RpcGenerator> rpcs = tmp.stream().filter(RpcGenerator.class::isInstance).map(RpcGenerator.class::cast).collect(Collectors.toUnmodifiableList());
            if (!rpcs.isEmpty()) {
                tmp.add(new RpcServiceGenerator(moduleGen, rpcs));
            }
        }
        return List.copyOf(tmp);
    }

    private static boolean isOriginalDeclaration(EffectiveStatement<?, ?> stmt) {
        return !(stmt instanceof AddedByUsesAware) || !((AddedByUsesAware)stmt).isAddedByUses() && (!(stmt instanceof CopyableNode) || !((CopyableNode)stmt).isAugmenting());
    }

    private static boolean isAddedByUses(EffectiveStatement<?, ?> stmt) {
        return stmt instanceof AddedByUsesAware && ((AddedByUsesAware)stmt).isAddedByUses();
    }

    private static boolean isAugmenting(EffectiveStatement<?, ?> stmt) {
        return stmt instanceof CopyableNode && ((CopyableNode)stmt).isAugmenting();
    }
}

