/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.base.Verify;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ClassPlacement;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CompositeRuntimeTypeBuilder;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CompositeSchemaTreeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.GroupingGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.KeyGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ListGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.mdsal.binding.generator.impl.rt.DefaultActionRuntimeType;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.model.ri.BindingTypes;
import org.opendaylight.mdsal.binding.runtime.api.ActionRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.AugmentRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ActionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.InputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OutputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

final class ActionGenerator
extends CompositeSchemaTreeGenerator<ActionEffectiveStatement, ActionRuntimeType> {
    ActionGenerator(ActionEffectiveStatement statement, AbstractCompositeGenerator<?, ?> parent) {
        super(statement, parent);
    }

    @Override
    void pushToInference(SchemaInferenceStack dataTree) {
        dataTree.enterSchemaTree(((ActionEffectiveStatement)this.statement()).getIdentifier());
    }

    @Override
    ClassPlacement classPlacement() {
        return this.getParent() instanceof GroupingGenerator ? ClassPlacement.PHANTOM : ClassPlacement.TOP_LEVEL;
    }

    @Override
    GeneratedType createTypeImpl(TypeBuilderFactory builderFactory) {
        GeneratedTypeBuilder builder = builderFactory.newGeneratedTypeBuilder(this.typeName());
        builder.addImplementsType(this.implementedType(builderFactory));
        ModuleGenerator module = this.currentModule();
        module.addQNameConstant((GeneratedTypeBuilderBase<?>)builder, (AbstractQName)((ActionEffectiveStatement)this.statement()).argument());
        this.annotateDeprecatedIfNecessary((AnnotableTypeBuilder)builder);
        builderFactory.addCodegenInformation(module, (EffectiveStatement<?, ?>)this.statement(), (GeneratedTypeBuilderBase<?>)builder);
        return builder.build();
    }

    private @NonNull Type implementedType(TypeBuilderFactory builderFactory) {
        KeyGenerator keyGen;
        GeneratedType input = ActionGenerator.getChild(this, InputEffectiveStatement.class).getOriginal().getGeneratedType(builderFactory);
        GeneratedType output = ActionGenerator.getChild(this, OutputEffectiveStatement.class).getOriginal().getGeneratedType(builderFactory);
        AbstractCompositeGenerator<?, ?> parent = this.getParent();
        if (parent instanceof ListGenerator && (keyGen = ((ListGenerator)parent).keyGenerator()) != null) {
            return BindingTypes.keyedListAction((Type)Type.of((JavaTypeName)parent.typeName()), (Type)keyGen.getGeneratedType(builderFactory), (Type)input, (Type)output);
        }
        return BindingTypes.action((Type)Type.of((JavaTypeName)parent.typeName()), (Type)input, (Type)output);
    }

    @Override
    void addAsGetterMethod(GeneratedTypeBuilderBase<?> builder, TypeBuilderFactory builderFactory) {
    }

    @Override
    CompositeRuntimeTypeBuilder<ActionEffectiveStatement, ActionRuntimeType> createBuilder(ActionEffectiveStatement statement) {
        return new CompositeRuntimeTypeBuilder<ActionEffectiveStatement, ActionRuntimeType>(statement){

            @Override
            ActionRuntimeType build(GeneratedType generatedType, ActionEffectiveStatement statement, List<RuntimeType> childTypes, List<AugmentRuntimeType> augmentTypes) {
                Verify.verify((boolean)augmentTypes.isEmpty(), (String)"Unexpected augments %s", augmentTypes);
                return new DefaultActionRuntimeType(generatedType, statement, childTypes);
            }
        };
    }
}

