/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractAugmentGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ClassNamingStrategy;
import org.opendaylight.mdsal.binding.generator.impl.reactor.Generator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.RpcInputGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.RpcOutputGenerator;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.model.api.stmt.InputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OutputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

final class CollisionDomain {
    private final AbstractCompositeGenerator<?, ?> gen;
    private List<Member> members = List.of();
    private boolean solved;

    CollisionDomain(AbstractCompositeGenerator<?, ?> gen) {
        this.gen = Objects.requireNonNull(gen);
    }

    @NonNull Member addPrefix(Generator memberGen, ClassNamingStrategy strategy) {
        return new Prefix(memberGen, strategy);
    }

    @NonNull Member addPrimary(Generator memberGen, ClassNamingStrategy strategy) {
        return this.addMember(new Primary(memberGen, strategy));
    }

    @NonNull Member addSecondary(Generator memberGen, Member primary, String classSuffix) {
        return this.addMember(new LeafSecondary(memberGen, primary, classSuffix));
    }

    @NonNull Member addSecondary(RpcInputGenerator memberGen, Member primary) {
        return this.addMember(new SuffixSecondary(memberGen, primary, "Input", (AbstractQName)((InputEffectiveStatement)memberGen.statement()).argument()));
    }

    @NonNull Member addSecondary(RpcOutputGenerator memberGen, Member primary) {
        return this.addMember(new SuffixSecondary(memberGen, primary, "Output", (AbstractQName)((OutputEffectiveStatement)memberGen.statement()).argument()));
    }

    @NonNull Member addSecondary(AbstractAugmentGenerator memberGen, Member classPrimary, String classSuffix, SchemaNodeIdentifier packageSuffix) {
        return this.addMember(new AugmentSecondary(memberGen, classPrimary, classSuffix, packageSuffix));
    }

    boolean findSolution() {
        if (this.solved) {
            return false;
        }
        if (this.members.size() < 2) {
            this.solved = true;
            return false;
        }
        boolean result = false;
        do {
            ArrayListMultimap toAssign = ArrayListMultimap.create();
            for (Member member : this.members) {
                toAssign.put((Object)member.currentClass(), (Object)member);
            }
            Iterator it = toAssign.asMap().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Collection assignees = (Collection)entry.getValue();
                if (assignees.size() != 1) continue;
                it.remove();
            }
            this.solved = true;
            if (toAssign.isEmpty()) continue;
            result = true;
            for (Collection conflicting : toAssign.asMap().values()) {
                int remaining = 0;
                for (Member member : conflicting) {
                    if (member.signalConflict()) continue;
                    ++remaining;
                }
                Preconditions.checkState((remaining < 2 ? 1 : 0) != 0, (String)"Failed to solve %s due to naming conflict among %s", (Object)this, (Object)conflicting);
            }
        } while (!this.solved);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("gen", this.gen).toString();
    }

    private @NonNull Member addMember(@NonNull Member member) {
        if (this.members.isEmpty()) {
            this.members = new ArrayList<Member>();
        }
        this.members.add(member);
        return member;
    }

    private static @NonNull String packageString(AbstractQName component) {
        return component.getLocalName().replace('-', '.');
    }

    private final class AugmentSecondary
    extends Secondary {
        private final SchemaNodeIdentifier packageSuffix;

        AugmentSecondary(AbstractAugmentGenerator gen, Member primary, String classSuffix, SchemaNodeIdentifier packageSuffix) {
            super(gen, primary, classSuffix);
            this.packageSuffix = Objects.requireNonNull(packageSuffix);
        }

        @Override
        String computeCurrentPackage() {
            Iterator it = this.packageSuffix.getNodeIdentifiers().iterator();
            StringBuilder sb = new StringBuilder();
            sb.append(CollisionDomain.packageString((AbstractQName)it.next()));
            while (it.hasNext()) {
                sb.append('.').append(CollisionDomain.packageString((AbstractQName)it.next()));
            }
            return sb.toString();
        }
    }

    private final class SuffixSecondary
    extends Secondary {
        private final AbstractQName packageSuffix;

        SuffixSecondary(Generator gen, Member primaryClass, String classSuffix, AbstractQName packageSuffix) {
            super(gen, primaryClass, classSuffix);
            this.packageSuffix = Objects.requireNonNull(packageSuffix);
        }

        @Override
        String computeCurrentPackage() {
            return this.classPrimary.currentPackage() + "." + CollisionDomain.packageString(this.packageSuffix);
        }
    }

    private final class LeafSecondary
    extends Secondary {
        LeafSecondary(Generator gen, Member classPrimary, String classSuffix) {
            super(gen, classPrimary, classSuffix);
        }

        @Override
        String computeCurrentPackage() {
            throw new UnsupportedOperationException();
        }
    }

    private abstract class Secondary
    extends Member {
        private final String classSuffix;
        final Member classPrimary;

        Secondary(Generator gen, Member primary, String classSuffix) {
            super(gen);
            this.classPrimary = Objects.requireNonNull(primary);
            this.classSuffix = Objects.requireNonNull(classSuffix);
            primary.addSecondary(this);
        }

        @Override
        final String computeCurrentClass() {
            return this.classPrimary.currentClass() + this.classSuffix;
        }

        @Override
        final boolean signalConflict() {
            return this.classPrimary.signalConflict();
        }

        final void primaryConflict() {
            super.signalConflict();
        }

        @Override
        final boolean equalRoot(Member other) {
            if (other instanceof Secondary) {
                Secondary sec = (Secondary)other;
                return this.classPrimary.equalRoot(sec.classPrimary) && this.classSuffix.equals(sec.classSuffix);
            }
            return false;
        }
    }

    private final class Prefix
    extends Primary {
        Prefix(Generator gen, ClassNamingStrategy strategy) {
            super(gen, strategy);
        }
    }

    private class Primary
    extends Member {
        private ClassNamingStrategy strategy;

        Primary(Generator gen, ClassNamingStrategy strategy) {
            super(gen);
            this.strategy = Objects.requireNonNull(strategy);
        }

        @Override
        final String computeCurrentClass() {
            return this.strategy.simpleClassName();
        }

        @Override
        final String computeCurrentPackage() {
            return CollisionDomain.packageString(this.strategy.nodeIdentifier());
        }

        @Override
        final boolean signalConflict() {
            ClassNamingStrategy newStrategy = this.strategy.fallback();
            if (newStrategy == null) {
                return false;
            }
            this.strategy = newStrategy;
            return super.signalConflict();
        }

        @Override
        final MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return super.addToStringAttributes(helper.add("strategy", (Object)this.strategy));
        }

        @Override
        boolean equalRoot(Member other) {
            return other instanceof Primary && this.strategy.nodeIdentifier().getLocalName().equals(((Primary)other).strategy.nodeIdentifier().getLocalName());
        }
    }

    abstract class Member {
        private final Generator gen;
        private List<Secondary> secondaries = List.of();
        private String currentPackage;
        private String currentClass;

        Member(Generator gen) {
            this.gen = Objects.requireNonNull(gen);
        }

        final void addSecondary(Secondary secondary) {
            if (this.secondaries.isEmpty()) {
                this.secondaries = new ArrayList<Secondary>();
            }
            this.secondaries.add(Objects.requireNonNull(secondary));
        }

        final @NonNull String currentClass() {
            if (this.currentClass == null) {
                this.currentClass = this.computeCurrentClass();
            }
            return this.currentClass;
        }

        final @NonNull String currentPackage() {
            if (this.currentPackage == null) {
                this.currentPackage = this.computeCurrentPackage();
            }
            return this.currentPackage;
        }

        abstract boolean equalRoot(@NonNull Member var1);

        abstract String computeCurrentClass();

        abstract String computeCurrentPackage();

        boolean signalConflict() {
            CollisionDomain.this.solved = false;
            this.currentClass = null;
            this.currentPackage = null;
            for (Secondary secondary : this.secondaries) {
                secondary.primaryConflict();
            }
            return true;
        }

        public final String toString() {
            return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
        }

        MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return helper.add("gen", (Object)this.gen).add("class", (Object)this.currentClass).add("package", (Object)this.currentPackage);
        }
    }
}

