/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractAugmentGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractExplicitGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CaseGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ChoiceGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ClassPlacement;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CollisionDomain;
import org.opendaylight.mdsal.binding.generator.impl.reactor.GeneratorResult;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.SerialVersionHelper;
import org.opendaylight.mdsal.binding.generator.impl.reactor.StatementNamespace;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.mdsal.binding.model.api.AccessModifier;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.mdsal.binding.model.ri.BindingTypes;
import org.opendaylight.mdsal.binding.model.ri.Types;
import org.opendaylight.mdsal.binding.model.ri.generated.type.builder.GeneratedPropertyBuilderImpl;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

public abstract class Generator
implements Iterable<Generator> {
    private static final JavaTypeName DEPRECATED_ANNOTATION = JavaTypeName.create(Deprecated.class);
    static final JavaTypeName OVERRIDE_ANNOTATION = JavaTypeName.create(Override.class);
    private final AbstractCompositeGenerator<?, ?> parent;
    private Optional<CollisionDomain.Member> member;
    private GeneratorResult result;
    private JavaTypeName typeName;
    private String javaPackage;

    Generator() {
        this.parent = null;
    }

    Generator(AbstractCompositeGenerator<?, ?> parent) {
        this.parent = Objects.requireNonNull(parent);
    }

    public final @NonNull Optional<GeneratedType> generatedType() {
        return Optional.ofNullable(this.result.generatedType());
    }

    public @NonNull List<GeneratedType> auxiliaryGeneratedTypes() {
        return List.of();
    }

    @Override
    public Iterator<Generator> iterator() {
        return Collections.emptyIterator();
    }

    final @NonNull AbstractCompositeGenerator<?, ?> getParent() {
        return (AbstractCompositeGenerator)Verify.verifyNotNull(this.parent, (String)"No parent for %s", (Object[])new Object[]{this});
    }

    boolean isEmpty() {
        return true;
    }

    @NonNull StatementNamespace namespace() {
        return StatementNamespace.DEFAULT;
    }

    @NonNull ModuleGenerator currentModule() {
        return this.getParent().currentModule();
    }

    abstract void pushToInference(@NonNull SchemaInferenceStack var1);

    abstract @NonNull ClassPlacement classPlacement();

    final @NonNull CollisionDomain.Member getMember() {
        return (CollisionDomain.Member)Verify.verifyNotNull((Object)this.ensureMember(), (String)"No member for %s", (Object[])new Object[]{this});
    }

    final CollisionDomain.Member ensureMember() {
        if (this.member == null) {
            ClassPlacement placement = this.classPlacement();
            switch (placement) {
                case NONE: {
                    this.member = Optional.empty();
                    break;
                }
                case MEMBER: 
                case PHANTOM: 
                case TOP_LEVEL: {
                    this.member = Optional.of(this.createMember(this.parentDomain()));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled placement " + placement);
                }
            }
        }
        return this.member.orElse(null);
    }

    @NonNull CollisionDomain parentDomain() {
        return this.getParent().domain();
    }

    abstract @NonNull CollisionDomain.Member createMember(@NonNull CollisionDomain var1);

    final void ensureType(TypeBuilderFactory builderFactory) {
        if (this.result != null) {
            return;
        }
        ClassPlacement placement = this.classPlacement();
        switch (placement) {
            case NONE: 
            case PHANTOM: {
                this.result = GeneratorResult.empty();
                break;
            }
            case MEMBER: {
                this.result = GeneratorResult.member(this.createTypeImpl(Objects.requireNonNull(builderFactory)));
                break;
            }
            case TOP_LEVEL: {
                this.result = GeneratorResult.toplevel(this.createTypeImpl(Objects.requireNonNull(builderFactory)));
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled placement " + placement);
            }
        }
        for (Generator child : this) {
            child.ensureType(builderFactory);
        }
    }

    @NonNull GeneratedType getGeneratedType(TypeBuilderFactory builderFactory) {
        return (GeneratedType)Verify.verifyNotNull((Object)this.tryGeneratedType(builderFactory), (String)"No type generated for %s", (Object[])new Object[]{this});
    }

    final @Nullable GeneratedType tryGeneratedType(TypeBuilderFactory builderFactory) {
        this.ensureType(builderFactory);
        return this.result.generatedType();
    }

    final @Nullable GeneratedType enclosedType(TypeBuilderFactory builderFactory) {
        this.ensureType(builderFactory);
        return this.result.enclosedType();
    }

    abstract @NonNull GeneratedType createTypeImpl(@NonNull TypeBuilderFactory var1);

    final @NonNull String assignedName() {
        return this.getMember().currentClass();
    }

    final @NonNull String javaPackage() {
        String local = this.javaPackage;
        if (local == null) {
            this.javaPackage = local = this.createJavaPackage();
        }
        return local;
    }

    @NonNull String createJavaPackage() {
        String parentPackage = this.getPackageParent().javaPackage();
        String myPackage = this.getMember().currentPackage();
        return BindingMapping.normalizePackageName((String)(parentPackage + "." + myPackage));
    }

    final @NonNull JavaTypeName typeName() {
        JavaTypeName local = this.typeName;
        if (local == null) {
            this.typeName = local = this.createTypeName();
        }
        return local;
    }

    @NonNull JavaTypeName createTypeName() {
        return JavaTypeName.create((String)this.getPackageParent().javaPackage(), (String)this.assignedName());
    }

    @NonNull AbstractCompositeGenerator<?, ?> getPackageParent() {
        return this.getParent();
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper;
    }

    final void addImplementsChildOf(GeneratedTypeBuilder builder) {
        AbstractCompositeGenerator<?, ?> ancestor = this.getParent();
        while (true) {
            AbstractCompositeGenerator<?, ?> target;
            if (ancestor instanceof CaseGenerator || ancestor instanceof ChoiceGenerator) {
                ancestor = ancestor.getParent();
                continue;
            }
            if (!(ancestor instanceof AbstractAugmentGenerator) || !((target = ((AbstractAugmentGenerator)ancestor).targetGenerator()) instanceof ChoiceGenerator)) break;
            ancestor = target;
        }
        builder.addImplementsType((Type)BindingTypes.childOf((Type)Type.of((JavaTypeName)ancestor.typeName())));
    }

    static final void addConcreteInterfaceMethods(GeneratedTypeBuilder builder) {
        Generator.defaultImplementedInterace(builder);
        ((MethodSignatureBuilder)((MethodSignatureBuilder)builder.addMethod("bindingHashCode").setAccessModifier(AccessModifier.PUBLIC)).setStatic(true)).setReturnType((Type)Types.primitiveIntType());
        ((MethodSignatureBuilder)((MethodSignatureBuilder)builder.addMethod("bindingEquals").setAccessModifier(AccessModifier.PUBLIC)).setStatic(true)).setReturnType((Type)Types.primitiveBooleanType());
        ((MethodSignatureBuilder)((MethodSignatureBuilder)builder.addMethod("bindingToString").setAccessModifier(AccessModifier.PUBLIC)).setStatic(true)).setReturnType((Type)Types.STRING);
    }

    static final void annotateDeprecatedIfNecessary(EffectiveStatement<?, ?> stmt, AnnotableTypeBuilder builder) {
        if (stmt instanceof DocumentedNode.WithStatus) {
            Generator.annotateDeprecatedIfNecessary((DocumentedNode.WithStatus)stmt, builder);
        }
    }

    static final void annotateDeprecatedIfNecessary(DocumentedNode.WithStatus node, AnnotableTypeBuilder builder) {
        switch (node.getStatus()) {
            case DEPRECATED: {
                builder.addAnnotation(DEPRECATED_ANNOTATION);
                break;
            }
            case OBSOLETE: {
                builder.addAnnotation(DEPRECATED_ANNOTATION).addParameter("forRemoval", "true");
                break;
            }
            case CURRENT: {
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled status in " + node);
            }
        }
    }

    static final void addUnits(GeneratedTOBuilder builder, TypeDefinition<?> typedef) {
        typedef.getUnits().ifPresent(units -> {
            if (!units.isEmpty()) {
                builder.addConstant((Type)Types.STRING, "_UNITS", (Object)("\"" + units + "\""));
                GeneratedPropertyBuilderImpl prop = new GeneratedPropertyBuilderImpl("UNITS");
                prop.setReturnType((Type)Types.STRING);
                builder.addToStringProperty((GeneratedPropertyBuilder)prop);
            }
        });
    }

    static final void makeSerializable(GeneratedTOBuilder builder) {
        builder.addImplementsType((Type)Types.serializableType());
        Generator.addSerialVersionUID(builder);
    }

    static final void addSerialVersionUID(GeneratedTOBuilder gto) {
        GeneratedPropertyBuilderImpl prop = new GeneratedPropertyBuilderImpl("serialVersionUID");
        prop.setValue(Long.toString(SerialVersionHelper.computeDefaultSUID(gto)));
        gto.setSUID((GeneratedPropertyBuilder)prop);
    }

    static final void narrowImplementedInterface(GeneratedTypeBuilder builder) {
        Generator.defineImplementedInterfaceMethod(builder, (Type)Types.wildcardTypeFor((JavaTypeName)((JavaTypeName)builder.getIdentifier())));
    }

    static final void defaultImplementedInterace(GeneratedTypeBuilder builder) {
        Generator.defineImplementedInterfaceMethod(builder, Type.of((Identifiable)builder)).setDefault(true);
    }

    static final <T extends EffectiveStatement<?, ?>> AbstractExplicitGenerator<T, ?> getChild(Generator parent, Class<T> type) {
        for (Generator child : parent) {
            AbstractExplicitGenerator explicit;
            if (!(child instanceof AbstractExplicitGenerator) || !type.isInstance((explicit = (AbstractExplicitGenerator)child).statement())) continue;
            return explicit;
        }
        throw new IllegalStateException("Cannot find " + type + " in " + parent);
    }

    private static MethodSignatureBuilder defineImplementedInterfaceMethod(GeneratedTypeBuilder typeBuilder, Type classType) {
        MethodSignatureBuilder ret = (MethodSignatureBuilder)((MethodSignatureBuilder)typeBuilder.addMethod("implementedInterface").setAccessModifier(AccessModifier.PUBLIC)).setReturnType((Type)Types.classType((Type)classType));
        ret.addAnnotation(OVERRIDE_ANNOTATION);
        return ret;
    }
}

