/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.Maps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractDependentGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractExplicitGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractTypeAwareGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractTypeObjectGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AugmentRequirement;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CollisionDomain;
import org.opendaylight.mdsal.binding.generator.impl.reactor.Generator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.GeneratorContext;
import org.opendaylight.mdsal.binding.generator.impl.reactor.LinkageProgress;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ModuleAugmentGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.PathExpression;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.spi.ModuleDependencySort;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeneratorReactor
extends GeneratorContext
implements Mutable {
    private static final Logger LOG = LoggerFactory.getLogger(GeneratorReactor.class);
    private final Deque<Iterable<? extends Generator>> stack = new ArrayDeque<Iterable<? extends Generator>>();
    private final @NonNull Map<QNameModule, ModuleGenerator> generators;
    private final @NonNull List<ModuleGenerator> children;
    private final @NonNull SchemaInferenceStack inferenceStack;
    private State state = State.INITIALIZED;

    public GeneratorReactor(EffectiveModelContext context) {
        super(context);
        this.inferenceStack = SchemaInferenceStack.of((EffectiveModelContext)context);
        this.children = ModuleDependencySort.sort((Collection)context.getModules()).stream().map(module -> {
            Verify.verify((boolean)(module instanceof ModuleEffectiveStatement), (String)"Unexpected module %s", (Object)module);
            return new ModuleGenerator((ModuleEffectiveStatement)module);
        }).collect(Collectors.toUnmodifiableList());
        this.generators = Maps.uniqueIndex(this.children, gen -> ((ModuleEffectiveStatement)gen.statement()).localQNameModule());
    }

    public @NonNull Map<QNameModule, ModuleGenerator> execute(TypeBuilderFactory builderFactory) {
        boolean haveUnresolved;
        Stopwatch sw;
        block15: {
            boolean progress;
            switch (this.state) {
                case INITIALIZED: {
                    this.state = State.EXECUTING;
                    break;
                }
                case FINISHED: {
                    return this.generators;
                }
                case EXECUTING: {
                    throw new IllegalStateException("Cannot resume partial execution");
                }
                default: {
                    throw new IllegalStateException("Unhandled state" + this.state);
                }
            }
            sw = Stopwatch.createStarted();
            this.linkUsesDependencies(this.children);
            ArrayList<AugmentRequirement> augments = new ArrayList<AugmentRequirement>();
            for (ModuleGenerator module : this.children) {
                for (Generator gen : module) {
                    if (!(gen instanceof ModuleAugmentGenerator)) continue;
                    augments.add(((ModuleAugmentGenerator)gen).startLinkage(this));
                }
            }
            for (ModuleGenerator module : this.children) {
                module.startUsesAugmentLinkage(augments);
            }
            LOG.trace("Processing linkage of {} augment generators", (Object)augments.size());
            for (ModuleGenerator module : this.children) {
                Verify.verify((boolean)module.linkOriginalGenerator(), (String)"Module %s failed to link", (Object)module);
            }
            ArrayList<ModuleGenerator> unlinkedModules = new ArrayList<ModuleGenerator>(this.children);
            do {
                progress = GeneratorReactor.progressAndClean(unlinkedModules, AbstractCompositeGenerator::linkOriginalGeneratorRecursive) | GeneratorReactor.progressAndClean(augments, AugmentRequirement::resolve);
                if (augments.isEmpty() && unlinkedModules.isEmpty()) break block15;
            } while (progress);
            VerifyException ex = new VerifyException("Failed to make progress on linking of original generators");
            for (AugmentRequirement augment : augments) {
                ex.addSuppressed((Throwable)new IllegalStateException(augment + " is incomplete"));
            }
            for (ModuleGenerator module : unlinkedModules) {
                ex.addSuppressed((Throwable)new IllegalStateException(module + " remains unlinked"));
            }
            throw ex;
        }
        this.linkDependencies(this.children);
        this.bindTypeDefinition(this.children);
        ArrayList<CollisionDomain> domains = new ArrayList<CollisionDomain>();
        this.collectCollisionDomains(domains, this.children);
        do {
            haveUnresolved = false;
            for (CollisionDomain domain : domains) {
                if (!domain.findSolution()) continue;
                haveUnresolved = true;
            }
        } while (haveUnresolved);
        for (ModuleGenerator module : this.children) {
            module.ensureType(builderFactory);
        }
        LOG.debug("Processed {} modules in {}", (Object)this.generators.size(), (Object)sw);
        this.state = State.FINISHED;
        return this.generators;
    }

    private void collectCollisionDomains(List<CollisionDomain> result, Iterable<? extends Generator> parent) {
        for (Generator generator : parent) {
            generator.ensureMember();
            this.collectCollisionDomains(result, generator);
            if (!(generator instanceof AbstractCompositeGenerator)) continue;
            result.add(((AbstractCompositeGenerator)generator).domain());
        }
    }

    @Override
    <E extends EffectiveStatement<QName, ?>, G extends AbstractExplicitGenerator<E, ?>> G resolveTreeScoped(Class<G> type, QName argument) {
        block4: {
            block3: {
                LOG.trace("Searching for tree-scoped argument {} at {}", (Object)argument, this.stack);
                Iterable<? extends Generator> last = this.stack.getLast();
                Verify.verify((boolean)(last instanceof ModuleGenerator), (String)"Unexpected last stack item %s", last);
                if (!argument.getModule().equals((Object)((ModuleEffectiveStatement)((ModuleGenerator)last).statement()).localQNameModule())) break block3;
                for (Iterable<? extends Generator> ancestor : this.stack) {
                    for (Generator generator : ancestor) {
                        AbstractExplicitGenerator cast;
                        if (!type.isInstance(generator) || !argument.equals((cast = (AbstractExplicitGenerator)type.cast(generator)).statement().argument())) continue;
                        LOG.trace("Found matching {}", (Object)generator);
                        return (G)cast;
                    }
                }
                break block4;
            }
            ModuleGenerator module = this.generators.get(argument.getModule());
            if (module == null) break block4;
            for (Generator child : module) {
                AbstractExplicitGenerator abstractExplicitGenerator;
                if (!type.isInstance(child) || !argument.equals((abstractExplicitGenerator = (AbstractExplicitGenerator)type.cast(child)).statement().argument())) continue;
                LOG.trace("Found matching {}", (Object)child);
                return (G)abstractExplicitGenerator;
            }
        }
        throw new IllegalStateException("Could not find " + type + " argument " + argument + " in " + this.stack);
    }

    @Override
    ModuleGenerator resolveModule(QNameModule namespace) {
        ModuleGenerator module = this.generators.get(Objects.requireNonNull(namespace));
        Preconditions.checkState((module != null ? 1 : 0) != 0, (String)"Failed to find module for %s", (Object)namespace);
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    AbstractTypeObjectGenerator<?, ?> resolveLeafref(PathExpression path) {
        LOG.trace("Resolving path {}", (Object)path);
        Verify.verify((boolean)this.inferenceStack.isEmpty(), (String)"Unexpected data tree state %s", (Object)this.inferenceStack);
        try {
            Iterator<Iterable<? extends Generator>> it = this.stack.descendingIterator();
            Verify.verify((boolean)it.hasNext(), (String)"Unexpected empty stack", (Object[])new Object[0]);
            it.next();
            while (it.hasNext()) {
                Iterable<? extends Generator> item = it.next();
                Verify.verify((boolean)(item instanceof Generator), (String)"Unexpected stack item %s", item);
                ((Generator)item).pushToInference(this.inferenceStack);
            }
            AbstractTypeAwareGenerator<?, ?, ?> abstractTypeAwareGenerator = this.inferenceStack.inGrouping() ? this.lenientResolveLeafref(path) : this.strictResolvePath(path);
            return abstractTypeAwareGenerator;
        }
        finally {
            this.inferenceStack.clear();
        }
    }

    private @NonNull AbstractTypeAwareGenerator<?, ?, ?> strictResolvePath(@NonNull PathExpression path) {
        try {
            this.inferenceStack.resolvePathExpression(path);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to find leafref target " + path.getOriginalString(), e);
        }
        return this.mapToGenerator();
    }

    private @Nullable AbstractTypeAwareGenerator<?, ?, ?> lenientResolveLeafref(@NonNull PathExpression path) {
        try {
            this.inferenceStack.resolvePathExpression(path);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Ignoring unresolved path {}", (Object)path, (Object)e);
            return null;
        }
        return this.mapToGenerator();
    }

    private @NonNull AbstractTypeAwareGenerator<?, ?, ?> mapToGenerator() {
        List stmtPath;
        ModuleEffectiveStatement module = this.inferenceStack.currentModule();
        ModuleGenerator gen = (ModuleGenerator)Verify.verifyNotNull((Object)this.generators.get(module.localQNameModule()), (String)"Cannot find generator for %s", (Object[])new Object[]{module});
        AbstractExplicitGenerator<?, ?> found = gen.findGenerator(stmtPath = this.inferenceStack.toInference().statementPath());
        if (found instanceof AbstractTypeAwareGenerator) {
            return (AbstractTypeAwareGenerator)found;
        }
        throw new VerifyException("Statements " + stmtPath + " resulted in unexpected " + found);
    }

    private void linkUsesDependencies(Iterable<? extends Generator> parent) {
        for (Generator generator : parent) {
            if (!(generator instanceof AbstractCompositeGenerator)) continue;
            LOG.trace("Visiting composite {}", (Object)generator);
            AbstractCompositeGenerator composite = (AbstractCompositeGenerator)generator;
            this.stack.push(composite);
            composite.linkUsesDependencies(this);
            this.linkUsesDependencies(composite);
            this.stack.pop();
        }
    }

    private static <T> boolean progressAndClean(List<T> items, Function<T, LinkageProgress> function) {
        boolean progress = false;
        Iterator<T> it = items.iterator();
        while (it.hasNext()) {
            T item = it.next();
            LinkageProgress tmp = function.apply(item);
            if (tmp == LinkageProgress.NONE) {
                LOG.debug("No progress made linking {}", item);
                continue;
            }
            progress = true;
            if (tmp == LinkageProgress.DONE) {
                LOG.debug("Finished linking {}", item);
                it.remove();
                continue;
            }
            LOG.debug("Progress made linking {}", item);
        }
        return progress;
    }

    private void linkDependencies(Iterable<? extends Generator> parent) {
        for (Generator generator : parent) {
            if (generator instanceof AbstractDependentGenerator) {
                ((AbstractDependentGenerator)generator).linkDependencies(this);
                continue;
            }
            if (!(generator instanceof AbstractCompositeGenerator)) continue;
            this.stack.push(generator);
            this.linkDependencies(generator);
            this.stack.pop();
        }
    }

    private void bindTypeDefinition(Iterable<? extends Generator> parent) {
        for (Generator generator : parent) {
            this.stack.push(generator);
            if (generator instanceof AbstractTypeObjectGenerator) {
                ((AbstractTypeObjectGenerator)generator).bindTypeDefinition(this);
            } else if (generator instanceof AbstractCompositeGenerator) {
                this.bindTypeDefinition(generator);
            }
            this.stack.pop();
        }
    }

    private static enum State {
        INITIALIZED,
        EXECUTING,
        FINISHED;

    }
}

