/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractExplicitGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.Generator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.GroupingGenerator;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.GroupingEffectiveStatement;

abstract class MatchStrategy {
    private MatchStrategy() {
    }

    static @NonNull MatchStrategy augment() {
        return OnQName.INSTANCE;
    }

    static @NonNull MatchStrategy grouping(GroupingGenerator grouping) {
        return new Grouping(grouping);
    }

    static @NonNull MatchStrategy identity() {
        return Identity.INSTANCE;
    }

    abstract @Nullable AbstractExplicitGenerator<?, ?> findGenerator(EffectiveStatement<?, ?> var1, Iterable<? extends Generator> var2);

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper;
    }

    private static final class Grouping
    extends OnQName {
        private final @NonNull QNameModule module;

        Grouping(GroupingGenerator grouping) {
            this.module = ((QName)((GroupingEffectiveStatement)grouping.statement()).argument()).getModule();
        }

        @Override
        AbstractExplicitGenerator<?, ?> findGenerator(QName needle, Iterable<? extends Generator> haystack) {
            return super.findGenerator(needle.bindTo(this.module), haystack);
        }

        @Override
        MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return super.addToStringAttributes(helper).add("module", (Object)this.module);
        }
    }

    private static class OnQName
    extends MatchStrategy {
        static final @NonNull OnQName INSTANCE = new OnQName();

        private OnQName() {
        }

        @Override
        final AbstractExplicitGenerator<?, ?> findGenerator(EffectiveStatement<?, ?> needle, Iterable<? extends Generator> haystack) {
            Object arg = needle.argument();
            Verify.verify((boolean)(arg instanceof QName), (String)"Unexpected argument %s in %s", (Object)arg, needle);
            return this.findGenerator((QName)arg, haystack);
        }

        AbstractExplicitGenerator<?, ?> findGenerator(QName needle, Iterable<? extends Generator> haystack) {
            for (Generator generator : haystack) {
                AbstractExplicitGenerator ret;
                if (!(generator instanceof AbstractExplicitGenerator) || !needle.equals((ret = (AbstractExplicitGenerator)generator).statement().argument())) continue;
                return ret;
            }
            return null;
        }
    }

    private static final class Identity
    extends MatchStrategy {
        static final @NonNull Identity INSTANCE = new Identity();

        private Identity() {
        }

        @Override
        AbstractExplicitGenerator<?, ?> findGenerator(EffectiveStatement<?, ?> needle, Iterable<? extends Generator> haystack) {
            for (Generator generator : haystack) {
                AbstractExplicitGenerator ret;
                if (!(generator instanceof AbstractExplicitGenerator) || needle != (ret = (AbstractExplicitGenerator)generator).statement()) continue;
                return ret;
            }
            return null;
        }
    }
}

