/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import java.util.Objects;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ActionGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CompositeSchemaTreeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.mdsal.binding.model.api.ConcreteType;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.runtime.api.CompositeRuntimeType;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

abstract class OperationContainerGenerator<S extends DataTreeEffectiveStatement<?>, R extends CompositeRuntimeType>
extends CompositeSchemaTreeGenerator<S, R> {
    private final ConcreteType baseInterface;

    OperationContainerGenerator(S statement, AbstractCompositeGenerator<?, ?> parent, ConcreteType baseInterface) {
        super(statement, parent);
        this.baseInterface = Objects.requireNonNull(baseInterface);
    }

    @Override
    final void pushToInference(SchemaInferenceStack dataTree) {
        dataTree.enterSchemaTree(((DataTreeEffectiveStatement)this.statement()).getIdentifier());
    }

    @Override
    final GeneratedType createTypeImpl(TypeBuilderFactory builderFactory) {
        AbstractCompositeGenerator<?, ?> parent = this.getParent();
        if (parent instanceof ActionGenerator && ((ActionGenerator)parent).isAddedByUses()) {
            throw new UnsupportedOperationException("Lookup in original");
        }
        GeneratedTypeBuilder builder = builderFactory.newGeneratedTypeBuilder(this.typeName());
        builder.addImplementsType((Type)this.baseInterface);
        OperationContainerGenerator.addAugmentable(builder);
        this.addUsesInterfaces(builder, builderFactory);
        OperationContainerGenerator.addConcreteInterfaceMethods(builder);
        this.addGetterMethods(builder, builderFactory);
        ModuleGenerator module = this.currentModule();
        module.addQNameConstant((GeneratedTypeBuilderBase<?>)builder, this.localName());
        this.annotateDeprecatedIfNecessary((AnnotableTypeBuilder)builder);
        builderFactory.addCodegenInformation(module, (EffectiveStatement<?, ?>)this.statement(), (GeneratedTypeBuilderBase<?>)builder);
        builder.setModuleName(((UnresolvedQName.Unqualified)((ModuleEffectiveStatement)module.statement()).argument()).getLocalName());
        return builder.build();
    }
}

