/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractExplicitGenerator;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;

abstract class OriginalLink<T extends EffectiveStatement<?, ?>, R extends RuntimeType> {
    private OriginalLink() {
    }

    static <T extends EffectiveStatement<?, ?>, R extends RuntimeType> @NonNull OriginalLink<T, R> complete(AbstractExplicitGenerator<T, R> original) {
        return new Complete<T, R>(original);
    }

    static <T extends EffectiveStatement<?, ?>, R extends RuntimeType> @NonNull OriginalLink<T, R> partial(AbstractExplicitGenerator<T, R> previous) {
        return new Partial<T, R>(previous);
    }

    abstract @NonNull AbstractExplicitGenerator<T, R> previous();

    abstract @Nullable AbstractExplicitGenerator<T, R> original();

    abstract MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper var1);

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    private static final class Partial<T extends EffectiveStatement<?, ?>, R extends RuntimeType>
    extends OriginalLink<T, R> {
        private final @NonNull AbstractExplicitGenerator<T, R> previous;
        private AbstractExplicitGenerator<T, R> original;

        Partial(AbstractExplicitGenerator<T, R> previous) {
            this.previous = Objects.requireNonNull(previous);
        }

        @Override
        AbstractExplicitGenerator<T, R> previous() {
            return this.previous;
        }

        @Override
        AbstractExplicitGenerator<T, R> original() {
            OriginalLink<T, R> link;
            if (this.original == null && ((link = this.previous.originalLink()) instanceof Complete || link.previous() != this.previous)) {
                this.original = link.original();
            }
            return this.original;
        }

        @Override
        MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return helper.add("previous", this.previous).add("original", this.original);
        }
    }

    private static final class Complete<T extends EffectiveStatement<?, ?>, R extends RuntimeType>
    extends OriginalLink<T, R> {
        private final @NonNull AbstractExplicitGenerator<T, R> original;

        Complete(AbstractExplicitGenerator<T, R> original) {
            this.original = Objects.requireNonNull(original);
        }

        @Override
        AbstractExplicitGenerator<T, R> previous() {
            return this.original;
        }

        @Override
        @NonNull AbstractExplicitGenerator<T, R> original() {
            return this.original;
        }

        @Override
        MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return helper.add("original", this.original);
        }
    }
}

